/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.astroimageprocessor;

import com.astrofizzbizz.astroimageprocessor.AstroImageProcessorActionListeners;
import com.astrofizzbizz.astroimageprocessor.AstroImageProcessorHelpFrame;
import com.astrofizzbizz.pixie.PixieImage;
import com.astrofizzbizz.pixie.PixieImageException;
import com.astrofizzbizz.pixie.PixieImageRGBPlotterNoSwing;
import com.astrofizzbizz.pixie.SingleSimpleImageProcess;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AstroImageProcessorGui
extends JFrame {
    private static final long serialVersionUID = -1433615005454840487L;
    protected String version = "v3.4.1";
    protected String versionDate = "April 6,2016";
    private static final int RECOMMENDED_HEAP = 768;
    JList status;
    DefaultListModel statusMsgs;
    JLabel statusBar = new JLabel();
    JLabel imageIconLabel = new JLabel();
    JLabel zoomedImageIconLabel = new JLabel();
    JPanel settingsAndImagePanel;
    JPanel imagePanel;
    JPanel settingsPanel;
    JPanel scaleTypePanel;
    JPanel alignPanel;
    JPanel rgbPanel;
    JPanel invertAndColorPanel;
    JSlider[] rgbSlider = new JSlider[3];
    JLabel[] rgbLevelLabel = new JLabel[3];
    JPanel minMaxPanel;
    JSlider[] minMaxSlider = new JSlider[2];
    JLabel[] minMaxLevelLabel = new JLabel[2];
    JRadioButton invertImageButton;
    JRadioButton colorSpectrumButton;
    boolean invertImage = false;
    boolean colorSpectrum = false;
    boolean initializingPanels = true;
    private boolean doingBatchAlign = false;
    private String[] fitsAlignFilePaths;
    private String fitsAlignRefPath = "";
    private int fitsAlignCurrentIdx = -1;
    double[] imageScale = new double[2];
    double[] imageOffset = new double[2];
    int ialignLeftSum = 0;
    int ialignUpSum = 0;
    SingleSimpleImageProcess ssip = null;
    SingleSimpleImageProcess ssipAlignStart = null;
    SingleSimpleImageProcess ssipRef = null;
    SingleSimpleImageProcess[] ssipRgbOrig = new SingleSimpleImageProcess[3];
    SingleSimpleImageProcess[] ssipRgbMod = new SingleSimpleImageProcess[3];
    String ssipFitsFileName = null;
    String subtractFitsFileName = "";
    String normalizeFitsFileName = "";
    String alignFitsFileName = "";
    PixieImage[] pixieImageDisplay = new PixieImage[3];
    boolean disableMenu = false;
    boolean startupScreenDisplayed = true;
    ImageIcon startupDisplay = null;
    String[] fitsExtensions = new String[]{"fits", "fts", "fit"};
    Dimension mouseClick = null;
    Dimension settingsPanelMinimumSize = null;
    AstroImageProcessorHelpFrame helpFrame = null;
    DecimalFormat tp = new DecimalFormat("##.##");
    private String lastDirectoryPath = null;
    int scaleType = 3;
    ActionListener resizeTimer = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            AstroImageProcessorGui.this.windowResized();
            AstroImageProcessorGui.this.tResize.stop();
        }
    };
    public Timer tResize = new Timer(250, this.resizeTimer);

    public AstroImageProcessorGui(String jFrameTitle) {
        super(jFrameTitle);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setupDisplay();
        this.getContentPane().add((Component)this.settingsAndImagePanel, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
        this.setVisible(true);
        this.toFront();
        this.repaint();
        this.setDefaultCloseOperation(3);
        this.setExtendedState(this.getExtendedState() | 6);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String iconLoc = "com/astrofizzbizz/astroimageprocessor/files/StoneEdgeTelescopeLogo.jpg";
        String startupImageLoc = "com/astrofizzbizz/astroimageprocessor/files/StoneEdgeImages.jpg";
        URL resourceURL = loader.getResource(startupImageLoc);
        resourceURL = loader.getResource(iconLoc);
        this.setIconImage(new ImageIcon(resourceURL).getImage());
        this.addComponentListener(new AstroImageProcessorActionListeners("frameResized", this));
        this.setMinimumSize(new Dimension(600, 400));
        int heapSizeMegs = (int)(Runtime.getRuntime().maxMemory() / 1024L) / 1024;
        if (heapSizeMegs < 768) {
            String message = "Max Memory size = " + heapSizeMegs + " MB\n";
            message = String.valueOf(message) + "Recommend size = " + 768 + " MB\n";
            message = String.valueOf(message) + "Might have trouble aligning or making RGB plots for large images";
            this.messageDialog(message);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    private void setupDisplay() {
        this.setJMenuBar(this.addMenu());
        this.settingsPanel = new JPanel();
        this.settingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Settings"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 3));
        this.setupScaleTypePanel();
        this.setupInvertAndColorPanel();
        this.setupAlignPanel();
        this.setupRgbPanel();
        this.setupMinMaxSliderPanel();
        this.settingsPanel.add(this.scaleTypePanel);
        this.settingsPanel.add(this.invertAndColorPanel);
        this.settingsPanel.add(this.minMaxPanel);
        this.settingsPanel.add(this.rgbPanel);
        this.settingsPanel.add(this.alignPanel);
        JPanel statusPanel = new JPanel();
        statusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Status"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        statusPanel.setLayout(new BoxLayout(statusPanel, 3));
        this.statusMsgs = new DefaultListModel();
        this.status = new JList(this.statusMsgs);
        JScrollPane statusScroll = new JScrollPane(this.status){

            @Override
            public Dimension getPreferredSize() {
                Dimension pref = super.getPreferredSize();
                Dimension max = super.getMaximumSize();
                if (pref.height > max.height) {
                    pref.height = max.height;
                }
                if (pref.width > max.width) {
                    pref.width = max.width;
                }
                return pref;
            }
        };
        statusScroll.setVerticalScrollBarPolicy(22);
        statusScroll.setHorizontalScrollBarPolicy(32);
        statusScroll.setMaximumSize(new Dimension(300, 100));
        statusPanel.add(statusScroll);
        this.settingsPanel.add(statusPanel);
        JPanel zoomedImagePanel = new JPanel();
        zoomedImagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Zoom"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        zoomedImagePanel.setLayout(new FlowLayout());
        zoomedImagePanel.add(this.zoomedImageIconLabel);
        this.settingsPanel.add(zoomedImagePanel);
        this.settingsPanelMinimumSize = new Dimension(this.settingsPanel.getMinimumSize());
        this.settingsPanel.setMaximumSize(new Dimension(this.settingsPanelMinimumSize.width, 1500));
        this.alignPanel.setVisible(false);
        this.rgbPanel.setVisible(false);
        this.imageIconLabel = new JLabel();
        this.imageIconLabel.addMouseListener(new AstroImageProcessorActionListeners("mouseClickedOnImage", this));
        this.imagePanel = new JPanel();
        this.imagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.imagePanel.add(this.imageIconLabel);
        this.settingsAndImagePanel = new JPanel();
        this.settingsAndImagePanel.setLayout(new BoxLayout(this.settingsAndImagePanel, 0));
        this.settingsAndImagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JScrollPane settingsScrollPane = new JScrollPane(this.settingsPanel);
        settingsScrollPane.setHorizontalScrollBarPolicy(31);
        settingsScrollPane.setMaximumSize(new Dimension(this.settingsPanelMinimumSize.width + 10, 1500));
        this.settingsAndImagePanel.add(settingsScrollPane);
        this.settingsAndImagePanel.add(this.imagePanel);
        this.statusBar.setText("Version " + this.version + " - " + this.versionDate);
        this.initializingPanels = false;
    }

    private void statusMsg(String msg) {
        this.statusMsgs.addElement(msg);
        this.status.setSelectedIndex(this.statusMsgs.size() - 1);
        this.status.ensureIndexIsVisible(this.status.getSelectedIndex());
        this.status.paintImmediately(this.status.getBounds());
    }

    private void clearStatusMsg() {
        this.statusMsgs.clear();
        this.status.paintImmediately(this.status.getBounds());
    }

    private void setupScaleTypePanel() {
        this.scaleTypePanel = new JPanel();
        JRadioButton[] scaleTypeButton = new JRadioButton[4];
        this.scaleTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Transfer Function"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.scaleTypePanel.setLayout(new FlowLayout());
        scaleTypeButton[0] = new JRadioButton("Linear");
        scaleTypeButton[1] = new JRadioButton("Sqrt");
        scaleTypeButton[2] = new JRadioButton("Log");
        scaleTypeButton[3] = new JRadioButton("Asinh");
        scaleTypeButton[0].addActionListener(new AstroImageProcessorActionListeners("linearScale", this));
        scaleTypeButton[1].addActionListener(new AstroImageProcessorActionListeners("sqrtScale", this));
        scaleTypeButton[2].addActionListener(new AstroImageProcessorActionListeners("logScale", this));
        scaleTypeButton[3].addActionListener(new AstroImageProcessorActionListeners("asinhScale", this));
        ButtonGroup graphicsTypeButtonGroup = new ButtonGroup();
        graphicsTypeButtonGroup.add(scaleTypeButton[0]);
        graphicsTypeButtonGroup.add(scaleTypeButton[1]);
        graphicsTypeButtonGroup.add(scaleTypeButton[2]);
        graphicsTypeButtonGroup.add(scaleTypeButton[3]);
        this.scaleTypePanel.add(scaleTypeButton[0]);
        this.scaleTypePanel.add(scaleTypeButton[1]);
        this.scaleTypePanel.add(scaleTypeButton[2]);
        this.scaleTypePanel.add(scaleTypeButton[3]);
        if (this.scaleType == 0) {
            scaleTypeButton[0].setSelected(true);
        }
        if (this.scaleType == 3) {
            scaleTypeButton[1].setSelected(true);
        }
        if (this.scaleType == 1) {
            scaleTypeButton[2].setSelected(true);
        }
        if (this.scaleType == 4) {
            scaleTypeButton[3].setSelected(true);
        }
    }

    private void setupInvertAndColorPanel() {
        this.invertImage = false;
        this.colorSpectrum = false;
        this.invertAndColorPanel = new JPanel();
        this.invertAndColorPanel.setLayout(new BoxLayout(this.invertAndColorPanel, 0));
        this.invertAndColorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.invertImageButton = new JRadioButton("Invert Image");
        this.invertImageButton.setSelected(false);
        this.invertImageButton.addActionListener(new AstroImageProcessorActionListeners("invertImage", this));
        this.invertAndColorPanel.add(this.invertImageButton);
        this.colorSpectrumButton = new JRadioButton("Color Spectrum");
        this.colorSpectrumButton.setSelected(false);
        this.colorSpectrumButton.addActionListener(new AstroImageProcessorActionListeners("colorSpectrum", this));
        this.invertAndColorPanel.add(this.colorSpectrumButton);
    }

    private void setupAlignPanel() {
        this.alignPanel = new JPanel();
        this.alignPanel.setLayout(new BoxLayout(this.alignPanel, 1));
        this.alignPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Align"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel[] buttonPanel = new JPanel[3];
        int ii = 0;
        while (ii < 3) {
            buttonPanel[ii] = new JPanel();
            buttonPanel[ii].setLayout(new FlowLayout());
            ++ii;
        }
        JButton moveUpButton = new JButton(" Up ");
        moveUpButton.addActionListener(new AstroImageProcessorActionListeners("MoveUpButton", this));
        buttonPanel[0].add(moveUpButton);
        JButton moveDownButton = new JButton("Down");
        moveDownButton.addActionListener(new AstroImageProcessorActionListeners("MoveDownButton", this));
        buttonPanel[2].add(moveDownButton);
        JButton moveLeftButton = new JButton("Left");
        moveLeftButton.addActionListener(new AstroImageProcessorActionListeners("MoveLeftButton", this));
        buttonPanel[1].add(moveLeftButton);
        JButton moveRightButton = new JButton("Right");
        moveRightButton.addActionListener(new AstroImageProcessorActionListeners("MoveRightButton", this));
        buttonPanel[1].add(moveRightButton);
        JPanel allButtonPanel = new JPanel();
        allButtonPanel.setLayout(new BoxLayout(allButtonPanel, 1));
        allButtonPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        allButtonPanel.add(buttonPanel[0]);
        allButtonPanel.add(buttonPanel[1]);
        allButtonPanel.add(buttonPanel[2]);
        this.alignPanel.add(allButtonPanel);
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new AstroImageProcessorActionListeners("SaveAlignButton", this));
        JButton closeButton = new JButton("Close Align");
        closeButton.addActionListener(new AstroImageProcessorActionListeners("CloseAlignButton", this));
        JPanel saveQuitPanel = new JPanel();
        saveQuitPanel.setLayout(new FlowLayout());
        saveQuitPanel.add(saveButton);
        saveQuitPanel.add(closeButton);
        this.alignPanel.add(saveQuitPanel);
    }

    void setupRgbPanel() {
        JPanel rgbSliderPanel = new JPanel();
        rgbSliderPanel.setLayout(new GridLayout(1, 3));
        AstroImageProcessorActionListeners[] rgbSliderListen = new AstroImageProcessorActionListeners[3];
        JPanel[] singleRgbSliderPanel = new JPanel[3];
        JLabel[] colorTitle = new JLabel[]{new JLabel("Red"), new JLabel("Green"), new JLabel("Blue")};
        int ii = 0;
        while (ii < 3) {
            singleRgbSliderPanel[ii] = new JPanel();
            singleRgbSliderPanel[ii].setLayout(new BoxLayout(singleRgbSliderPanel[ii], 1));
            this.rgbSlider[ii] = new JSlider(1, -100, 100, 0);
            rgbSliderListen[ii] = new AstroImageProcessorActionListeners("RGB " + ii + " Slider Changed", this);
            this.rgbSlider[ii].addChangeListener(rgbSliderListen[ii]);
            this.rgbSlider[ii].setMinimumSize(new Dimension(20, 100));
            this.rgbSlider[ii].setMajorTickSpacing(100);
            this.rgbSlider[ii].setMinorTickSpacing(100);
            this.rgbSlider[ii].setPaintTicks(true);
            this.rgbSlider[ii].setPaintLabels(false);
            this.rgbSlider[ii].setSnapToTicks(false);
            this.rgbLevelLabel[ii] = new JLabel("1.0");
            singleRgbSliderPanel[ii].add(this.rgbSlider[ii]);
            singleRgbSliderPanel[ii].add(colorTitle[ii]);
            singleRgbSliderPanel[ii].add(this.rgbLevelLabel[ii]);
            rgbSliderPanel.add(singleRgbSliderPanel[ii]);
            ++ii;
        }
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new AstroImageProcessorActionListeners("SaveRgbButton", this));
        JButton closeButton = new JButton("Close RGB");
        closeButton.addActionListener(new AstroImageProcessorActionListeners("CloseRgbButton", this));
        JPanel saveQuitPanel = new JPanel();
        saveQuitPanel.setLayout(new FlowLayout());
        saveQuitPanel.add(saveButton);
        saveQuitPanel.add(closeButton);
        this.rgbPanel = new JPanel();
        this.rgbPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("RGB Colors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.rgbPanel.setLayout(new BoxLayout(this.rgbPanel, 1));
        this.rgbPanel.add(rgbSliderPanel);
        this.rgbPanel.add(saveQuitPanel);
    }

    private void setupMinMaxSliderPanel() {
        JPanel minMaxSliderPanel = new JPanel();
        minMaxSliderPanel.setLayout(new GridLayout(2, 1));
        AstroImageProcessorActionListeners[] minMaxSliderListen = new AstroImageProcessorActionListeners[2];
        JPanel[] singleMinMaxSliderPanel = new JPanel[2];
        JLabel[] minMaxTitle = new JLabel[]{new JLabel("Min"), new JLabel("Max"), new JLabel("Blue")};
        int ii = 0;
        while (ii < 2) {
            singleMinMaxSliderPanel[ii] = new JPanel();
            singleMinMaxSliderPanel[ii].setLayout(new BoxLayout(singleMinMaxSliderPanel[ii], 0));
            this.minMaxSlider[ii] = new JSlider(0, 0, 100, 0);
            minMaxSliderListen[ii] = new AstroImageProcessorActionListeners("minMax " + ii + " Slider Changed", this);
            this.minMaxSlider[ii].addChangeListener(minMaxSliderListen[ii]);
            this.minMaxSlider[ii].setMajorTickSpacing(100);
            this.minMaxSlider[ii].setMinorTickSpacing(25);
            this.minMaxSlider[ii].setPaintTicks(true);
            this.minMaxSlider[ii].setPaintLabels(true);
            this.minMaxSlider[ii].setSnapToTicks(false);
            this.minMaxLevelLabel[ii] = new JLabel("0.0");
            singleMinMaxSliderPanel[ii].add(minMaxTitle[ii]);
            singleMinMaxSliderPanel[ii].add(this.minMaxSlider[ii]);
            singleMinMaxSliderPanel[ii].add(this.minMaxLevelLabel[ii]);
            minMaxSliderPanel.add(singleMinMaxSliderPanel[ii]);
            ++ii;
        }
        this.minMaxSlider[0].setValue(0);
        this.minMaxSlider[1].setValue(100);
        this.minMaxLevelLabel[1].setText("100.0");
        this.minMaxPanel = new JPanel();
        this.minMaxPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Scale"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.minMaxPanel.setLayout(new GridLayout(1, 1));
        this.minMaxPanel.add(minMaxSliderPanel);
    }

    private JMenuBar addMenu() {
        JMenuBar menuBar = new JMenuBar();
        String[] menuText = new String[]{"File", "Clean", "Action", "RGB Plot", "Help"};
        String[][] itemText = new String[][]{{"Open", "Save as FITS", "Save as PNG", "Exit"}, {"Remove Hot Spots"}, {"Add", "Subtract", "Divide", "Normalize", "Align"}, {"Create RGB Plot", "RGB Plot Wizard"}, {"Help", "YouTube Video", "About"}};
        int i = 0;
        while (i < menuText.length) {
            JMenu menu = new JMenu(menuText[i]);
            menuBar.add(menu);
            int j = 0;
            while (j < itemText[i].length) {
                JMenuItem item = new JMenuItem(itemText[i][j]);
                menu.add(item);
                item.addActionListener(new AstroImageProcessorActionListeners(String.valueOf(menuText[i]) + "." + itemText[i][j], this));
                if (itemText[i][j].equals("Open")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
                }
                if (itemText[i][j].equals("Save as FITS")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(83, 2));
                }
                if (itemText[i][j].equals("Exit")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(81, 2));
                }
                if (itemText[i][j].equals("Add")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(80, 2));
                }
                if (itemText[i][j].equals("Subtract")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(77, 2));
                }
                if (itemText[i][j].equals("Divide")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(68, 2));
                }
                if (itemText[i][j].equals("Remove Hot Spots")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(72, 2));
                }
                if (itemText[i][j].equals("Normalize")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(78, 2));
                }
                if (itemText[i][j].equals("Align")) {
                    item.setAccelerator(KeyStroke.getKeyStroke(65, 2));
                }
                ++j;
            }
            ++i;
        }
        return menuBar;
    }

    public void openFitsFile() {
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Open Fits File", "", false, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssip = new SingleSimpleImageProcess(fitsFile.getPath());
            this.ssipFitsFileName = fitsFile.getName();
            this.pixieImageDisplay = this.ssip.createRGBPixieImage();
            this.mouseClick = new Dimension(this.pixieImageDisplay[0].getColCount() / 2, this.pixieImageDisplay[0].getRowCount() / 2);
        }
        catch (PixieImageException e) {
            this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
            return;
        }
        this.displayFitsFile();
        this.statusBar.setText("Opened " + this.ssipFitsFileName);
    }

    String removeExtension(String fileName) {
        String stripName = fileName.substring(0, fileName.lastIndexOf("."));
        return stripName;
    }

    FileNameExtensionFilter makeFileNameExtensionFilter(String[] extensions) {
        int numExtensions = 0;
        int ii = 0;
        while (ii < extensions.length) {
            if (extensions[ii] != null) {
                ++numExtensions;
            }
            ++ii;
        }
        String[] nne = new String[numExtensions];
        int iext = 0;
        String extensionDesc = "";
        int ii2 = 0;
        while (ii2 < extensions.length) {
            if (extensions[ii2] != null) {
                nne[iext] = extensions[ii2];
                if (iext == 0) {
                    extensionDesc = String.valueOf(extensionDesc) + "*." + extensions[ii2];
                }
                if (iext > 0) {
                    extensionDesc = String.valueOf(extensionDesc) + ", *." + extensions[ii2];
                }
                ++iext;
            }
            ++ii2;
        }
        if (numExtensions == 1) {
            return new FileNameExtensionFilter(extensionDesc, nne[0]);
        }
        if (numExtensions == 2) {
            return new FileNameExtensionFilter(extensionDesc, nne[0], nne[1]);
        }
        if (numExtensions == 3) {
            return new FileNameExtensionFilter(extensionDesc, nne[0], nne[1], nne[2]);
        }
        if (numExtensions >= 4) {
            return new FileNameExtensionFilter(extensionDesc, nne[0], nne[1], nne[2], nne[3]);
        }
        return null;
    }

    public File chooseFile(String directoryPath, String dialogTitle, String selectedFileName, boolean saveDialog, String[] extensions) {
        File file = null;
        JFileChooser fc = null;
        fc = directoryPath != null ? new JFileChooser(directoryPath) : new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File(selectedFileName));
        fc.setAcceptAllFileFilterUsed(false);
        fc.addChoosableFileFilter(this.makeFileNameExtensionFilter(extensions));
        fc.setDialogTitle(dialogTitle);
        int returnVal = 0;
        returnVal = saveDialog ? fc.showSaveDialog(this) : fc.showOpenDialog(this);
        if (returnVal == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }

    void saveFitsFile() {
        if (this.ssip == null) {
            this.messageDialog("Nothing to save");
            return;
        }
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Save Fits File", this.ssipFitsFileName, true, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssip.writeOutFitsFile(fitsFile.getPath());
        }
        catch (PixieImageException e) {
            this.messageDialog("Can't Save File\nSorry!");
            return;
        }
    }

    void savePngFile(String suggestedName) {
        String[] pngFileExtension = new String[]{"png"};
        File pngFile = this.chooseFile(this.lastDirectoryPath, "Save PNG File", suggestedName, true, pngFileExtension);
        if (pngFile == null) {
            return;
        }
        this.lastDirectoryPath = pngFile.getPath();
        PixieImageRGBPlotterNoSwing plotter = null;
        try {
            plotter = SingleSimpleImageProcess.threeColor(this.pixieImageDisplay[0], this.pixieImageDisplay[1], this.pixieImageDisplay[2], this.scaleType, this.minMaxSlider[0].getValue(), this.minMaxSlider[1].getValue());
        }
        catch (PixieImageException e) {
            this.messageDialog("Can't Save File\nSorry!");
        }
        this.setCursor(new Cursor(3));
        plotter.toPNGFile(pngFile);
        this.setCursor(new Cursor(0));
    }

    void saveFitsToPng() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        String suggestedName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + ".png";
        this.savePngFile(suggestedName);
    }

    void displayStartUpScreen(ImageIcon imageIcon) {
    }

    void displayFitsFile() {
        this.setCursor(new Cursor(3));
        if (this.ssip == null && this.ssipRgbMod == null) {
            this.setCursor(new Cursor(0));
            return;
        }
        this.startupScreenDisplayed = false;
        PixieImageRGBPlotterNoSwing plotter = null;
        try {
            plotter = SingleSimpleImageProcess.threeColor(this.pixieImageDisplay[0], this.pixieImageDisplay[1], this.pixieImageDisplay[2], this.scaleType, this.minMaxSlider[0].getValue(), this.minMaxSlider[1].getValue());
        }
        catch (PixieImageException e) {
            this.setCursor(new Cursor(0));
            e.printStackTrace();
        }
        plotter.setColorSpectrum(this.colorSpectrum);
        plotter.setInvertImage(this.invertImage);
        BufferedImage biOrig = plotter.makeBufferedImage();
        int iheightH = this.getHeight() - 150;
        int iwidthH = iheightH * biOrig.getWidth();
        int iwidthW = this.getWidth() - this.settingsPanel.getWidth() - 50;
        int iheightW = iwidthW * biOrig.getHeight();
        int imageWidth = iwidthH /= biOrig.getHeight();
        int imageHeight = iheightH;
        if (iwidthW < iwidthH || (iheightW /= biOrig.getWidth()) < iheightH) {
            imageWidth = iwidthW;
            imageHeight = iheightW;
        }
        int rows = this.pixieImageDisplay[0].getRowCount();
        int cols = this.pixieImageDisplay[0].getColCount();
        this.imageScale[0] = (double)cols / (double)imageWidth;
        this.imageScale[1] = -((double)rows) / (double)imageHeight;
        this.imageOffset[0] = 0.0;
        this.imageOffset[1] = -((double)imageHeight);
        BufferedImage bi = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics2D = bi.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(plotter.makeBufferedImage(), 0, 0, imageWidth, imageHeight, null);
        this.imageIconLabel.setIcon(new ImageIcon(bi));
        this.makeZoomedImage(10.0, this.settingsPanelMinimumSize.width, plotter);
        this.setCursor(new Cursor(0));
    }

    void subtractFitsFile() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Open Fits File To Subtract", this.subtractFitsFileName, false, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssip.subtractImage(fitsFile.getPath());
            this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_sub.fits";
            this.subtractFitsFileName = fitsFile.getName();
        }
        catch (PixieImageException e) {
            this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
            return;
        }
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void addFitsFile() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Open Fits File To Add", "", false, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssip.addImage(fitsFile.getPath());
            this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_add.fits";
        }
        catch (PixieImageException e) {
            this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
            return;
        }
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void divideFitsFile() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Open Fits File To Divide", "", false, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssip.divideImage(fitsFile.getPath());
            this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_div.fits";
        }
        catch (PixieImageException e) {
            this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
            return;
        }
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void removeMean() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        this.ssip.subtractMean();
        this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_meanR.fits";
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void removeHotspots() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        this.ssip.removeHotSpots();
        this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_hspotR.fits";
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void normalize() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Open Fits File To Normalize To", this.normalizeFitsFileName, false, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssip.normalize(fitsFile.getPath());
            this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_norm.fits";
            this.normalizeFitsFileName = fitsFile.getName();
        }
        catch (PixieImageException e) {
            this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
            return;
        }
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void align() {
        if (this.ssip == null) {
            this.messageDialog("Open a file first!");
            return;
        }
        File fitsFile = this.chooseFile(this.lastDirectoryPath, "Open Fits File To Align To", this.alignFitsFileName, false, this.fitsExtensions);
        if (fitsFile == null) {
            return;
        }
        this.lastDirectoryPath = fitsFile.getPath();
        try {
            this.ssipRef = new SingleSimpleImageProcess(fitsFile.getPath());
            this.pixieImageDisplay[0] = this.ssip.getPixieImage();
            this.pixieImageDisplay[1] = this.ssipRef.getPixieImage();
            this.pixieImageDisplay[2] = this.ssipRef.getPixieImage();
            this.ssipFitsFileName = String.valueOf(this.removeExtension(this.ssipFitsFileName)) + "_align.fits";
            this.alignFitsFileName = fitsFile.getName();
        }
        catch (PixieImageException e) {
            this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
            return;
        }
        this.ialignLeftSum = 0;
        this.ialignUpSum = 0;
        try {
            this.ssipAlignStart = new SingleSimpleImageProcess(this.ssip);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
        this.alignPanel.setVisible(true);
        this.disableMenu = true;
        this.displayFitsFile();
        this.statusBar.setText("Fits File Suggested Name " + this.ssipFitsFileName);
    }

    void align(String fitsRefFilePath) {
        if (this.ssip == null) {
            return;
        }
        try {
            this.ssipRef = new SingleSimpleImageProcess(fitsRefFilePath);
            this.pixieImageDisplay[0] = this.ssip.getPixieImage();
            this.pixieImageDisplay[1] = this.ssipRef.getPixieImage();
            this.pixieImageDisplay[2] = this.ssipRef.getPixieImage();
        }
        catch (PixieImageException e) {
            this.messageDialog("Error. Unknown FITS format.");
            return;
        }
        this.ialignLeftSum = 0;
        this.ialignUpSum = 0;
        try {
            this.ssipAlignStart = new SingleSimpleImageProcess(this.ssip);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
        this.alignPanel.setVisible(true);
        this.disableMenu = true;
        this.displayFitsFile();
    }

    void plotAlignedImages(int ileft, int iup) {
        this.ialignLeftSum += ileft;
        this.ialignUpSum += iup;
        try {
            this.ssip = new SingleSimpleImageProcess(this.ssipAlignStart);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
        this.ssip.shiftImage(this.ialignLeftSum, this.ialignUpSum);
        this.pixieImageDisplay[0] = this.ssip.getPixieImage();
        this.pixieImageDisplay[1] = this.ssipRef.getPixieImage();
        this.pixieImageDisplay[2] = this.ssipRef.getPixieImage();
        this.displayFitsFile();
    }

    void saveAlignedImages(boolean saveImages) {
        if (this.doingBatchAlign) {
            if (!saveImages) {
                this.doingBatchAlign = false;
                this.statusMsg("RGB plot wizard aborted!");
                this.alignPanel.setVisible(false);
                this.disableMenu = false;
                return;
            }
            try {
                this.ssip.writeOutFitsFile(this.fitsAlignFilePaths[this.fitsAlignCurrentIdx]);
            }
            catch (PixieImageException e) {
                this.messageDialog("Error saving normalized FITS file to " + this.fitsAlignFilePaths[this.fitsAlignCurrentIdx]);
                return;
            }
            ++this.fitsAlignCurrentIdx;
            this.alignPanel.setVisible(false);
            this.disableMenu = false;
            this.pixieImageDisplay[0] = this.ssip.getPixieImage();
            this.pixieImageDisplay[1] = this.ssip.getPixieImage();
            this.pixieImageDisplay[2] = this.ssip.getPixieImage();
            this.displayFitsFile();
            this.rgbPlotWizard();
        } else {
            if (saveImages) {
                this.saveFitsFile();
            }
            this.alignPanel.setVisible(false);
            this.disableMenu = false;
            this.pixieImageDisplay[0] = this.ssip.getPixieImage();
            this.pixieImageDisplay[1] = this.ssip.getPixieImage();
            this.pixieImageDisplay[2] = this.ssip.getPixieImage();
            this.displayFitsFile();
        }
    }

    void rgbPlot() {
        this.colorSpectrum = false;
        this.invertImage = false;
        this.colorSpectrumButton.setSelected(false);
        this.invertImageButton.setSelected(false);
        String[] directions = new String[]{"Open Fits Red File", "Open Fits Green File", "Open Fits Blue File"};
        int ii = 0;
        while (ii < 3) {
            File fitsFile = this.chooseFile(this.lastDirectoryPath, directions[ii], "", false, this.fitsExtensions);
            if (fitsFile == null) {
                return;
            }
            this.lastDirectoryPath = fitsFile.getPath();
            try {
                this.ssipRgbOrig[ii] = new SingleSimpleImageProcess(fitsFile.getPath());
                this.ssip = this.ssipRgbOrig[ii];
            }
            catch (PixieImageException e1) {
                this.messageDialog("Weird fits format.\nCan't open File\nSorry!");
                return;
            }
            this.pixieImageDisplay[0] = this.ssipRgbOrig[ii].getPixieImage();
            this.pixieImageDisplay[1] = this.ssipRgbOrig[ii].getPixieImage();
            this.pixieImageDisplay[2] = this.ssipRgbOrig[ii].getPixieImage();
            this.mouseClick = new Dimension(this.pixieImageDisplay[0].getColCount() / 2, this.pixieImageDisplay[0].getRowCount() / 2);
            this.displayFitsFile();
            ++ii;
        }
        ii = 0;
        while (ii < 3) {
            this.pixieImageDisplay[ii] = this.ssipRgbOrig[ii].getPixieImage();
            this.rgbSlider[ii].setValue(0);
            this.rgbLevelLabel[ii].setText("1.0");
            ++ii;
        }
        this.rgbPanel.setVisible(true);
        this.disableMenu = true;
        this.displayFitsFile();
    }

    void rgbPlotWizard() {
        this.colorSpectrum = false;
        this.invertImage = false;
        this.colorSpectrumButton.setSelected(false);
        this.invertImageButton.setSelected(false);
        if (this.doingBatchAlign) {
            if (this.fitsAlignCurrentIdx < 3) {
                try {
                    this.ssip = new SingleSimpleImageProcess(this.fitsAlignFilePaths[this.fitsAlignCurrentIdx]);
                    this.fitsAlignFilePaths[this.fitsAlignCurrentIdx] = String.valueOf(this.removeExtension(this.fitsAlignFilePaths[this.fitsAlignCurrentIdx])) + "_align.fits";
                    this.pixieImageDisplay = this.ssip.createRGBPixieImage();
                    this.mouseClick = new Dimension(this.pixieImageDisplay[0].getColCount() / 2, this.pixieImageDisplay[0].getRowCount() / 2);
                }
                catch (PixieImageException e1) {
                    this.doingBatchAlign = false;
                    this.statusMsg("RGB plot wizard aborted!");
                    this.messageDialog("Error. Unknown FITS format.");
                    return;
                }
                this.align(this.fitsAlignRefPath);
                this.statusMsg("Align image 2 of 2, then click \"Save\".");
                return;
            }
            int ii = 0;
            while (ii < 3) {
                try {
                    this.ssipRgbOrig[ii] = new SingleSimpleImageProcess(this.fitsAlignFilePaths[ii]);
                }
                catch (PixieImageException e1) {
                    this.doingBatchAlign = false;
                    this.statusMsg("RGB plot wizard aborted!");
                    this.messageDialog("Error. Unknown FITS format.");
                    return;
                }
                ++ii;
            }
            ii = 0;
            while (ii < 3) {
                this.pixieImageDisplay[ii] = this.ssipRgbOrig[ii].getPixieImage();
                this.rgbSlider[ii].setValue(0);
                this.rgbLevelLabel[ii].setText("1.0");
                ++ii;
            }
            this.doingBatchAlign = false;
            this.rgbPanel.setVisible(true);
            this.disableMenu = true;
            this.displayFitsFile();
            this.statusMsg("Adjust RGB values, then click \"Save\".");
        } else {
            String[] directions = new String[]{"red", "green", "blue", "reference"};
            String[] fitsFilePaths = new String[4];
            String[] fitsNormalizedFilePaths = new String[4];
            this.clearStatusMsg();
            this.statusMsg("Starting RGB Plot wizard...");
            int ii = 0;
            while (ii < 4) {
                File fitsFile = this.chooseFile(this.lastDirectoryPath, "Please open " + directions[ii] + " .fits file.", "", false, this.fitsExtensions);
                if (fitsFile == null) {
                    this.statusMsg("RGB plot wizard aborted!");
                    return;
                }
                this.statusMsg("Opened " + fitsFile.getPath());
                this.lastDirectoryPath = fitsFilePaths[ii] = fitsFile.getPath();
                ++ii;
            }
            this.statusMsg("Cleaning and normalizing images...");
            this.setCursor(new Cursor(3));
            ii = 0;
            while (ii < 3) {
                try {
                    this.ssip = new SingleSimpleImageProcess(fitsFilePaths[ii]);
                }
                catch (PixieImageException e1) {
                    this.statusMsg("RGB plot wizard aborted!");
                    this.messageDialog("Error. Unknown FITS format.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                try {
                    this.ssip.removeHotSpots();
                }
                catch (Exception e) {
                    this.statusMsg("RGB plot wizard aborted!");
                    this.messageDialog("Error. Unknown FITS format.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.statusMsg("Cleaned " + fitsFilePaths[ii]);
                try {
                    this.ssip.normalize(fitsFilePaths[3]);
                    fitsNormalizedFilePaths[ii] = String.valueOf(this.removeExtension(fitsFilePaths[ii])) + "_norm.fits";
                }
                catch (PixieImageException e) {
                    this.statusMsg("RGB plot wizard aborted!");
                    this.messageDialog("Error. Unknown FITS format.");
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.statusMsg("Normalized " + fitsFilePaths[ii]);
                this.statusMsg("Saving " + fitsNormalizedFilePaths[ii] + "...");
                try {
                    this.ssip.writeOutFitsFile(fitsNormalizedFilePaths[ii]);
                }
                catch (PixieImageException e) {
                    this.statusMsg("RGB plot wizard aborted!");
                    this.messageDialog("Error saving normalized FITS file to " + fitsNormalizedFilePaths[ii]);
                    this.setCursor(new Cursor(0));
                    return;
                }
                this.statusMsg("Saved " + fitsFilePaths[ii]);
                ++ii;
            }
            this.setCursor(new Cursor(0));
            this.doingBatchAlign = true;
            this.fitsAlignCurrentIdx = 1;
            this.fitsAlignFilePaths = new String[3];
            ii = 0;
            while (ii < 3) {
                this.fitsAlignFilePaths[ii] = fitsNormalizedFilePaths[ii];
                ++ii;
            }
            this.fitsAlignRefPath = fitsFilePaths[3];
            try {
                this.ssip = new SingleSimpleImageProcess(this.fitsAlignFilePaths[this.fitsAlignCurrentIdx]);
                this.fitsAlignFilePaths[this.fitsAlignCurrentIdx] = String.valueOf(this.removeExtension(this.fitsAlignFilePaths[this.fitsAlignCurrentIdx])) + "_align.fits";
                this.pixieImageDisplay = this.ssip.createRGBPixieImage();
                this.mouseClick = new Dimension(this.pixieImageDisplay[0].getColCount() / 2, this.pixieImageDisplay[0].getRowCount() / 2);
            }
            catch (PixieImageException e1) {
                this.messageDialog("Error. Unknown FITS format.");
                this.doingBatchAlign = false;
                this.statusMsg("RGB plot wizard aborted!");
                return;
            }
            this.align(this.fitsAlignRefPath);
            this.statusMsg("Align image 1 of 2, then press \"Save\".");
        }
    }

    protected void rgbSliderChanged(int islider) {
        if (this.rgbSlider[islider].getValueIsAdjusting()) {
            return;
        }
        int ii = 0;
        while (ii < 3) {
            double sliderValue = this.rgbSlider[ii].getValue();
            sliderValue = Math.pow(10.0, sliderValue / 100.0);
            this.rgbLevelLabel[ii].setText(this.tp.format(sliderValue));
            try {
                this.ssipRgbMod[ii] = new SingleSimpleImageProcess(this.ssipRgbOrig[ii]);
                this.ssipRgbMod[ii].gainAdjust(sliderValue);
            }
            catch (PixieImageException e) {
                e.printStackTrace();
                return;
            }
            this.pixieImageDisplay[ii] = this.ssipRgbMod[ii].getPixieImage();
            ++ii;
        }
        this.displayFitsFile();
    }

    protected void minMaxSliderChanged(int islider) {
        if (this.initializingPanels) {
            return;
        }
        if (this.minMaxSlider[islider].getValueIsAdjusting()) {
            return;
        }
        int[] sliderValue = new int[2];
        int ii = 0;
        while (ii < 2) {
            sliderValue[ii] = this.minMaxSlider[ii].getValue();
            ++ii;
        }
        if (islider == 0) {
            if (sliderValue[0] > sliderValue[1]) {
                sliderValue[0] = sliderValue[1];
            }
            this.minMaxSlider[0].setValue(sliderValue[0]);
            this.minMaxLevelLabel[0].setText(this.tp.format(sliderValue[0]));
        }
        if (islider == 1) {
            if (sliderValue[0] > sliderValue[1]) {
                sliderValue[1] = sliderValue[0];
            }
            this.minMaxSlider[1].setValue(sliderValue[1]);
            this.minMaxLevelLabel[1].setText(this.tp.format(sliderValue[1]));
        }
        this.displayFitsFile();
    }

    void saveRgb(boolean saveImages) {
        if (saveImages) {
            this.savePngFile("");
        }
        this.rgbPanel.setVisible(false);
        this.disableMenu = false;
        this.ssip = null;
    }

    void windowResized() {
        if (this.startupScreenDisplayed) {
            this.displayStartUpScreen(this.startupDisplay);
            return;
        }
        this.displayFitsFile();
    }

    protected void mouseClickedOnBWImage(MouseEvent e) {
        if (this.ssip == null && this.ssipRgbMod == null) {
            return;
        }
        int ix = e.getX();
        int iy = e.getY();
        double x = ((double)ix + this.imageOffset[0]) * this.imageScale[0];
        double y = ((double)iy + this.imageOffset[1]) * this.imageScale[1];
        ix = (int)x;
        iy = (int)y;
        if (ix < 0 || iy < 0) {
            return;
        }
        int ired = (int)this.pixieImageDisplay[0].getPix()[iy][ix];
        int igreen = (int)this.pixieImageDisplay[1].getPix()[iy][ix];
        int iblue = (int)this.pixieImageDisplay[2].getPix()[iy][ix];
        this.mouseClick.setSize(ix, iy);
        String message = "Pixel: X = " + ix + ", Y = " + iy + "; Red = " + ired + ", Green = " + igreen + ", Blue = " + iblue;
        this.statusBar.setText(message);
        this.displayFitsFile();
    }

    protected void makeZoomedImage(double zoom, int displayWidth, PixieImageRGBPlotterNoSwing origPlotter) {
        PixieImage[] zoomPixieImageDisplay = SingleSimpleImageProcess.makeZoomedPixieImage(this.pixieImageDisplay, zoom, this.mouseClick.height, this.mouseClick.width);
        PixieImageRGBPlotterNoSwing plotter = null;
        try {
            plotter = SingleSimpleImageProcess.threeColor(zoomPixieImageDisplay[0], zoomPixieImageDisplay[1], zoomPixieImageDisplay[2], this.scaleType, this.minMaxSlider[0].getValue(), this.minMaxSlider[1].getValue());
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
        plotter.setAutoScale(false);
        plotter.setPixelValueLimits(origPlotter.getMinPixelValue(), origPlotter.getMaxPixelValue());
        plotter.setColorSpectrum(this.colorSpectrum);
        plotter.setInvertImage(this.invertImage);
        BufferedImage biOrig = plotter.makeBufferedImage();
        int displayHeight = displayWidth * biOrig.getHeight();
        BufferedImage bi = new BufferedImage(displayWidth, displayHeight /= biOrig.getWidth(), 2);
        Graphics2D graphics2D = bi.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(plotter.makeBufferedImage(), 0, 0, displayWidth, displayHeight, null);
        this.zoomedImageIconLabel.setIcon(new ImageIcon(bi));
    }

    void flipInvertImageButton() {
        if (this.invertImage) {
            this.invertImageButton.setSelected(false);
            this.invertImage = false;
        } else {
            this.invertImageButton.setSelected(true);
            this.invertImage = true;
        }
        if (!this.startupScreenDisplayed) {
            this.displayFitsFile();
        }
    }

    void flipColorSpectrumButton() {
        if (this.colorSpectrum) {
            this.colorSpectrumButton.setSelected(false);
            this.colorSpectrum = false;
        } else {
            this.colorSpectrumButton.setSelected(true);
            this.colorSpectrum = true;
        }
        if (!this.startupScreenDisplayed) {
            this.displayFitsFile();
        }
    }

    protected void openHelp() {
        if (this.helpFrame != null && !this.helpFrame.frameClosed) {
            this.helpFrame.setState(0);
            return;
        }
        try {
            this.helpFrame = new AstroImageProcessorHelpFrame(this);
        }
        catch (IOException e) {
            this.messageDialog("Can't open help file: " + e.getMessage());
        }
    }

    protected void openYouTubeVideo() {
        try {
            URL imageLinkUrl = new URL("http://www.youtube.com/watch?v=dE_-yH0GfJg");
            Desktop.getDesktop().browse(imageLinkUrl.toURI());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    protected void messageDialog(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            System.out.println(args[0]);
        }
        new AstroImageProcessorGui("StoneEdge Astro Image Processor");
    }
}

