/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.Complex;
import com.astrofizzbizz.numericalrecipes.ComplexMatrix;
import com.astrofizzbizz.numericalrecipes.DoubleMatrix;
import com.astrofizzbizz.numericalrecipes.jama.Matrix;
import com.astrofizzbizz.numericalrecipes.jama.SingularValueDecomposition;
import java.io.Serializable;

public class ComplexSvd
implements Serializable {
    private static final long serialVersionUID = 2775706524807794192L;
    Matrix jamaMat;
    SingularValueDecomposition jamaSvdMat;

    public ComplexSvd(ComplexMatrix matrix) {
        this.jamaMat = new Matrix(matrix.expandMatrix().cell);
        this.jamaSvdMat = this.jamaMat.svd();
    }

    public ComplexMatrix getMatrix() {
        return new ComplexMatrix(new DoubleMatrix(this.jamaMat.getArray()));
    }

    public double[] getSingularValues() {
        return this.jamaSvdMat.getSingularValues();
    }

    public double getMaxSingularValue() {
        return this.jamaSvdMat.getSingularValues()[0];
    }

    public ComplexMatrix getInverseMatrix(double minSingularValue) {
        double[] singValues = this.getSingularValues();
        int nrows = singValues.length;
        double[][] sinverse = new double[nrows][nrows];
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < nrows) {
                sinverse[ir][ic] = 0.0;
                ++ic;
            }
            if (singValues[ir] > minSingularValue) {
                sinverse[ir][ir] = 1.0 / singValues[ir];
            }
            ++ir;
        }
        Matrix jamaSinverse = new Matrix(sinverse);
        Matrix inverse = this.jamaSvdMat.getV().times(jamaSinverse.times(this.jamaSvdMat.getU().transpose()));
        return new ComplexMatrix(new DoubleMatrix(inverse.getArray()));
    }

    public static void main(String[] args) {
        ComplexMatrix mtest = new ComplexMatrix(3, 3);
        mtest.cell[0][0] = new Complex(1.0, 3.0);
        mtest.cell[0][1] = new Complex(2.0, 1.0);
        mtest.cell[0][2] = new Complex(3.0, 3.0);
        mtest.cell[1][0] = new Complex(3.0, 0.0);
        mtest.cell[1][1] = new Complex(2.0, 2.0);
        mtest.cell[1][2] = new Complex(1.0, 1.0);
        mtest.cell[2][0] = new Complex(0.0, 3.0);
        mtest.cell[2][1] = new Complex(1.0, 1.0);
        mtest.cell[2][2] = new Complex(0.0, 0.0);
        ComplexSvd csvd = new ComplexSvd(mtest);
        ComplexMatrix orig = csvd.getMatrix();
        System.out.println("Initial Matrix");
        orig.printMatrix();
        ComplexMatrix minv = csvd.getInverseMatrix(0.0);
        ComplexMatrix ident = minv.times(orig);
        System.out.println("Inverse Matrix");
        minv.printMatrix();
        System.out.println("Identity Matrix");
        ident.printMatrix();
    }
}

