/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.NumericalRecipesException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;

public class DoubleMatrix
implements Serializable {
    private static final long serialVersionUID = 5848612731095766726L;
    public double[][] cell = null;

    public DoubleMatrix(int nrow, int ncol) {
        this.cell = new double[nrow][ncol];
        int ii = 0;
        while (ii < nrow) {
            int ij = 0;
            while (ij < ncol) {
                this.cell[ii][ij] = 0.0;
                ++ij;
            }
            ++ii;
        }
    }

    public DoubleMatrix(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        this((DoubleMatrix)new ObjectInputStream(new FileInputStream(fileName)).readObject());
    }

    public void makeUnity() {
        if (this.getRows() != this.getCols()) {
            return;
        }
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                this.cell[ii][ij] = 0.0;
                ++ij;
            }
            ++ii;
        }
        ii = 0;
        while (ii < this.getRows()) {
            this.cell[ii][ii] = 1.0;
            ++ii;
        }
    }

    public int getRows() {
        if (this.cell == null) {
            return 0;
        }
        return this.cell.length;
    }

    public int getCols() {
        if (this.cell == null) {
            return 0;
        }
        return this.cell[0].length;
    }

    public DoubleMatrix(DoubleMatrix m) {
        this.cell = new double[m.getRows()][m.getCols()];
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                this.cell[ii][ij] = m.cell[ii][ij];
                ++ij;
            }
            ++ii;
        }
    }

    public DoubleMatrix(double[][] cell) {
        this.cell = new double[cell.length][cell[0].length];
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                this.cell[ii][ij] = cell[ii][ij];
                ++ij;
            }
            ++ii;
        }
    }

    public void copyToColumn(double[] colVec, int icol) throws NumericalRecipesException {
        if (icol >= this.getCols()) {
            throw new NumericalRecipesException("Column index too big");
        }
        if (colVec.length != this.getRows()) {
            throw new NumericalRecipesException("Col vec length wrong size");
        }
        int ir = 0;
        while (ir < this.getRows()) {
            this.cell[ir][icol] = colVec[ir];
            ++ir;
        }
    }

    public void copyToRow(double[] rowVec, int irow) throws NumericalRecipesException {
        if (irow >= this.getRows()) {
            throw new NumericalRecipesException("Row index too big");
        }
        if (rowVec.length != this.getCols()) {
            throw new NumericalRecipesException("Row vec length wrong size");
        }
        int ic = 0;
        while (ic < this.getCols()) {
            this.cell[irow][ic] = rowVec[ic];
            ++ic;
        }
    }

    public DoubleMatrix plus(DoubleMatrix m) {
        if (m.getRows() != this.getRows() || m.getCols() != this.getCols()) {
            return null;
        }
        DoubleMatrix msum = new DoubleMatrix(this.getRows(), this.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                msum.cell[ii][ij] = this.cell[ii][ij] + m.cell[ii][ij];
                ++ij;
            }
            ++ii;
        }
        return msum;
    }

    public DoubleMatrix subtract(DoubleMatrix m) {
        if (m.getRows() != this.getRows() || m.getCols() != this.getCols()) {
            return null;
        }
        DoubleMatrix msum = new DoubleMatrix(this.getRows(), this.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                msum.cell[ii][ij] = this.cell[ii][ij] - m.cell[ii][ij];
                ++ij;
            }
            ++ii;
        }
        return msum;
    }

    public DoubleMatrix times(DoubleMatrix m) {
        if (m.getRows() != this.getCols()) {
            return null;
        }
        DoubleMatrix mtimes = new DoubleMatrix(this.getRows(), m.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < m.getCols()) {
                mtimes.cell[ii][ij] = 0.0;
                int ik = 0;
                while (ik < this.getCols()) {
                    mtimes.cell[ii][ij] = mtimes.cell[ii][ij] + this.cell[ii][ik] * m.cell[ik][ij];
                    ++ik;
                }
                ++ij;
            }
            ++ii;
        }
        return mtimes;
    }

    public double[] times(double[] vecIn) throws NumericalRecipesException {
        if (vecIn.length != this.getCols()) {
            throw new NumericalRecipesException("Col vec length wrong size");
        }
        double[] vecOut = new double[this.getRows()];
        int ii = 0;
        while (ii < this.getRows()) {
            vecOut[ii] = 0.0;
            int ij = 0;
            while (ij < this.getCols()) {
                vecOut[ii] = vecOut[ii] + this.cell[ii][ij] * vecIn[ij];
                ++ij;
            }
            ++ii;
        }
        return vecOut;
    }

    public DoubleMatrix times(double d) {
        DoubleMatrix mtimes = new DoubleMatrix(this.getRows(), this.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                mtimes.cell[ii][ij] = this.cell[ii][ij] * d;
                ++ij;
            }
            ++ii;
        }
        return mtimes;
    }

    public DoubleMatrix invert() {
        if (this.getRows() != this.getCols()) {
            return null;
        }
        DoubleMatrix mcopy = new DoubleMatrix(this);
        boolean isuccess = this.Guassj0(mcopy.cell, this.getRows());
        if (!isuccess) {
            return null;
        }
        return mcopy;
    }

    public void printMatrix(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        PrintWriter pw = new PrintWriter(fos);
        this.printMatrix(pw);
        pw.close();
        fos.close();
    }

    public void writeToFile(String fileName) throws FileNotFoundException, IOException {
        System.out.println("Writing DoubleMatrix...");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
        oos.writeObject(this);
        oos.flush();
        oos.close();
        System.out.println("Finished writing DoubleMatrix.");
    }

    public void printMatrix() {
        PrintWriter pw = new PrintWriter(System.out);
        this.printMatrix(pw);
    }

    public void printMatrix(PrintWriter pw) {
        DecimalFormat formatter = new DecimalFormat("0.#####E0");
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                pw.print(formatter.format(this.cell[ii][ij]));
                pw.print('\t');
                ++ij;
            }
            pw.print('\n');
            ++ii;
        }
        pw.flush();
    }

    protected boolean Guassj1(double[][] a, int n) {
        double dswap;
        int l;
        int k;
        int[] ipiv = null;
        int[] indxr = null;
        int[] indxc = null;
        int irow = 0;
        int icol = 0;
        indxc = new int[n + 1];
        indxr = new int[n + 1];
        ipiv = new int[n + 1];
        boolean istatus = true;
        int j = 1;
        while (j <= n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 1;
        while (i <= n) {
            double big = 0.0;
            j = 1;
            while (j <= n) {
                if (ipiv[j] != 1) {
                    k = 1;
                    while (k <= n) {
                        if (ipiv[k] == 0) {
                            if (Math.abs(a[j][k]) >= big) {
                                big = Math.abs(a[j][k]);
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            istatus = false;
                            return istatus;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ipiv[icol] = ipiv[icol] + 1;
            if (irow != icol) {
                l = 1;
                while (l <= n) {
                    dswap = a[irow][l];
                    a[irow][l] = a[icol][l];
                    a[icol][l] = dswap;
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                istatus = false;
                return false;
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 1;
            while (l <= n) {
                double[] dArray = a[icol];
                int n2 = l++;
                dArray[n2] = dArray[n2] * pivinv;
            }
            int ll = 1;
            while (ll <= n) {
                if (ll != icol) {
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    l = 1;
                    while (l <= n) {
                        double[] dArray = a[ll];
                        int n3 = l;
                        dArray[n3] = dArray[n3] - a[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n;
        while (l >= 1) {
            if (indxr[l] != indxc[l]) {
                k = 1;
                while (k <= n) {
                    dswap = a[k][indxr[l]];
                    a[k][indxr[l]] = a[k][indxc[l]];
                    a[k][indxc[l]] = dswap;
                    ++k;
                }
            }
            --l;
        }
        ipiv = null;
        indxr = null;
        indxc = null;
        return istatus;
    }

    protected boolean Guassj0(double[][] a, int n) {
        int imm;
        double[][] da = new double[n + 1][n + 1];
        int inn = 0;
        while (inn < n) {
            imm = 0;
            while (imm < n) {
                da[inn + 1][imm + 1] = a[inn][imm];
                ++imm;
            }
            ++inn;
        }
        boolean success = this.Guassj1(da, n);
        if (!success) {
            return success;
        }
        inn = 0;
        while (inn < n) {
            imm = 0;
            while (imm < n) {
                a[inn][imm] = da[inn + 1][imm + 1];
                ++imm;
            }
            ++inn;
        }
        return success;
    }

    public static void main(String[] args) {
        DoubleMatrix mtest = new DoubleMatrix(3, 3);
        mtest.cell[0][0] = 1.0;
        mtest.cell[0][1] = 0.0;
        mtest.cell[0][2] = 2.0;
        mtest.cell[1][0] = 0.0;
        mtest.cell[1][1] = 3.0;
        mtest.cell[1][2] = 0.0;
        mtest.cell[2][0] = 4.0;
        mtest.cell[2][1] = 0.0;
        mtest.cell[2][2] = 5.0;
        DoubleMatrix minv = mtest.invert();
        DoubleMatrix ident = minv.times(mtest);
        try {
            mtest.printMatrix("startMat.dat");
            minv.printMatrix("invMat.dat");
            ident.printMatrix("identMat.dat");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

