/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import nom.tam.fits.FitsException;

public class FitsDate {
    private int year = -1;
    private int month = -1;
    private int mday = -1;
    private int hour = -1;
    private int minute = -1;
    private int second = -1;
    private int millisecond = -1;
    private Date date = null;

    public FitsDate(String dStr) throws FitsException {
        if (dStr == null) {
            return;
        }
        if ((dStr = dStr.trim()).length() == 0) {
            return;
        }
        int len = dStr.length();
        if (len >= 8) {
            int first = dStr.indexOf(45);
            if (first == 4 && first < len) {
                this.buildNewDate(dStr, first, len);
            } else {
                first = dStr.indexOf(47);
                if (first > 1 && first < len) {
                    this.buildOldDate(dStr, first, len);
                }
            }
        }
        if (this.year == -1) {
            throw new FitsException("Bad FITS date string \"" + dStr + '\"');
        }
    }

    private void buildOldDate(String dStr, int first, int len) {
        int middle = dStr.indexOf(47, first + 1);
        if (middle > first + 2 && middle < len) {
            try {
                this.year = Integer.parseInt(dStr.substring(middle + 1)) + 1900;
                this.month = Integer.parseInt(dStr.substring(first + 1, middle));
                this.mday = Integer.parseInt(dStr.substring(0, first));
            }
            catch (NumberFormatException e) {
                this.mday = -1;
                this.month = -1;
                this.year = -1;
            }
        }
    }

    private void parseTime(String tStr) throws FitsException {
        int first = tStr.indexOf(58);
        if (first < 0) {
            throw new FitsException("Bad time");
        }
        int len = tStr.length();
        int middle = tStr.indexOf(58, first + 1);
        if (middle > first + 2 && middle < len) {
            if (middle + 3 < len && tStr.charAt(middle + 3) == '.') {
                double d = Double.valueOf(tStr.substring(middle + 3));
                this.millisecond = (int)(d * 1000.0);
                len = middle + 3;
            }
            try {
                this.hour = Integer.parseInt(tStr.substring(0, first));
                this.minute = Integer.parseInt(tStr.substring(first + 1, middle));
                this.second = Integer.parseInt(tStr.substring(middle + 1, len));
            }
            catch (NumberFormatException e) {
                this.millisecond = -1;
                this.second = -1;
                this.minute = -1;
                this.hour = -1;
            }
        }
    }

    private void buildNewDate(String dStr, int first, int len) throws FitsException {
        int middle = dStr.indexOf(45, first + 1);
        if (middle > first + 2 && middle < len) {
            try {
                if (middle + 3 < len && dStr.charAt(middle + 3) == 'T') {
                    try {
                        this.parseTime(dStr.substring(middle + 4));
                    }
                    catch (FitsException e) {
                        throw new FitsException("Bad time in FITS date string \"" + dStr + "\"");
                    }
                    len = middle + 3;
                }
                this.year = Integer.parseInt(dStr.substring(0, first));
                this.month = Integer.parseInt(dStr.substring(first + 1, middle));
                this.mday = Integer.parseInt(dStr.substring(middle + 1, len));
            }
            catch (NumberFormatException e) {
                this.millisecond = -1;
                this.second = -1;
                this.minute = -1;
                this.hour = -1;
                this.mday = -1;
                this.month = -1;
                this.year = -1;
            }
        }
    }

    public Date toDate() {
        if (this.date == null && this.year != -1) {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            GregorianCalendar cal = new GregorianCalendar(tz);
            cal.set(1, this.year);
            cal.set(2, this.month - 1);
            cal.set(5, this.mday);
            if (this.hour == -1) {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
            } else {
                cal.set(11, this.hour);
                cal.set(12, this.minute);
                cal.set(13, this.second);
                if (this.millisecond == -1) {
                    cal.set(14, 0);
                } else {
                    cal.set(14, this.millisecond);
                }
            }
            this.date = cal.getTime();
        }
        return this.date;
    }

    public static String getFitsDateString() {
        return FitsDate.getFitsDateString(new Date(), true);
    }

    public static String getFitsDateString(Date epoch) {
        return FitsDate.getFitsDateString(epoch, true);
    }

    public static String getFitsDateString(Date epoch, boolean timeOfDay) {
        try {
            GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            cal.setTime(epoch);
            StringBuffer fitsDate = new StringBuffer();
            DecimalFormat df = new DecimalFormat("0000");
            fitsDate.append(df.format(cal.get(1)));
            fitsDate.append("-");
            df = new DecimalFormat("00");
            fitsDate.append(df.format(cal.get(2) + 1));
            fitsDate.append("-");
            fitsDate.append(df.format(cal.get(5)));
            if (timeOfDay) {
                fitsDate.append("T");
                fitsDate.append(df.format(cal.get(11)));
                fitsDate.append(":");
                fitsDate.append(df.format(cal.get(12)));
                fitsDate.append(":");
                fitsDate.append(df.format(cal.get(13)));
                fitsDate.append(".");
                df = new DecimalFormat("000");
                fitsDate.append(df.format(cal.get(14)));
            }
            return new String(fitsDate);
        }
        catch (Exception e) {
            return new String("");
        }
    }

    public String toString() {
        if (this.year == -1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(23);
        buf.append(this.year);
        buf.append('-');
        if (this.month < 10) {
            buf.append('0');
        }
        buf.append(this.month);
        buf.append('-');
        if (this.mday < 10) {
            buf.append('0');
        }
        buf.append(this.mday);
        if (this.hour != -1) {
            buf.append('T');
            if (this.hour < 10) {
                buf.append('0');
            }
            buf.append(this.hour);
            buf.append(':');
            if (this.minute < 10) {
                buf.append('0');
            }
            buf.append(this.minute);
            buf.append(':');
            if (this.second < 10) {
                buf.append('0');
            }
            buf.append(this.second);
            if (this.millisecond != -1) {
                buf.append('.');
                if (this.millisecond < 100) {
                    if (this.millisecond < 10) {
                        buf.append("00");
                    } else {
                        buf.append('0');
                    }
                }
                buf.append(this.millisecond);
            }
        }
        return buf.toString();
    }

    public static void testArgs(String[] args) {
        int i = 0;
        while (i < args.length) {
            try {
                FitsDate fd = new FitsDate(args[i]);
                System.out.println("\"" + args[i] + "\" => " + fd + " => " + fd.toDate());
            }
            catch (Exception e) {
                System.err.println("Date \"" + args[i] + "\" threw " + e.getClass().getName() + "(" + e.getMessage() + ")");
            }
            ++i;
        }
    }

    public static void autotest() {
        String[] good = new String[]{"20/09/79", "1997-07-25", "1987-06-05T04:03:02.01", "1998-03-10T16:58:34", null, "        "};
        FitsDate.testArgs(good);
        String[] badOld = new String[]{"20/09/", "/09/79", "09//79", "20/09/79/"};
        FitsDate.testArgs(badOld);
        String[] badNew = new String[]{"1997-07", "-07-25", "1997--07-25", "1997-07-25-"};
        FitsDate.testArgs(badNew);
        String[] badMisc = new String[]{"5-Aug-1992", "28/02/91 16:32:00", "18-Feb-1993", "nn/nn/nn"};
        FitsDate.testArgs(badMisc);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            FitsDate.autotest();
        } else {
            FitsDate.testArgs(args);
        }
    }
}

