/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nom.tam.util.Cursor;

public class HashedList
implements Collection {
    private ArrayList ordered = new ArrayList();
    private HashMap keyed = new HashMap();
    private int unkeyedIndex = 0;

    public boolean add(Object reference) {
        Integer nKey = new Integer(this.unkeyedIndex);
        ++this.unkeyedIndex;
        this.add(this.ordered.size(), nKey, reference);
        return true;
    }

    public boolean add(Object key, Object reference) {
        this.add(this.ordered.size(), key, reference);
        return true;
    }

    public boolean add(int pos, Object key, Object reference) {
        if (this.keyed.containsKey(key)) {
            int oldPos = this.ordered.indexOf(key);
            this.removeKey(key);
            if (oldPos < pos) {
                --pos;
            }
        }
        this.keyed.put(key, reference);
        if (pos >= this.ordered.size()) {
            this.ordered.add(key);
        } else {
            this.ordered.add(pos, key);
        }
        return true;
    }

    public boolean removeKey(Object key) {
        if (this.keyed.containsKey(key)) {
            int index = this.ordered.indexOf(key);
            this.keyed.remove(key);
            this.ordered.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.keyed.containsValue(o)) {
            int i = 0;
            while (i < this.ordered.size()) {
                if (this.keyed.get(this.ordered.get(i)).equals(o)) {
                    return this.removeKey(this.ordered.get(i));
                }
                ++i;
            }
        }
        return false;
    }

    public boolean remove(int index) {
        if (index >= 0 && index < this.ordered.size()) {
            Object key = this.ordered.get(index);
            return this.removeKey(key);
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new HashedListIterator(0);
    }

    public HashedListIterator iterator(Object key) throws NoSuchElementException {
        if (this.keyed.containsKey(key)) {
            return new HashedListIterator(this.ordered.indexOf(key));
        }
        throw new NoSuchElementException("Unknown key for iterator:" + key);
    }

    public HashedListIterator iterator(int n) throws NoSuchElementException {
        if (n >= 0 && n <= this.ordered.size()) {
            return new HashedListIterator(n);
        }
        throw new NoSuchElementException("Invalid index for iterator:" + n);
    }

    public Object get(Object key) {
        return this.keyed.get(key);
    }

    public Object get(int n) throws NoSuchElementException {
        return this.keyed.get(this.ordered.get(n));
    }

    public boolean replaceKey(Object oldKey, Object newKey) {
        if (!this.keyed.containsKey(oldKey) || this.keyed.containsKey(newKey)) {
            return false;
        }
        Object oldVal = this.keyed.get(oldKey);
        int index = this.ordered.indexOf(oldKey);
        this.remove(index);
        return this.add(index, newKey, oldVal);
    }

    public boolean containsKey(Object key) {
        return this.keyed.containsKey(key);
    }

    @Override
    public int size() {
        return this.ordered.size();
    }

    public boolean addAll(Collection c) {
        Object[] array = c.toArray();
        int i = 0;
        while (i < array.length) {
            this.add(array[i]);
            ++i;
        }
        return true;
    }

    @Override
    public void clear() {
        this.keyed.clear();
        this.ordered.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.keyed.containsValue(o);
    }

    public boolean containsAll(Collection c) {
        return this.keyed.values().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.keyed.isEmpty();
    }

    public boolean removeAll(Collection c) {
        Object[] o = c.toArray();
        boolean result = false;
        int i = 0;
        while (i < o.length) {
            result |= this.remove(o[i]);
            ++i;
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        Iterator iter = this.iterator();
        boolean result = false;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (c.contains(o)) continue;
            iter.remove();
            result = true;
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        Object[] o = new Object[this.ordered.size()];
        return this.toArray(o);
    }

    public Object[] toArray(Object[] o) {
        return this.keyed.values().toArray(o);
    }

    public void sort(Comparator comp) {
        Collections.sort(this.ordered, comp);
    }

    private class HashedListIterator
    implements Cursor {
        private int current;

        HashedListIterator(int start) {
            this.current = start;
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0 && this.current < HashedList.this.ordered.size();
        }

        @Override
        public boolean hasPrev() {
            return this.current > 0;
        }

        public Object next() throws NoSuchElementException {
            if (this.current < 0 || this.current >= HashedList.this.ordered.size()) {
                throw new NoSuchElementException("Outside list");
            }
            Object key = HashedList.this.ordered.get(this.current);
            ++this.current;
            return HashedList.this.keyed.get(key);
        }

        @Override
        public Object prev() throws NoSuchElementException {
            if (this.current <= 0) {
                throw new NoSuchElementException("Before beginning of list");
            }
            --this.current;
            Object key = HashedList.this.ordered.get(this.current);
            return HashedList.this.keyed.get(key);
        }

        @Override
        public void remove() {
            if (this.current > 0 && this.current <= HashedList.this.ordered.size()) {
                HashedList.this.remove(this.current - 1);
                if (this.current > 0) {
                    --this.current;
                }
            }
        }

        @Override
        public void add(Object ref) {
            Integer nKey = new Integer(HashedList.this.unkeyedIndex);
            HashedList hashedList = HashedList.this;
            hashedList.unkeyedIndex = hashedList.unkeyedIndex + 1;
            HashedList.this.add(this.current, nKey, ref);
            ++this.current;
        }

        @Override
        public void add(Object key, Object ref) {
            HashedList.this.add(this.current, key, ref);
            ++this.current;
        }

        @Override
        public void setKey(Object key) {
            this.current = HashedList.this.keyed.containsKey(key) ? HashedList.this.ordered.indexOf(key) : HashedList.this.ordered.size();
        }
    }
}

