/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import java.io.Serializable;

public class Complex
implements Serializable {
    private static final long serialVersionUID = 609325012699107013L;
    public double re;
    public double im;
    public static final Complex ZERO_C = new Complex(0.0, 0.0);
    public static final Complex ONE_C = new Complex(1.0, 0.0);
    public static final Complex I_C = new Complex(0.0, 1.0);

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public Complex(double x) {
        this.re = x;
        this.im = 0.0;
    }

    public Complex(double x, double y) {
        this.re = x;
        this.im = y;
    }

    public Complex(Complex c) {
        this.copy(c);
    }

    public boolean equals(Object obj) {
        try {
            Complex c = (Complex)obj;
            return c.re == this.re && c.im == this.im;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Complex conj() {
        return new Complex(this.re, -this.im);
    }

    public static Complex polar(double r, double theta) {
        return new Complex(r * Math.cos(theta), r * Math.sin(theta));
    }

    public void copy(Complex c) {
        if (c == null) {
            this.im = 0.0;
            this.re = 0.0;
        } else {
            this.re = c.re;
            this.im = c.im;
        }
    }

    public Complex plus(Complex c) {
        return new Complex(this.re + c.re, this.im + c.im);
    }

    public Complex minus(Complex c) {
        return new Complex(this.re - c.re, this.im - c.im);
    }

    public Complex times(Complex c) {
        return new Complex(this.re * c.re - this.im * c.im, this.re * c.im + this.im * c.re);
    }

    public Complex dividedBy(Complex c) {
        double denom = c.re * c.re + c.im * c.im;
        if (denom == 0.0) {
            return new Complex(Double.NaN, Double.NaN);
        }
        return new Complex((this.re * c.re + this.im * c.im) / denom, (this.im * c.re - this.re * c.im) / denom);
    }

    public Complex times(double x) {
        return new Complex(this.re * x, this.im * x);
    }

    public Complex plus(double x) {
        return new Complex(this.re + x, this.im);
    }

    public Complex minus(double x) {
        return new Complex(this.re - x, this.im);
    }

    public Complex dividedBy(double x) {
        return new Complex(this.re / x, this.im / x);
    }

    public double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        return this.re * this.re + this.im * this.im;
    }

    public double theta() {
        return Math.atan2(this.im, this.re);
    }

    public Complex exponential() {
        double length = Math.exp(this.re);
        return new Complex(length * Math.cos(this.im), length * Math.sin(this.im));
    }

    public Complex inverse() {
        double length = this.re * this.re + this.im * this.im;
        return new Complex(this.re / length, -this.im / length);
    }

    public Complex log() {
        double modulus = Math.sqrt(this.re * this.re + this.im * this.im);
        double arg = Math.atan2(this.im, this.re);
        return new Complex(Math.log(modulus), arg);
    }

    public double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public Complex sine() {
        Complex z = new Complex(0.0, 0.0);
        double x = this.re;
        double y = this.im;
        z.re = Math.sin(x) * this.cosh(y);
        z.im = Math.cos(x) * this.sinh(y);
        return z;
    }

    public Complex power(double x) {
        double modulus = Math.sqrt(this.re * this.re + this.im * this.im);
        double arg = Math.atan2(this.im, this.re);
        double log_re = Math.log(modulus);
        double log_im = arg;
        double x_log_re = x * log_re;
        double x_log_im = x * log_im;
        double modulus_ans = Math.exp(x_log_re);
        return new Complex(modulus_ans * Math.cos(x_log_im), modulus_ans * Math.sin(x_log_im));
    }

    public Complex integerRoot(int k) {
        double b;
        double a;
        boolean neg = false;
        if (k < 0) {
            k = -k;
            neg = true;
        }
        if (k == 0) {
            a = 1.0;
            b = 0.0;
        } else if (k == 1) {
            a = this.re;
            b = this.im;
        } else {
            double length = this.magnitude();
            double angle = this.theta();
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            length = Math.pow(length, 1.0 / (double)k);
            a = length * Math.cos(angle /= (double)k);
            b = length * Math.sin(angle);
        }
        if (neg) {
            double denom = a * a + b * b;
            a /= denom;
            b = -b / denom;
        }
        return new Complex(a, b);
    }

    public String dumpData() {
        return " re = " + this.re + " im = " + this.im + " ";
    }
}

