/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.Complex;
import com.astrofizzbizz.numericalrecipes.DoubleMatrix;
import com.astrofizzbizz.numericalrecipes.NumericalRecipesException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;

public class ComplexMatrix
implements Serializable {
    private static final long serialVersionUID = 8603095864916455077L;
    public Complex[][] cell = null;

    public ComplexMatrix(int nrow, int ncol) {
        this.cell = new Complex[nrow][ncol];
        int ii = 0;
        while (ii < nrow) {
            int ij = 0;
            while (ij < ncol) {
                this.cell[ii][ij] = new Complex();
                ++ij;
            }
            ++ii;
        }
    }

    public ComplexMatrix(ComplexMatrix m) {
        this.cell = new Complex[m.getRows()][m.getCols()];
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                this.cell[ii][ij] = new Complex(m.cell[ii][ij]);
                ++ij;
            }
            ++ii;
        }
    }

    public ComplexMatrix(Complex[][] cell) {
        if (cell != null) {
            this.cell = new Complex[cell.length][cell[0].length];
            int ii = 0;
            while (ii < this.getRows()) {
                int ij = 0;
                while (ij < this.getCols()) {
                    this.cell[ii][ij] = new Complex(cell[ii][ij]);
                    ++ij;
                }
                ++ii;
            }
        }
    }

    public ComplexMatrix(Complex[] cVector) {
        if (cVector != null) {
            this.cell = new Complex[cVector.length][1];
            int ii = 0;
            while (ii < this.getRows()) {
                this.cell[ii][0] = new Complex(cVector[ii]);
                ++ii;
            }
        }
    }

    public ComplexMatrix(DoubleMatrix matrixX) {
        int nrows = matrixX.getRows() / 2;
        int ncols = matrixX.getCols() / 2;
        this.cell = new Complex[nrows][ncols];
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                this.cell[ir][ic] = new Complex(matrixX.cell[2 * ir][2 * ic], matrixX.cell[2 * ir + 1][2 * ic]);
                ++ic;
            }
            ++ir;
        }
    }

    public ComplexMatrix(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        this((ComplexMatrix)new ObjectInputStream(new FileInputStream(fileName)).readObject());
    }

    public int getRows() {
        if (this.cell == null) {
            return 0;
        }
        return this.cell.length;
    }

    public int getCols() {
        if (this.cell == null) {
            return 0;
        }
        return this.cell[0].length;
    }

    public void copyToColumn(Complex[] colVec, int icol) throws NumericalRecipesException {
        if (icol >= this.getCols()) {
            throw new NumericalRecipesException("Column index too big");
        }
        if (colVec.length != this.getRows()) {
            throw new NumericalRecipesException("Col vec length wrong size");
        }
        int ir = 0;
        while (ir < this.getRows()) {
            this.cell[ir][icol] = new Complex(colVec[ir]);
            ++ir;
        }
    }

    public void copyToRow(Complex[] rowVec, int irow) throws NumericalRecipesException {
        if (irow >= this.getRows()) {
            throw new NumericalRecipesException("Row index too big");
        }
        if (rowVec.length != this.getCols()) {
            throw new NumericalRecipesException("Row vec length wrong size");
        }
        int ic = 0;
        while (ic < this.getCols()) {
            this.cell[irow][ic] = new Complex(rowVec[ic]);
            ++ic;
        }
    }

    public Complex[] getColumn(int icol) throws NumericalRecipesException {
        if (icol >= this.getCols()) {
            throw new NumericalRecipesException("Column index too big");
        }
        Complex[] column = new Complex[this.getRows()];
        int ir = 0;
        while (ir < this.getRows()) {
            column[ir] = new Complex(this.cell[ir][icol]);
            ++ir;
        }
        return column;
    }

    public Complex[] getRow(int irow) throws NumericalRecipesException {
        if (irow >= this.getRows()) {
            throw new NumericalRecipesException("Row index too big");
        }
        Complex[] row = new Complex[this.getCols()];
        int ic = 0;
        while (ic < this.getCols()) {
            row[ic] = new Complex(this.cell[irow][ic]);
            ++ic;
        }
        return row;
    }

    public ComplexMatrix plus(ComplexMatrix m) {
        if (m.getRows() != this.getRows() || m.getCols() != this.getCols()) {
            return null;
        }
        ComplexMatrix msum = new ComplexMatrix(this.getRows(), this.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                msum.cell[ii][ij] = this.cell[ii][ij].plus(m.cell[ii][ij]);
                ++ij;
            }
            ++ii;
        }
        return msum;
    }

    public ComplexMatrix subtract(ComplexMatrix m) {
        if (m.getRows() != this.getRows() || m.getCols() != this.getCols()) {
            return null;
        }
        ComplexMatrix msum = new ComplexMatrix(this.getRows(), this.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                msum.cell[ii][ij] = this.cell[ii][ij].minus(m.cell[ii][ij]);
                ++ij;
            }
            ++ii;
        }
        return msum;
    }

    public ComplexMatrix times(ComplexMatrix m) {
        if (m.getRows() != this.getCols()) {
            return null;
        }
        ComplexMatrix mtimes = new ComplexMatrix(this.getRows(), m.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < m.getCols()) {
                mtimes.cell[ii][ij] = new Complex();
                int ik = 0;
                while (ik < this.getCols()) {
                    mtimes.cell[ii][ij] = mtimes.cell[ii][ij].plus(this.cell[ii][ik].times(m.cell[ik][ij]));
                    ++ik;
                }
                ++ij;
            }
            ++ii;
        }
        return mtimes;
    }

    public ComplexMatrix times(Complex c) {
        ComplexMatrix mtimes = new ComplexMatrix(this.getRows(), this.getCols());
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                mtimes.cell[ii][ij] = this.cell[ii][ij].times(c);
                ++ij;
            }
            ++ii;
        }
        return mtimes;
    }

    public Complex[] times(Complex[] vecIn) throws NumericalRecipesException {
        if (vecIn.length != this.getCols()) {
            throw new NumericalRecipesException("Col vec length wrong size");
        }
        Complex[] vecOut = new Complex[this.getRows()];
        int ii = 0;
        while (ii < this.getRows()) {
            vecOut[ii] = new Complex();
            int ij = 0;
            while (ij < this.getCols()) {
                vecOut[ii] = vecOut[ii].plus(this.cell[ii][ij].times(vecIn[ij]));
                ++ij;
            }
            ++ii;
        }
        return vecOut;
    }

    public DoubleMatrix expandMatrix() {
        DoubleMatrix matrixX = new DoubleMatrix(2 * this.getRows(), 2 * this.getCols());
        int ir = 0;
        while (ir < this.getRows()) {
            int ic = 0;
            while (ic < this.getCols()) {
                matrixX.cell[2 * ir][2 * ic] = this.cell[ir][ic].re;
                matrixX.cell[2 * ir + 1][2 * ic + 1] = this.cell[ir][ic].re;
                matrixX.cell[2 * ir][2 * ic + 1] = -this.cell[ir][ic].im;
                matrixX.cell[2 * ir + 1][2 * ic] = this.cell[ir][ic].im;
                ++ic;
            }
            ++ir;
        }
        return matrixX;
    }

    public ComplexMatrix invert() {
        if (this.getRows() != this.getCols()) {
            return null;
        }
        DoubleMatrix dcopy = this.expandMatrix();
        boolean isuccess = dcopy.Guassj0(dcopy.cell, 2 * this.getRows());
        if (!isuccess) {
            return null;
        }
        return new ComplexMatrix(dcopy);
    }

    public void printMatrix(PrintWriter pw) {
        DecimalFormat formatter = new DecimalFormat("0.00000E00");
        formatter.setPositivePrefix("+");
        int ii = 0;
        while (ii < this.getRows()) {
            int ij = 0;
            while (ij < this.getCols()) {
                pw.print(formatter.format(this.cell[ii][ij].re));
                pw.print('\t');
                pw.print(formatter.format(this.cell[ii][ij].im));
                pw.print('\t');
                ++ij;
            }
            pw.print('\n');
            ++ii;
        }
        pw.flush();
    }

    public void printMatrix(String fileName) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileName);
        PrintWriter pw = new PrintWriter(fos);
        this.printMatrix(pw);
        pw.close();
        fos.close();
    }

    public void printMatrix() {
        PrintWriter pw = new PrintWriter(System.out);
        this.printMatrix(pw);
    }

    public void writeToFile(String fileName) throws FileNotFoundException, IOException {
        System.out.println("Writing ComplexMatrix...");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
        oos.writeObject(this);
        oos.flush();
        oos.close();
        System.out.println("Finished writing ComplexMatrix.");
    }

    public int[] locateMaxMag() {
        int irowMax = 0;
        int icolMax = 0;
        double dmax = this.cell[irowMax][icolMax].magnitude();
        int ir = 0;
        while (ir < this.getRows()) {
            int ic = 0;
            while (ic < this.getCols()) {
                if (dmax < this.cell[ir][ic].magnitude()) {
                    irowMax = ir;
                    icolMax = ic;
                    dmax = this.cell[irowMax][icolMax].magnitude();
                }
                ++ic;
            }
            ++ir;
        }
        int[] ivec = new int[]{irowMax, icolMax};
        return ivec;
    }

    public int locateMaxMagInCol(int icol) {
        int irowMax = 0;
        double dmax = this.cell[irowMax][icol].magnitude();
        int ir = 0;
        while (ir < this.getRows()) {
            if (dmax < this.cell[ir][icol].magnitude()) {
                irowMax = ir;
                dmax = this.cell[irowMax][icol].magnitude();
            }
            ++ir;
        }
        return irowMax;
    }

    public int locateMaxMagInRow(int irow) {
        int icolMax = 0;
        double dmax = this.cell[irow][icolMax].magnitude();
        int ic = 0;
        while (ic < this.getCols()) {
            if (dmax < this.cell[irow][icolMax].magnitude()) {
                icolMax = ic;
                dmax = this.cell[irow][icolMax].magnitude();
            }
            ++ic;
        }
        return icolMax;
    }

    public void drawEllipse(Complex value, int acol, int brow) {
        int irowc = this.getRows() / 2;
        int icolc = this.getCols() / 2;
        int ic = -acol;
        while (ic <= acol) {
            int irow;
            double drow = (double)ic * (double)brow / (double)acol;
            drow = (double)brow * (double)brow - drow * drow;
            drow = Math.sqrt(drow);
            int icol = ic + icolc;
            if (icol < 0) {
                icol = 0;
            }
            if (icol >= this.getCols()) {
                icol = this.getCols() - 1;
            }
            if ((irow = irowc + (int)drow) >= this.getRows()) {
                irow = this.getRows() - 1;
            }
            this.cell[irow][icol] = new Complex(value);
            irow = irowc - (int)drow;
            if (irow < 0) {
                icol = 0;
            }
            this.cell[irow][icol] = new Complex(value);
            ++ic;
        }
    }

    public ComplexMatrix transpose() {
        ComplexMatrix transpose = new ComplexMatrix(this.getCols(), this.getRows());
        int ir = 0;
        while (ir < this.getRows()) {
            int ic = 0;
            while (ic < this.getCols()) {
                transpose.cell[ic][ir] = new Complex(this.cell[ir][ic]);
                ++ic;
            }
            ++ir;
        }
        return transpose;
    }

    public ComplexMatrix dagger() {
        ComplexMatrix transpose = new ComplexMatrix(this.getCols(), this.getRows());
        int ir = 0;
        while (ir < this.getRows()) {
            int ic = 0;
            while (ic < this.getCols()) {
                transpose.cell[ic][ir] = new Complex(this.cell[ir][ic].conj());
                ++ic;
            }
            ++ir;
        }
        return transpose;
    }

    public static void main(String[] args) {
        ComplexMatrix mtest = new ComplexMatrix(3, 3);
        mtest.cell[0][0] = new Complex(1.0, 3.0);
        mtest.cell[0][1] = new Complex(2.0, 1.0);
        mtest.cell[0][2] = new Complex(3.0, 3.0);
        mtest.cell[1][0] = new Complex(3.0, 0.0);
        mtest.cell[1][1] = new Complex(2.0, 2.0);
        mtest.cell[1][2] = new Complex(1.0, 1.0);
        mtest.cell[2][0] = new Complex(0.0, 3.0);
        mtest.cell[2][1] = new Complex(1.0, 1.0);
        mtest.cell[2][2] = new Complex(0.0, 0.0);
        ComplexMatrix minv = mtest.invert();
        ComplexMatrix ident = minv.times(mtest);
        ComplexMatrix transpose = mtest.dagger();
        PrintWriter pw = new PrintWriter(System.out);
        pw.println("Initial Matrix");
        mtest.printMatrix(pw);
        pw.println("Inverse Matrix");
        minv.printMatrix(pw);
        pw.println("Identity Matrix");
        ident.printMatrix(pw);
        pw.println("Transpose Matrix");
        transpose.printMatrix(pw);
    }
}

