/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.Complex;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class FFT {
    public static double PI = Math.PI;

    public static Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        int k = 0;
        while (k < N / 2) {
            even[k] = x[2 * k];
            ++k;
        }
        Complex[] q = FFT.fft(even);
        Complex[] odd = even;
        int k2 = 0;
        while (k2 < N / 2) {
            odd[k2] = x[2 * k2 + 1];
            ++k2;
        }
        Complex[] r = FFT.fft(odd);
        Complex[] y = new Complex[N];
        int k3 = 0;
        while (k3 < N / 2) {
            double kth = (double)(-2 * k3) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k3] = q[k3].plus(wk.times(r[k3]));
            y[k3 + N / 2] = q[k3].minus(wk.times(r[k3]));
            ++k3;
        }
        return y;
    }

    public static Complex[] fft(double[] x) {
        int kmax = x.length;
        Complex[] cx = new Complex[kmax];
        int ii = 0;
        while (ii < kmax) {
            cx[ii] = new Complex(x[ii], 0.0);
            ++ii;
        }
        Complex[] f = FFT.fft(cx);
        return f;
    }

    public static Complex[] ifft(Complex[] x) {
        int N = x.length;
        Complex[] y = new Complex[N];
        int i = 0;
        while (i < N) {
            y[i] = x[i].conj();
            ++i;
        }
        y = FFT.fft(y);
        i = 0;
        while (i < N) {
            y[i] = y[i].conj();
            ++i;
        }
        i = 0;
        while (i < N) {
            y[i] = y[i].times(1.0 / (double)N);
            ++i;
        }
        return y;
    }

    public static Complex[] dft(Complex[] x) {
        int N = x.length;
        Complex[] y = new Complex[N];
        int kk = 0;
        while (kk < N) {
            y[kk] = new Complex();
            int ii = 0;
            while (ii < N) {
                double arg = 2.0 * PI * (double)ii * (double)kk / (double)N;
                Complex phase = new Complex(Math.cos(arg), Math.sin(arg));
                y[kk] = y[kk].plus(x[ii].times(phase));
                ++ii;
            }
            ++kk;
        }
        return y;
    }

    public static Complex[] idft(Complex[] x) {
        int N = x.length;
        Complex[] y = new Complex[N];
        int kk = 0;
        while (kk < N) {
            y[kk] = new Complex();
            int ii = 0;
            while (ii < N) {
                double arg = -2.0 * PI * (double)ii * (double)kk / (double)N;
                Complex phase = new Complex(Math.cos(arg), Math.sin(arg));
                y[kk] = y[kk].plus(x[ii].times(phase));
                ++ii;
            }
            y[kk] = y[kk].dividedBy(N);
            ++kk;
        }
        return y;
    }

    public static Complex[] cconvolve(Complex[] x, Complex[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("Dimensions don't agree");
        }
        int N = x.length;
        Complex[] a = FFT.fft(x);
        Complex[] b = FFT.fft(y);
        Complex[] c = new Complex[N];
        int i = 0;
        while (i < N) {
            c[i] = a[i].times(b[i]);
            ++i;
        }
        return FFT.ifft(c);
    }

    public static Complex[] convolve(Complex[] x, Complex[] y) {
        Complex ZERO = new Complex(0.0, 0.0);
        Complex[] a = new Complex[2 * x.length];
        int i = 0;
        while (i < x.length) {
            a[i] = x[i];
            ++i;
        }
        i = x.length;
        while (i < 2 * x.length) {
            a[i] = ZERO;
            ++i;
        }
        Complex[] b = new Complex[2 * y.length];
        int i2 = 0;
        while (i2 < y.length) {
            b[i2] = y[i2];
            ++i2;
        }
        i2 = y.length;
        while (i2 < 2 * y.length) {
            b[i2] = ZERO;
            ++i2;
        }
        return FFT.cconvolve(a, b);
    }

    public static void show(Complex[] x, String title) {
        System.out.println(title);
        System.out.println("-------------------");
        int i = 0;
        while (i < x.length) {
            System.out.println(x[i]);
            ++i;
        }
        System.out.println();
    }

    public static void main(String[] args) throws FileNotFoundException {
        int N = 32;
        int K = 5;
        Complex[] w = new Complex[N];
        double phase = -1.0 * PI / 4.0;
        int i = 0;
        while (i < N) {
            w[i] = new Complex(Math.cos(2.0 * PI * (double)i * (double)K / (double)N + phase), 0.0);
            w[i] = new Complex();
            ++i;
        }
        Complex[] x = FFT.fft(w);
        Complex[] y = FFT.ifft(w);
        Complex[] z = FFT.dft(w);
        Complex[] zz = FFT.idft(w);
        PrintStream ps = new PrintStream("FFT.dat");
        int i2 = 0;
        while (i2 < N) {
            ps.println(String.valueOf(i2) + "," + w[i2].re + "," + w[i2].im + "," + x[i2].re + "," + x[i2].im + "," + y[i2].re + "," + y[i2].im + "," + z[i2].re + "," + z[i2].im + "," + zz[i2].re + "," + zz[i2].im);
            ++i2;
        }
        ps.close();
    }
}

