/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.Complex;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public class NR {
    public static boolean Guassj0(double[][] a, int n, double[][] b, int m) {
        int imm;
        double[][] da = new double[n + 1][n + 1];
        double[][] db = new double[n + 1][m + 1];
        int inn = 0;
        while (inn < n) {
            imm = 0;
            while (imm < n) {
                da[inn + 1][imm + 1] = a[inn][imm];
                ++imm;
            }
            imm = 0;
            while (imm < m) {
                db[inn + 1][imm + 1] = b[inn][imm];
                ++imm;
            }
            ++inn;
        }
        boolean success = NR.Guassj(da, n, db, m);
        if (!success) {
            return success;
        }
        inn = 0;
        while (inn < n) {
            imm = 0;
            while (imm < n) {
                a[inn][imm] = da[inn + 1][imm + 1];
                ++imm;
            }
            imm = 0;
            while (imm < m) {
                b[inn][imm] = db[inn + 1][imm + 1];
                ++imm;
            }
            ++inn;
        }
        return success;
    }

    public static boolean Guassj(double[][] a, int n, double[][] b, int m) {
        double dswap;
        int l;
        int k;
        int[] ipiv = null;
        int[] indxr = null;
        int[] indxc = null;
        int irow = 0;
        int icol = 0;
        indxc = new int[n + 1];
        indxr = new int[n + 1];
        ipiv = new int[n + 1];
        boolean istatus = true;
        int j = 1;
        while (j <= n) {
            ipiv[j] = 0;
            ++j;
        }
        int i = 1;
        while (i <= n) {
            System.out.println("At " + i + " out of " + n);
            double big = 0.0;
            j = 1;
            while (j <= n) {
                if (ipiv[j] != 1) {
                    k = 1;
                    while (k <= n) {
                        if (ipiv[k] == 0) {
                            if (Math.abs(a[j][k]) >= big) {
                                big = Math.abs(a[j][k]);
                                irow = j;
                                icol = k;
                            }
                        } else if (ipiv[k] > 1) {
                            istatus = false;
                            return istatus;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ipiv[icol] = ipiv[icol] + 1;
            if (irow != icol) {
                l = 1;
                while (l <= n) {
                    dswap = a[irow][l];
                    a[irow][l] = a[icol][l];
                    a[icol][l] = dswap;
                    ++l;
                }
                l = 1;
                while (l <= m) {
                    dswap = b[irow][l];
                    b[irow][l] = b[icol][l];
                    b[icol][l] = dswap;
                    ++l;
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol][icol] == 0.0) {
                istatus = false;
                return false;
            }
            double pivinv = 1.0 / a[icol][icol];
            a[icol][icol] = 1.0;
            l = 1;
            while (l <= n) {
                double[] dArray = a[icol];
                int n2 = l++;
                dArray[n2] = dArray[n2] * pivinv;
            }
            l = 1;
            while (l <= m) {
                double[] dArray = b[icol];
                int n3 = l++;
                dArray[n3] = dArray[n3] * pivinv;
            }
            int ll = 1;
            while (ll <= n) {
                if (ll != icol) {
                    double dum = a[ll][icol];
                    a[ll][icol] = 0.0;
                    l = 1;
                    while (l <= n) {
                        double[] dArray = a[ll];
                        int n4 = l;
                        dArray[n4] = dArray[n4] - a[icol][l] * dum;
                        ++l;
                    }
                    l = 1;
                    while (l <= m) {
                        double[] dArray = b[ll];
                        int n5 = l;
                        dArray[n5] = dArray[n5] - b[icol][l] * dum;
                        ++l;
                    }
                }
                ++ll;
            }
            ++i;
        }
        l = n;
        while (l >= 1) {
            if (indxr[l] != indxc[l]) {
                k = 1;
                while (k <= n) {
                    dswap = a[k][indxr[l]];
                    a[k][indxr[l]] = a[k][indxc[l]];
                    a[k][indxc[l]] = dswap;
                    ++k;
                }
            }
            --l;
        }
        ipiv = null;
        indxr = null;
        indxc = null;
        return istatus;
    }

    public static double select(int k, int n, double[] arr) {
        int l = 1;
        int ir = n;
        while (true) {
            double dswap;
            if (ir <= l + 1) {
                if (ir == l + 1 && arr[ir] < arr[l]) {
                    dswap = arr[l];
                    arr[l] = arr[ir];
                    arr[ir] = dswap;
                }
                return arr[k];
            }
            int mid = l + ir >> 1;
            dswap = arr[mid];
            arr[mid] = arr[l + 1];
            arr[l + 1] = dswap;
            if (arr[l] > arr[ir]) {
                dswap = arr[l];
                arr[l] = arr[ir];
                arr[ir] = dswap;
            }
            if (arr[l + 1] > arr[ir]) {
                dswap = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = dswap;
            }
            if (arr[l] > arr[l + 1]) {
                dswap = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = dswap;
            }
            int i = l + 1;
            int j = ir;
            double a = arr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                dswap = arr[i];
                arr[i] = arr[j];
                arr[j] = dswap;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if (j >= k) {
                ir = j - 1;
            }
            if (j > k) continue;
            l = i;
        }
    }

    public static void sort(int n, double[] arr) {
        int ir = n;
        int l = 1;
        int[] istack = null;
        int jstack = 0;
        int NSTACK = 50;
        int M = 7;
        istack = new int[NSTACK + 1];
        while (true) {
            int i;
            double a;
            int j;
            if (ir - l < M) {
                j = l + 1;
                while (j <= ir) {
                    a = arr[j];
                    i = j - 1;
                    while (i >= l) {
                        if (arr[i] <= a) break;
                        arr[i + 1] = arr[i];
                        --i;
                    }
                    arr[i + 1] = a;
                    ++j;
                }
                if (jstack == 0) break;
                ir = istack[jstack--];
                l = istack[jstack--];
                continue;
            }
            int k = l + ir >> 1;
            double dswap = arr[k];
            arr[k] = arr[l + 1];
            arr[l + 1] = dswap;
            if (arr[l] > arr[ir]) {
                dswap = arr[l];
                arr[l] = arr[ir];
                arr[ir] = dswap;
            }
            if (arr[l + 1] > arr[ir]) {
                dswap = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = dswap;
            }
            if (arr[l] > arr[l + 1]) {
                dswap = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = dswap;
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            while (true) {
                if (arr[++i] < a) {
                    continue;
                }
                while (arr[--j] > a) {
                }
                if (j < i) break;
                dswap = arr[i];
                arr[i] = arr[j];
                arr[j] = dswap;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            jstack += 2;
            if (ir - i + 1 >= j - l) {
                istack[jstack] = ir;
                istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            istack[jstack] = j - 1;
            istack[jstack - 1] = l;
            l = i;
        }
        istack = null;
    }

    public static boolean xGaussj(Complex[][] a, int n, Complex[][] b, int m) {
        int imm;
        double[][] da = new double[2 * n + 1][2 * n + 1];
        double[][] db = new double[2 * n + 1][m + 1];
        int inn = 0;
        while (inn < n) {
            imm = 0;
            while (imm < n) {
                da[2 * inn + 1][2 * imm + 1] = a[inn][imm].re;
                da[2 * inn + 1][2 * imm + 2] = -a[inn][imm].im;
                da[2 * inn + 2][2 * imm + 1] = a[inn][imm].im;
                da[2 * inn + 2][2 * imm + 2] = a[inn][imm].re;
                ++imm;
            }
            imm = 0;
            while (imm < m) {
                db[2 * inn + 1][imm + 1] = b[inn][imm].re;
                db[2 * inn + 2][imm + 1] = b[inn][imm].im;
                ++imm;
            }
            ++inn;
        }
        boolean success = NR.Guassj(da, 2 * n, db, m);
        if (!success) {
            return success;
        }
        inn = 0;
        while (inn < n) {
            imm = 0;
            while (imm < n) {
                a[inn][imm].re = da[2 * inn + 1][2 * imm + 1];
                a[inn][imm].im = da[2 * inn + 2][2 * imm + 1];
                ++imm;
            }
            imm = 0;
            while (imm < m) {
                b[inn][imm].re = db[2 * inn + 1][imm + 1];
                b[inn][imm].im = db[2 * inn + 2][imm + 1];
                ++imm;
            }
            ++inn;
        }
        return success;
    }

    protected void testxGaussj() {
        Complex[][] xamat = new Complex[3][3];
        Complex[][] xbmat = new Complex[3][1];
        xamat[0][0] = new Complex(1.0, 1.0);
        xamat[0][1] = new Complex(0.0, 0.0);
        xamat[0][2] = new Complex(1.0, -2.0);
        xamat[1][0] = new Complex(0.0, 0.0);
        xamat[1][1] = new Complex(1.0, 0.0);
        xamat[1][2] = new Complex(0.0, 0.0);
        xamat[2][0] = new Complex(1.0, 2.0);
        xamat[2][1] = new Complex(0.0, 0.0);
        xamat[2][2] = new Complex(1.0, -1.0);
        xbmat[0][0] = new Complex(0.0, -0.0);
        xbmat[1][0] = new Complex(0.0, 0.0);
        xbmat[2][0] = new Complex(0.0, 0.0);
        NR.xGaussj(xamat, 3, xbmat, 1);
        int ii = 0;
        while (ii < 3) {
            System.out.println("b" + ii + " = " + xbmat[ii][0].re + " +j" + xbmat[ii][0].im);
            ++ii;
        }
        ii = 0;
        while (ii < 3) {
            int ij = 0;
            while (ij < 3) {
                System.out.println("ainv " + ii + "," + ij + " = " + xamat[ii][ij].re + " +j" + xamat[ii][ij].im);
                ++ij;
            }
            ++ii;
        }
    }

    protected void testGaussj0() {
        double[][] amat = new double[3][3];
        double[][] bmat = new double[3][1];
        amat[0][0] = 1.0;
        amat[0][1] = 0.0;
        amat[0][2] = 2.0;
        amat[1][0] = 0.0;
        amat[1][1] = 3.0;
        amat[1][2] = 0.0;
        amat[2][0] = 4.0;
        amat[2][1] = 0.0;
        amat[2][2] = 5.0;
        bmat[0][0] = 6.0;
        bmat[1][0] = 7.0;
        bmat[2][0] = 8.0;
        NR.Guassj0(amat, 3, bmat, 1);
        int ii = 0;
        while (ii < 3) {
            System.out.println("b" + ii + " = " + bmat[ii][0]);
            ++ii;
        }
    }

    public static double gaussRandom(double mean, double stdev) {
        double v;
        double u = 2.0 * Math.random() - 1.0;
        double r = u * u + (v = 2.0 * Math.random() - 1.0) * v;
        if (r == 0.0 || r > 1.0) {
            return NR.gaussRandom(mean, stdev);
        }
        double c = Math.sqrt(-2.0 * Math.log(r) / r);
        return u * c * stdev + mean;
    }

    private void testgaussRandom() {
        try {
            PrintStream ps = new PrintStream("test.dat");
            int ii = 0;
            while (ii < 1000) {
                ps.println(NR.gaussRandom(0.0, 2.0));
                ++ii;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        NR nr = new NR();
        nr.testgaussRandom();
    }
}

