/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.DoubleMatrix;
import com.astrofizzbizz.numericalrecipes.NumericalRecipesException;
import java.io.Serializable;

public class PolyFit
implements Serializable {
    private static final long serialVersionUID = 4197949090190409609L;
    private double xMin;
    private double xMax;
    private double[] coeff;
    private int fitOrder;

    public PolyFit(double[] xData, double[] yData, double[] sigma, int fitOrder) throws NumericalRecipesException {
        int numDataPts = xData.length;
        if (yData.length != numDataPts) {
            throw new NumericalRecipesException("Y data vector length does not match X Vector");
        }
        if (sigma != null && sigma.length != numDataPts) {
            throw new NumericalRecipesException("Sigma data vector length does not match X Vector");
        }
        this.fitOrder = fitOrder;
        this.xMin = xData[0];
        this.xMax = xData[0];
        int ii = 0;
        while (ii < numDataPts) {
            if (this.xMin > xData[ii]) {
                this.xMin = xData[ii];
            }
            if (this.xMax < xData[ii]) {
                this.xMax = xData[ii];
            }
            ++ii;
        }
        DoubleMatrix fitMatrixCalc = new DoubleMatrix(fitOrder, fitOrder);
        double[] fitVec = new double[fitOrder];
        int ii2 = 0;
        while (ii2 < fitOrder) {
            fitVec[ii2] = 0.0;
            ++ii2;
        }
        int im = 0;
        while (im < numDataPts) {
            int ii3 = 0;
            while (ii3 < fitOrder) {
                double vecElemCont = yData[im] * this.xPow(this.xNorm(xData[im]), ii3) / (double)numDataPts;
                if (sigma != null) {
                    vecElemCont /= sigma[im] * sigma[im];
                }
                fitVec[ii3] = fitVec[ii3] + vecElemCont;
                int ij = 0;
                while (ij < fitOrder) {
                    double matElemCont = this.xPow(this.xNorm(xData[im]), ii3) * this.xPow(this.xNorm(xData[im]), ij) / (double)numDataPts;
                    if (sigma != null) {
                        matElemCont /= sigma[im] * sigma[im];
                    }
                    fitMatrixCalc.cell[ii3][ij] = fitMatrixCalc.cell[ii3][ij] + matElemCont;
                    ++ij;
                }
                ++ii3;
            }
            ++im;
        }
        DoubleMatrix fitMatrixInv = fitMatrixCalc.invert();
        this.coeff = fitMatrixInv.times(fitVec);
    }

    private double xNorm(double x) {
        double xnorm = (x - this.xMin) / (this.xMax - this.xMin);
        return xnorm;
    }

    private double xPow(double x, int pow) {
        double xpow = 1.0;
        if (pow > 0) {
            int ipow = 1;
            while (ipow <= pow) {
                xpow *= x;
                ++ipow;
            }
        }
        return xpow;
    }

    public double fit(double x) {
        double yfit = 0.0;
        int ii = 0;
        while (ii < this.fitOrder) {
            yfit += this.coeff[ii] * this.xPow(this.xNorm(x), ii);
            ++ii;
        }
        return yfit;
    }

    public static void main(String[] args) {
    }
}

