/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.utilities.simplewebbrowser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class SimpleWebBrowserPanel
extends JPanel
implements HyperlinkListener,
ActionListener {
    private static final long serialVersionUID = -1025941314111863887L;
    private JButton homeButton;
    private JButton backButton;
    private JButton forwardButton;
    private JTextField urlField;
    private JEditorPane htmlPane;
    private String currentUrl;
    private String initialUrl;
    private JFrame parentFrame;
    private ArrayList<String> urlHistory = new ArrayList(20);
    private int historyIndex = 0;

    public SimpleWebBrowserPanel(String initialUrl, JFrame parentFrame) {
        this.currentUrl = initialUrl;
        this.initialUrl = initialUrl;
        this.parentFrame = parentFrame;
        this.urlHistory.add(initialUrl);
        this.setLayout(new BoxLayout(this, 3));
        JPanel topPanel = new JPanel();
        topPanel.setBackground(Color.lightGray);
        this.homeButton = new JButton("Home");
        this.homeButton.addActionListener(this);
        JLabel urlLabel = new JLabel("URL:");
        this.urlField = new JTextField(50);
        this.urlField.setText(initialUrl);
        this.urlField.addActionListener(this);
        this.backButton = new JButton("Back");
        this.backButton.addActionListener(this);
        this.forwardButton = new JButton("Forward");
        this.forwardButton.addActionListener(this);
        topPanel.add(this.backButton);
        topPanel.add(this.forwardButton);
        topPanel.add(this.homeButton);
        topPanel.add(urlLabel);
        topPanel.add(this.urlField);
        this.setNavButtonVisibility();
        topPanel.setMaximumSize(new Dimension(3000, 40));
        this.add(topPanel);
        try {
            this.htmlPane = new JEditorPane(initialUrl);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane(this.htmlPane);
            this.add(scrollPane);
        }
        catch (IOException ioe) {
            this.warnUser("Can't build HTML pane for " + initialUrl + ": " + ioe);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.urlField) {
            this.currentUrl = this.urlField.getText();
            ++this.historyIndex;
            this.urlHistory.add(this.historyIndex, this.currentUrl);
        }
        if (event.getSource() == this.homeButton) {
            this.currentUrl = this.initialUrl;
            ++this.historyIndex;
            this.urlHistory.add(this.historyIndex, this.currentUrl);
        }
        if (event.getSource() == this.backButton) {
            --this.historyIndex;
            if (this.historyIndex < 0) {
                this.historyIndex = 0;
            }
            this.currentUrl = this.urlHistory.get(this.historyIndex);
        }
        if (event.getSource() == this.forwardButton) {
            ++this.historyIndex;
            if (this.historyIndex >= this.urlHistory.size()) {
                this.historyIndex = this.urlHistory.size() - 1;
            }
            this.currentUrl = this.urlHistory.get(this.historyIndex);
        }
        this.setNavButtonVisibility();
        try {
            this.htmlPane.setPage(new URL(this.currentUrl));
            this.urlField.setText(this.currentUrl);
        }
        catch (IOException ioe) {
            this.warnUser("Can't follow link to " + this.currentUrl + ": " + ioe);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
                this.currentUrl = event.getURL().toExternalForm();
                this.urlField.setText(this.currentUrl);
                ++this.historyIndex;
                this.urlHistory.add(this.historyIndex, this.currentUrl);
                this.setNavButtonVisibility();
            }
            catch (IOException ioe) {
                this.warnUser("Can't follow link to " + event.getURL().toExternalForm() + ": " + ioe);
            }
        }
    }

    private void setNavButtonVisibility() {
        if (this.historyIndex == 0) {
            this.backButton.setEnabled(false);
        } else {
            this.backButton.setEnabled(true);
        }
        if (this.historyIndex == this.urlHistory.size() - 1) {
            this.forwardButton.setEnabled(false);
        } else {
            this.forwardButton.setEnabled(true);
        }
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this.parentFrame, message, "Error", 0);
    }
}

