/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.TableData;

public abstract class TableHDU
extends BasicHDU {
    private TableData table;
    private int currentColumn;

    TableHDU(TableData td) {
        this.table = td;
    }

    public Object[] getRow(int row) throws FitsException {
        return this.table.getRow(row);
    }

    public Object getColumn(String colName) throws FitsException {
        return this.getColumn(this.findColumn(colName));
    }

    public Object getColumn(int col) throws FitsException {
        return this.table.getColumn(col);
    }

    public Object[] getColumns() throws FitsException {
        Object[] result = new Object[this.getNCols()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getColumn(i);
            ++i;
        }
        return result;
    }

    public Object getElement(int row, int col) throws FitsException {
        return this.table.getElement(row, col);
    }

    public void setRow(int row, Object[] newRow) throws FitsException {
        this.table.setRow(row, newRow);
    }

    public void setColumn(String colName, Object newCol) throws FitsException {
        this.setColumn(this.findColumn(colName), newCol);
    }

    public void setColumn(int col, Object newCol) throws FitsException {
        this.table.setColumn(col, newCol);
    }

    public void setElement(int row, int col, Object element) throws FitsException {
        this.table.setElement(row, col, element);
    }

    public int addRow(Object[] newRow) throws FitsException {
        int row = this.table.addRow(newRow);
        this.myHeader.addValue("NAXIS2", row, (String)null);
        return row;
    }

    public int findColumn(String colName) {
        int i = 0;
        while (i < this.getNCols()) {
            String val = this.myHeader.getStringValue("TTYPE" + (i + 1));
            if (val != null && val.trim().equals(colName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public abstract int addColumn(Object var1) throws FitsException;

    public int getNCols() {
        return this.table.getNCols();
    }

    public int getNRows() {
        return this.table.getNRows();
    }

    public String getColumnName(int index) {
        String ttype = this.myHeader.getStringValue("TTYPE" + (index + 1));
        if (ttype != null) {
            ttype = ttype.trim();
        }
        return ttype;
    }

    public void setColumnName(int index, String name, String comment) throws FitsException {
        this.setColumnMeta(index, "TTYPE", name, comment, true);
    }

    public void setColumnMeta(int index, String key, String value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(String.valueOf(key) + (index + 1), value, comment);
    }

    public void setColumnMeta(int index, String key, String value, String comment) throws FitsException {
        this.setColumnMeta(index, key, value, comment, true);
    }

    public void setColumnMeta(int index, String key, long value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(String.valueOf(key) + (index + 1), value, comment);
    }

    public void setColumnMeta(int index, String key, double value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(String.valueOf(key) + (index + 1), value, comment);
    }

    public void setColumnMeta(int index, String key, boolean value, String comment, boolean after) throws FitsException {
        this.setCurrentColumn(index, after);
        this.myHeader.addValue(String.valueOf(key) + (index + 1), value, comment);
    }

    public String getColumnFormat(int index) throws FitsException {
        int flds = this.myHeader.getIntValue("TFIELDS", 0);
        if (index < 0 || index >= flds) {
            throw new FitsException("Bad column index " + index + " (only " + flds + " columns)");
        }
        return this.myHeader.getStringValue("TFORM" + (index + 1)).trim();
    }

    public void setCurrentColumn(int col) {
        this.setCurrentColumn(col, true);
    }

    public void setCurrentColumn(int col, boolean after) {
        if (after) {
            this.myHeader.positionAfterIndex("TFORM", col + 1);
        } else {
            String tform = "TFORM" + (col + 1);
            this.myHeader.findCard(tform);
        }
    }

    public void deleteRows(int row) throws FitsException {
        this.deleteRows(row, this.getNRows() - row);
    }

    public void deleteRows(int firstRow, int nRow) throws FitsException {
        if (nRow <= 0 || firstRow >= this.getNRows() || nRow <= 0) {
            return;
        }
        if (nRow > this.getNRows() - firstRow) {
            nRow = this.getNRows() - firstRow;
        }
        this.table.deleteRows(firstRow, nRow);
        this.myHeader.setNaxis(2, this.getNRows());
    }

    public void deleteColumnsIndexOne(int column, int len) throws FitsException {
        this.deleteColumnsIndexZero(column - 1, len);
    }

    public void deleteColumnsIndexZero(int column, int len) throws FitsException {
        this.deleteColumnsIndexZero(column, len, this.columnKeyStems());
    }

    public void deleteColumnsIndexOne(int column, int len, String[] fields) throws FitsException {
        this.deleteColumnsIndexZero(column - 1, len, fields);
    }

    public void deleteColumnsIndexZero(int column, int len, String[] fields) throws FitsException {
        int fld;
        if (column < 0 || len < 0 || column + len > this.getNCols()) {
            throw new FitsException("Illegal columns deletion request- Start:" + column + " Len:" + len + " from table with " + this.getNCols() + " columns");
        }
        if (len == 0) {
            return;
        }
        int ncol = this.getNCols();
        this.table.deleteColumns(column, len);
        int col = column;
        while (col < column + len) {
            fld = 0;
            while (fld < fields.length) {
                String key = String.valueOf(fields[fld]) + (col + 1);
                this.myHeader.deleteKey(key);
                ++fld;
            }
            ++col;
        }
        col = column + len;
        while (col < ncol) {
            fld = 0;
            while (fld < fields.length) {
                String oldKey = String.valueOf(fields[fld]) + (col + 1);
                String newKey = String.valueOf(fields[fld]) + (col + 1 - len);
                if (this.myHeader.containsKey(oldKey)) {
                    this.myHeader.replaceKey(oldKey, newKey);
                }
                ++fld;
            }
            ++col;
        }
        this.myHeader.addValue("TFIELDS", this.getNCols(), "Number of table fields");
        this.table.updateAfterDelete(ncol, this.myHeader);
    }

    public abstract String[] columnKeyStems();
}

