/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.astroimageprocessor;

import com.astrofizzbizz.utilities.WaitFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class AstroImageProcessorLauncher {
    public static int launch(int maxHeap, int minHeap, String pathToJar, String mainClass, String args) throws IOException {
        System.gc();
        System.out.println(System.getProperties().toString());
        String delim = System.getProperty("file.separator");
        String javaPath = String.valueOf(System.getProperty("java.home")) + delim + "bin" + delim + "java";
        javaPath.replaceAll(" ", "\\ ");
        ProcessBuilder pb = new ProcessBuilder(javaPath, "-Xmx" + maxHeap + "m", "-Xms" + minHeap + "m", "-classpath", pathToJar, mainClass, args);
        Process process = pb.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String read = br.readLine();
        if (read.equals(args)) {
            return 1;
        }
        if (read.equals("Error occurred during initialization of VM") && (read = br.readLine()).equals("Could not reserve enough space for object heap")) {
            return -1;
        }
        System.out.println(read);
        return 0;
    }

    public static void launchLoop(int maxHeap, int minHeap, String pathToJar, String mainClass) throws IOException {
        String args = "test";
        int test = AstroImageProcessorLauncher.launch(maxHeap, minHeap, pathToJar, mainClass, args);
        while (test < 0) {
            test = (maxHeap -= 100) > minHeap ? AstroImageProcessorLauncher.launch(maxHeap, minHeap, pathToJar, mainClass, args) : 0;
        }
        if (test < 1) {
            new WaitFrame("Error", mainClass, null);
        }
    }

    public static void bruteForceLauncher() {
        String path = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "AstroImageProcessor.jar";
        String[] errStatus = null;
        try {
            Runtime.getRuntime().exec("java -Xmx1024m -Xms256m -jar " + path);
        }
        catch (IOException e) {
            errStatus = new String[]{e.getMessage()};
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        int maxHeap = 1024;
        int minHeap = 256;
        String mainClass = "com.astrofizzbizz.astroimageprocessor.AstroImageProcessorGui";
        String path = AstroImageProcessorLauncher.class.getResource(String.valueOf(AstroImageProcessorLauncher.class.getSimpleName()) + ".class").getFile();
        if (path.startsWith("/")) {
            new WaitFrame("AstroImageProcessor", "Error. This class must be launched from a .jar file.", null);
            return;
        }
        File jarFile = new File(path.substring(0, path.lastIndexOf(33)));
        String pathToJar = jarFile.getName();
        try {
            AstroImageProcessorLauncher.launchLoop(maxHeap, minHeap, pathToJar, mainClass);
        }
        catch (Exception e) {
            new WaitFrame("AstroImageProcessor", e.getMessage(), null);
        }
    }
}

