/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.Complex;
import com.astrofizzbizz.numericalrecipes.Vector3D;
import java.io.Serializable;

public class ComplexVector3D
implements Serializable {
    private static final long serialVersionUID = 7471444368177319847L;
    public Complex[] vec = new Complex[3];

    public ComplexVector3D() {
        int ii = 0;
        while (ii < 3) {
            this.vec[ii] = new Complex();
            ++ii;
        }
    }

    public void copy(ComplexVector3D cv) {
        if (cv == null) {
            int ii = 0;
            while (ii < 3) {
                this.vec[ii].im = 0.0;
                this.vec[ii].re = 0.0;
                ++ii;
            }
        } else {
            int ii = 0;
            while (ii < 3) {
                this.vec[ii].re = cv.vec[ii].re;
                this.vec[ii].im = cv.vec[ii].im;
                ++ii;
            }
        }
    }

    public ComplexVector3D(ComplexVector3D cv) {
        this.copy(cv);
    }

    public ComplexVector3D(Vector3D v) {
        int ii = 0;
        while (ii < 3) {
            this.vec[ii] = new Complex(v.vec[ii]);
            ++ii;
        }
    }

    public ComplexVector3D plus(ComplexVector3D cv) {
        ComplexVector3D sum = new ComplexVector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii].plus(cv.vec[ii]);
            ++ii;
        }
        return sum;
    }

    public ComplexVector3D plus(Vector3D v) {
        ComplexVector3D cv = new ComplexVector3D(v);
        return this.plus(cv);
    }

    public ComplexVector3D minus(ComplexVector3D cv) {
        ComplexVector3D sum = new ComplexVector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii].minus(cv.vec[ii]);
            ++ii;
        }
        return sum;
    }

    public ComplexVector3D minus(Vector3D v) {
        ComplexVector3D cv = new ComplexVector3D(v);
        return this.minus(cv);
    }

    public ComplexVector3D times(Complex c) {
        ComplexVector3D sum = new ComplexVector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii].times(c);
            ++ii;
        }
        return sum;
    }

    public ComplexVector3D times(double d) {
        ComplexVector3D sum = new ComplexVector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii].times(d);
            ++ii;
        }
        return sum;
    }

    public ComplexVector3D conj() {
        ComplexVector3D sum = new ComplexVector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii].conj();
            ++ii;
        }
        return sum;
    }

    public Complex dot(ComplexVector3D cv) {
        Complex sum = new Complex();
        int ii = 0;
        while (ii < 3) {
            Complex itemSum = this.vec[ii].times(cv.vec[ii]);
            sum = sum.plus(itemSum);
            ++ii;
        }
        return sum;
    }

    public Complex dot(Vector3D v) {
        ComplexVector3D cv = new ComplexVector3D(v);
        return this.dot(cv);
    }

    public double magnitude() {
        ComplexVector3D convec = this.conj();
        Complex dotprod = this.dot(convec);
        return Math.sqrt(dotprod.re);
    }

    public ComplexVector3D cross(ComplexVector3D cv) {
        ComplexVector3D sum = new ComplexVector3D();
        ComplexVector3D sum1 = new ComplexVector3D();
        ComplexVector3D sum2 = new ComplexVector3D();
        sum1.vec[0] = new Complex(this.vec[1]);
        sum1.vec[1] = new Complex(this.vec[2]);
        sum1.vec[2] = new Complex(this.vec[0]);
        sum1.vec[0] = sum1.vec[0].times(cv.vec[2]);
        sum1.vec[1] = sum1.vec[1].times(cv.vec[0]);
        sum1.vec[2] = sum1.vec[2].times(cv.vec[1]);
        sum2.vec[0] = new Complex(this.vec[2]);
        sum2.vec[1] = new Complex(this.vec[0]);
        sum2.vec[2] = new Complex(this.vec[1]);
        sum2.vec[0] = sum2.vec[0].times(cv.vec[1]);
        sum2.vec[1] = sum2.vec[1].times(cv.vec[2]);
        sum2.vec[2] = sum2.vec[2].times(cv.vec[0]);
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = sum1.vec[ii].minus(sum2.vec[ii]);
            ++ii;
        }
        return sum;
    }

    public ComplexVector3D cross(Vector3D v) {
        ComplexVector3D cv = new ComplexVector3D(v);
        ComplexVector3D sum = this.cross(cv);
        return sum;
    }

    public static void main(String[] args) {
        ComplexVector3D cv1 = new ComplexVector3D();
        ComplexVector3D cv2 = new ComplexVector3D();
        cv1.vec[0] = new Complex(1.0, 0.0);
        cv1.vec[1] = new Complex(2.0, 2.0);
        cv1.vec[2] = new Complex(3.0, 1.0);
        cv2.vec[0] = new Complex(4.0, 6.0);
        cv2.vec[1] = new Complex(5.0, 5.0);
        cv2.vec[2] = new Complex(6.0, 4.0);
        Complex dotsum = cv1.dot(cv2);
        System.out.println("real = " + dotsum.re + " imag = " + dotsum.im);
        ComplexVector3D crossvec = cv1.cross(cv2);
        int ii = 0;
        while (ii < 3) {
            System.out.println("real = " + crossvec.vec[ii].re + " imag = " + crossvec.vec[ii].im);
            ++ii;
        }
    }

    public String dumpData() {
        String sdata = "";
        int ii = 0;
        while (ii < 3) {
            sdata = String.valueOf(sdata) + "Comp " + ii + "  : " + this.vec[ii].dumpData() + "\n";
            ++ii;
        }
        return sdata;
    }
}

