/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.Complex;
import com.astrofizzbizz.numericalrecipes.ComplexVector3D;
import java.io.Serializable;

public class Vector3D
implements Serializable {
    private static final long serialVersionUID = 5226258694020805322L;
    public double[] vec = new double[3];

    public Vector3D() {
        int ii = 0;
        while (ii < 3) {
            this.vec[ii] = 0.0;
            ++ii;
        }
    }

    public Vector3D(double x, double y, double z) {
        this.vec[0] = x;
        this.vec[1] = y;
        this.vec[2] = z;
    }

    public void copy(Vector3D v) {
        if (v == null) {
            int ii = 0;
            while (ii < 3) {
                this.vec[ii] = 0.0;
                ++ii;
            }
        } else {
            int ii = 0;
            while (ii < 3) {
                this.vec[ii] = v.vec[ii];
                ++ii;
            }
        }
    }

    public Vector3D(Vector3D v) {
        this.copy(v);
    }

    public Vector3D plus(Vector3D v) {
        Vector3D sum = new Vector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii] + v.vec[ii];
            ++ii;
        }
        return sum;
    }

    public Vector3D minus(Vector3D v) {
        Vector3D sum = new Vector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii] - v.vec[ii];
            ++ii;
        }
        return sum;
    }

    public Vector3D times(double d) {
        Vector3D sum = new Vector3D();
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = this.vec[ii] * d;
            ++ii;
        }
        return sum;
    }

    public double dot(Vector3D v) {
        double sum = 0.0;
        int ii = 0;
        while (ii < 3) {
            sum += this.vec[ii] * v.vec[ii];
            ++ii;
        }
        return sum;
    }

    public double magnitude() {
        double sum = 0.0;
        int ii = 0;
        while (ii < 3) {
            sum += this.vec[ii] * this.vec[ii];
            ++ii;
        }
        return Math.sqrt(sum);
    }

    public Vector3D cross(Vector3D v) {
        Vector3D sum = new Vector3D();
        Vector3D sum1 = new Vector3D();
        Vector3D sum2 = new Vector3D();
        sum1.vec[0] = this.vec[1];
        sum1.vec[1] = this.vec[2];
        sum1.vec[2] = this.vec[0];
        sum1.vec[0] = sum1.vec[0] * v.vec[2];
        sum1.vec[1] = sum1.vec[1] * v.vec[0];
        sum1.vec[2] = sum1.vec[2] * v.vec[1];
        sum2.vec[0] = this.vec[2];
        sum2.vec[1] = this.vec[0];
        sum2.vec[2] = this.vec[1];
        sum2.vec[0] = sum2.vec[0] * v.vec[1];
        sum2.vec[1] = sum2.vec[1] * v.vec[2];
        sum2.vec[2] = sum2.vec[2] * v.vec[0];
        int ii = 0;
        while (ii < 3) {
            sum.vec[ii] = sum1.vec[ii] - sum2.vec[ii];
            ++ii;
        }
        return sum;
    }

    public ComplexVector3D cross(ComplexVector3D cv) {
        ComplexVector3D cvthis = new ComplexVector3D(this);
        return cvthis.cross(cv);
    }

    public Complex dot(ComplexVector3D cv) {
        ComplexVector3D cvthis = new ComplexVector3D(this);
        return cvthis.dot(cv);
    }

    public ComplexVector3D plus(ComplexVector3D cv) {
        ComplexVector3D cvthis = new ComplexVector3D(this);
        return cvthis.plus(cv);
    }

    public ComplexVector3D minus(ComplexVector3D cv) {
        ComplexVector3D cvthis = new ComplexVector3D(this);
        return cvthis.minus(cv);
    }

    public ComplexVector3D times(Complex c) {
        ComplexVector3D cvthis = new ComplexVector3D(this);
        return cvthis.times(c);
    }

    public String dumpData() {
        String sdata = "";
        int ii = 0;
        while (ii < 3) {
            sdata = String.valueOf(sdata) + "Comp " + ii + "  : " + this.vec[ii] + "\n";
            ++ii;
        }
        return sdata;
    }
}

