/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes.jama.examples;

import com.astrofizzbizz.numericalrecipes.jama.EigenvalueDecomposition;
import com.astrofizzbizz.numericalrecipes.jama.LUDecomposition;
import com.astrofizzbizz.numericalrecipes.jama.Matrix;
import com.astrofizzbizz.numericalrecipes.jama.QRDecomposition;
import java.text.DecimalFormat;
import java.util.Date;

public class MagicSquareExample {
    public static Matrix magic(int n) {
        double[][] M = new double[n][n];
        if (n % 2 == 1) {
            int a = (n + 1) / 2;
            int b = n + 1;
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    M[i][j] = n * ((i + j + a) % n) + (i + 2 * j + b) % n + 1;
                    ++i;
                }
                ++j;
            }
        } else if (n % 4 == 0) {
            int j = 0;
            while (j < n) {
                int i = 0;
                while (i < n) {
                    M[i][j] = (i + 1) / 2 % 2 == (j + 1) / 2 % 2 ? (double)(n * n - n * i - j) : (double)(n * i + j + 1);
                    ++i;
                }
                ++j;
            }
        } else {
            int p = n / 2;
            int k = (n - 2) / 4;
            Matrix A = MagicSquareExample.magic(p);
            int j = 0;
            while (j < p) {
                int i = 0;
                while (i < p) {
                    double aij;
                    M[i][j] = aij = A.get(i, j);
                    M[i][j + p] = aij + (double)(2 * p * p);
                    M[i + p][j] = aij + (double)(3 * p * p);
                    M[i + p][j + p] = aij + (double)(p * p);
                    ++i;
                }
                ++j;
            }
            int i = 0;
            while (i < p) {
                double t;
                int j2 = 0;
                while (j2 < k) {
                    t = M[i][j2];
                    M[i][j2] = M[i + p][j2];
                    M[i + p][j2] = t;
                    ++j2;
                }
                j2 = n - k + 1;
                while (j2 < n) {
                    t = M[i][j2];
                    M[i][j2] = M[i + p][j2];
                    M[i + p][j2] = t;
                    ++j2;
                }
                ++i;
            }
            double t = M[k][0];
            M[k][0] = M[k + p][0];
            M[k + p][0] = t;
            t = M[k][k];
            M[k][k] = M[k + p][k];
            M[k + p][k] = t;
        }
        return new Matrix(M);
    }

    private static void print(String s) {
        System.out.print(s);
    }

    public static String fixedWidthDoubletoString(double x, int w, int d) {
        DecimalFormat fmt = new DecimalFormat();
        fmt.setMaximumFractionDigits(d);
        fmt.setMinimumFractionDigits(d);
        fmt.setGroupingUsed(false);
        String s = fmt.format(x);
        while (s.length() < w) {
            s = " " + s;
        }
        return s;
    }

    public static String fixedWidthIntegertoString(int n, int w) {
        String s = Integer.toString(n);
        while (s.length() < w) {
            s = " " + s;
        }
        return s;
    }

    public static void main(String[] argv) {
        MagicSquareExample.print("\n    Test of Matrix Class, using magic squares.\n");
        MagicSquareExample.print("    See MagicSquareExample.main() for an explanation.\n");
        MagicSquareExample.print("\n      n     trace       max_eig   rank        cond      lu_res      qr_res\n\n");
        Date start_time = new Date();
        double eps = Math.pow(2.0, -52.0);
        int n = 3;
        while (n <= 32) {
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(n, 7));
            Matrix M = MagicSquareExample.magic(n);
            int t = (int)M.trace();
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(t, 10));
            EigenvalueDecomposition E = new EigenvalueDecomposition(M.plus(M.transpose()).times(0.5));
            double[] d = E.getRealEigenvalues();
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(d[n - 1], 14, 3));
            int r = M.rank();
            MagicSquareExample.print(MagicSquareExample.fixedWidthIntegertoString(r, 7));
            double c = M.cond();
            MagicSquareExample.print(c < 1.0 / eps ? MagicSquareExample.fixedWidthDoubletoString(c, 12, 3) : "         Inf");
            LUDecomposition LU = new LUDecomposition(M);
            Matrix L = LU.getL();
            Matrix U = LU.getU();
            int[] p = LU.getPivot();
            Matrix R = L.times(U).minus(M.getMatrix(p, 0, n - 1));
            double res = R.norm1() / ((double)n * eps);
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(res, 12, 3));
            QRDecomposition QR = new QRDecomposition(M);
            Matrix Q = QR.getQ();
            R = QR.getR();
            R = Q.times(R).minus(M);
            res = R.norm1() / ((double)n * eps);
            MagicSquareExample.print(MagicSquareExample.fixedWidthDoubletoString(res, 12, 3));
            MagicSquareExample.print("\n");
            ++n;
        }
        Date stop_time = new Date();
        double etime = (double)(stop_time.getTime() - start_time.getTime()) / 1000.0;
        MagicSquareExample.print("\nElapsed Time = " + MagicSquareExample.fixedWidthDoubletoString(etime, 12, 3) + " seconds\n");
        MagicSquareExample.print("Adios\n");
    }
}

