/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.PixieImage;
import nom.tam.fits.Header;

public class PixieCoord {
    private int row = 0;
    private int col = 0;
    private double ra = 0.0;
    private double dec = 0.0;

    public PixieCoord() {
        this.row = 0;
        this.col = 0;
        this.ra = 0.0;
        this.dec = 0.0;
    }

    public PixieCoord(int row, int col) {
        this.row = row;
        this.col = col;
        this.ra = 0.0;
        this.dec = 0.0;
    }

    public PixieCoord(PixieCoord c) {
        this.row = c.row;
        this.col = c.col;
        this.ra = c.ra;
        this.dec = c.dec;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public double getRa() {
        return this.ra;
    }

    public double getDec() {
        return this.dec;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public void setRa(double ra) {
        this.ra = ra;
    }

    public void setDec(double dec) {
        this.dec = dec;
    }

    public void setRaDec(Header hdr) {
        double[] raDec = PixieImage.rowColToRaDec(hdr, this.row, this.col);
        this.ra = raDec[0];
        this.dec = raDec[1];
    }

    public String getKey() {
        String skey = String.valueOf(Integer.toString(this.row)) + "," + Integer.toString(this.col);
        return skey;
    }

    public boolean checkKey(String skey) {
        String[] scoord = skey.split(",");
        int crow = Integer.valueOf(scoord[0]);
        int ccol = Integer.valueOf(scoord[1]);
        boolean test = this.row == crow && this.col == ccol;
        return test;
    }
}

