/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.numericalrecipes.NR;
import com.astrofizzbizz.pixie.Pixie;
import com.astrofizzbizz.pixie.PixieCoord;
import com.astrofizzbizz.pixie.PixieImage;
import com.astrofizzbizz.pixie.PixieImageException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PixiePuddle {
    Map<String, Pixie> puddleMap = new HashMap<String, Pixie>();
    Map<String, Pixie> borderMap = new HashMap<String, Pixie>();

    public PixiePuddle() {
    }

    public PixiePuddle(PixiePuddle pc) {
        Pixie p1;
        for (String currentKey : pc.puddleMap.keySet()) {
            p1 = pc.puddleMap.get(currentKey);
            this.puddleMap.put(p1.getKey(), new Pixie(p1));
        }
        for (String currentKey : pc.borderMap.keySet()) {
            p1 = pc.borderMap.get(currentKey);
            this.borderMap.put(p1.getKey(), new Pixie(p1));
        }
    }

    public void addPixieColor(PixieImage pi, int icolor) {
        double val;
        Pixie pcPixie;
        String currentKey;
        double[][] dpix = pi.getPix();
        Iterator keys = this.puddleMapKeyIterator();
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            pcPixie = this.getPuddlePixie(currentKey);
            if (pcPixie.getRow() >= pi.getRowCount() || pcPixie.getCol() >= pi.getColCount()) continue;
            val = dpix[pcPixie.getRow()][pcPixie.getCol()];
            pcPixie.setColorVal(icolor, val);
            this.puddleMap.put(currentKey, new Pixie(pcPixie));
        }
        keys = this.borderMapKeyIterator();
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            pcPixie = this.getBorderPixie(currentKey);
            if (pcPixie.getRow() >= pi.getRowCount() || pcPixie.getCol() >= pi.getColCount()) continue;
            val = dpix[pcPixie.getRow()][pcPixie.getCol()];
            pcPixie.setColorVal(icolor, val);
            this.borderMap.put(currentKey, new Pixie(pcPixie));
        }
    }

    public PixiePuddle makeCopy() {
        Pixie pcopy;
        PixiePuddle pdCopy = new PixiePuddle();
        for (String currentKey : this.puddleMap.keySet()) {
            pcopy = this.puddleMap.get(currentKey);
            pdCopy.puddleMap.put(currentKey, pcopy);
        }
        for (String currentKey : this.borderMap.keySet()) {
            pcopy = this.borderMap.get(currentKey);
            pdCopy.borderMap.put(currentKey, pcopy);
        }
        return pdCopy;
    }

    private boolean checkMapKeys(Map<String, Pixie> map, String message) {
        boolean goodKeys = true;
        for (String currentKey : map.keySet()) {
            Pixie pcopy = map.get(currentKey);
            if (pcopy.getCoord().checkKey(currentKey)) continue;
            System.out.println(String.valueOf(message) + "Bad Key: Key=" + currentKey + " Coord=" + pcopy.getKey());
            goodKeys = false;
        }
        return goodKeys;
    }

    private int checkForAdjacentPixies(Pixie pseed) {
        Pixie ptest = this.puddleMap.get(pseed.getKey());
        if (ptest == null) {
            return -1;
        }
        int isum = 0;
        int ii = -1;
        while (ii <= 1) {
            int ij = -1;
            while (ij <= 1) {
                PixieCoord ctest;
                boolean centerPixie;
                boolean bl = centerPixie = ii == 0 && ij == 0;
                if (!centerPixie && (ptest = this.puddleMap.get((ctest = new PixieCoord(pseed.getRow() + ii, pseed.getCol() + ij)).getKey())) != null) {
                    ++isum;
                }
                ++ij;
            }
            ++ii;
        }
        return isum;
    }

    private void addPixie(Pixie padd) {
        int ij;
        this.puddleMap.put(padd.getKey(), new Pixie(padd));
        int[][] isumMatrix = new int[3][3];
        Pixie[][] pmatrix = new Pixie[3][3];
        int ii = -1;
        while (ii <= 1) {
            ij = -1;
            while (ij <= 1) {
                isumMatrix[ii + 1][ij + 1] = -1;
                PixieCoord ctest = new PixieCoord(padd.getRow() + ii, padd.getCol() + ij);
                if (this.puddleMap.containsKey(ctest.getKey())) {
                    pmatrix[ii + 1][ij + 1] = this.puddleMap.get(ctest.getKey());
                    isumMatrix[ii + 1][ij + 1] = this.checkForAdjacentPixies(pmatrix[ii + 1][ij + 1]);
                }
                ++ij;
            }
            ++ii;
        }
        ii = -1;
        while (ii <= 1) {
            ij = -1;
            while (ij <= 1) {
                if (isumMatrix[ii + 1][ij + 1] == 8) {
                    if (this.borderMap.containsKey(pmatrix[ii + 1][ij + 1].getKey())) {
                        this.borderMap.remove(pmatrix[ii + 1][ij + 1].getKey());
                    }
                } else if (isumMatrix[ii + 1][ij + 1] >= 0) {
                    this.borderMap.put(pmatrix[ii + 1][ij + 1].getKey(), new Pixie(pmatrix[ii + 1][ij + 1]));
                }
                ++ij;
            }
            ++ii;
        }
    }

    private void removePixie(PixieCoord cremove) {
        if (!this.puddleMap.containsKey(cremove.getKey())) {
            return;
        }
        this.puddleMap.remove(cremove.getKey());
        if (this.borderMap.containsKey(cremove.getKey())) {
            this.borderMap.remove(cremove.getKey());
        }
        int ii = -1;
        while (ii <= 1) {
            int ij = -1;
            while (ij <= 1) {
                PixieCoord ctest;
                boolean centerPixie;
                boolean bl = centerPixie = ii == 0 && ij == 0;
                if (!centerPixie && this.puddleMap.containsKey((ctest = new PixieCoord(cremove.getRow() + ii, cremove.getCol() + ij)).getKey())) {
                    Pixie pborder = this.puddleMap.get(ctest.getKey());
                    this.borderMap.put(pborder.getKey(), new Pixie(pborder));
                }
                ++ij;
            }
            ++ii;
        }
    }

    public PixiePuddle(PixieImage pimage, double dthreshold, double dmax_threshold) {
        double[][] dpix = pimage.getPix();
        int ii = 0;
        while (ii < pimage.getRowCount()) {
            int ij = 0;
            while (ij < pimage.getColCount()) {
                if (dthreshold <= dpix[ii][ij] && dpix[ii][ij] <= dmax_threshold) {
                    PixieCoord cadd = new PixieCoord(ii, ij);
                    cadd.setRaDec(pimage.getHeader());
                    this.addPixie(new Pixie(cadd, dpix[ii][ij]));
                }
                ++ij;
            }
            ++ii;
        }
    }

    public void removeFromPixieImage(PixieImage pi) {
        double[][] dpix = pi.getPix();
        for (String currentKey : this.puddleMap.keySet()) {
            Pixie premove = this.puddleMap.get(currentKey);
            if (premove.getRow() >= pi.getRowCount() || premove.getCol() >= pi.getColCount()) continue;
            dpix[premove.getRow()][premove.getCol()] = 0.0;
        }
    }

    private void addToExcludeMap(Map<String, Pixie> excludeMap) {
        for (String currentKey : this.puddleMap.keySet()) {
            Pixie p1 = this.puddleMap.get(currentKey);
            excludeMap.put(p1.getKey(), new Pixie(p1));
        }
    }

    public void addPuddle(PixiePuddle pc2) {
        for (String currentKey : pc2.puddleMap.keySet()) {
            this.addPixie(pc2.puddleMap.get(currentKey));
        }
    }

    public void subtractPuddle(PixiePuddle pc2) {
        for (String currentKey : pc2.puddleMap.keySet()) {
            Pixie premove = pc2.puddleMap.get(currentKey);
            this.removePixie(premove.getCoord());
        }
    }

    public PixieImage makePixieImage(PixieCoord pmin, PixieCoord pmax, boolean autofit) {
        if (autofit) {
            Pixie ptest;
            pmax.setRow(0);
            pmax.setCol(0);
            for (String currentKey : this.puddleMap.keySet()) {
                ptest = this.puddleMap.get(currentKey);
                if (pmax.getRow() < ptest.getRow()) {
                    pmax.setRow(ptest.getRow());
                }
                if (pmax.getCol() >= ptest.getCol()) continue;
                pmax.setCol(ptest.getCol());
            }
            pmin.setRow(pmax.getRow());
            pmin.setCol(pmax.getCol());
            for (String currentKey : this.puddleMap.keySet()) {
                ptest = this.puddleMap.get(currentKey);
                if (pmin.getRow() > ptest.getRow()) {
                    pmin.setRow(ptest.getRow());
                }
                if (pmin.getCol() <= ptest.getCol()) continue;
                pmin.setCol(ptest.getCol());
            }
        }
        PixieImage pi = new PixieImage(pmax.getRow() - pmin.getRow() + 1, pmax.getCol() - pmin.getCol() + 1);
        double[][] dpix = pi.getPix();
        for (String currentKey : this.puddleMap.keySet()) {
            Pixie ptest = this.puddleMap.get(currentKey);
            if (ptest.getRow() > pmax.getRow() || ptest.getCol() > pmax.getCol() || ptest.getRow() < pmin.getRow() || ptest.getCol() < pmin.getCol()) continue;
            dpix[ptest.getRow() - pmin.getRow()][ptest.getCol() - pmin.getCol()] = ptest.getCompVal();
        }
        return pi;
    }

    public void drawPuddleBorder(PixieImage pi, double borderValue) {
        Pixie pmax = pi.getURHCPixie();
        for (String currentKey : this.borderMap.keySet()) {
            Pixie p = new Pixie(this.borderMap.get(currentKey));
            p.setCompVal(borderValue);
            if (p.getRow() > pmax.getRow() || p.getCol() > pmax.getCol()) continue;
            pi.setPixieValue(p);
        }
    }

    public static PixieImage drawPuddleBorders(ArrayList<PixiePuddle> pcList, PixieCoord pmax, double borderValue) {
        PixieImage pi = new PixieImage(pmax);
        int ii = 0;
        while (ii < pcList.size()) {
            PixiePuddle pc = pcList.get(ii);
            pc.drawPuddleBorder(pi, borderValue);
            ++ii;
        }
        return pi;
    }

    public static PixieImage puddleCountImage(ArrayList<PixiePuddle> pcList, PixieCoord pmax, boolean randomCount, double scale) {
        PixieImage pi = new PixieImage(pmax);
        double[] randomVec = new double[]{10.0, 4.0, 7.0, 2.0, 5.0, 8.0, 3.0, 6.0, 9.0, 1.0};
        int icount = 0;
        int ii = 0;
        while (ii < pcList.size()) {
            double pixieValue;
            if (randomCount) {
                pixieValue = scale * randomVec[icount] / 10.0;
                if (++icount == 10) {
                    icount = 0;
                }
            } else {
                pixieValue = scale * (double)(ii + 1) / (double)pcList.size();
            }
            PixiePuddle pc = pcList.get(ii);
            for (String currentKey : pc.puddleMap.keySet()) {
                Pixie p = new Pixie(pc.puddleMap.get(currentKey));
                p.setCompVal(pixieValue);
                if (p.getRow() > pmax.getRow() || p.getCol() > pmax.getCol()) continue;
                pi.setPixieValue(p);
            }
            ++ii;
        }
        return pi;
    }

    public static int countNumPixiesInList(ArrayList<PixiePuddle> pcList) {
        int inumPixies = 0;
        int ii = 0;
        while (ii < pcList.size()) {
            inumPixies += pcList.get(ii).getNumPixies();
            ++ii;
        }
        return inumPixies;
    }

    public Pixie minValPixie(Map<String, Pixie> excludeMap) {
        String currentKey;
        Pixie pmin = new Pixie();
        Iterator<String> keys = this.puddleMap.keySet().iterator();
        boolean startPixieFound = false;
        while (keys.hasNext() && !startPixieFound) {
            currentKey = keys.next();
            if (excludeMap.containsKey(currentKey)) continue;
            pmin = new Pixie(this.puddleMap.get(currentKey));
            startPixieFound = true;
        }
        while (keys.hasNext()) {
            currentKey = keys.next();
            if (excludeMap.containsKey(currentKey)) continue;
            Pixie ptest = this.puddleMap.get(currentKey);
            if (!(pmin.getCompVal() > ptest.getCompVal())) continue;
            pmin = new Pixie(ptest);
        }
        return pmin;
    }

    public Pixie minValPixie() {
        return this.minValPixie(new HashMap<String, Pixie>());
    }

    public Pixie maxValPixie(Map<String, Pixie> excludeMap, boolean border) {
        String currentKey;
        Pixie pmax = new Pixie();
        Map<String, Pixie> lookAtMap = null;
        lookAtMap = border ? this.borderMap : this.puddleMap;
        Iterator<String> keys = lookAtMap.keySet().iterator();
        boolean startPixieFound = false;
        while (keys.hasNext() && !startPixieFound) {
            currentKey = keys.next();
            if (excludeMap.containsKey(currentKey)) continue;
            pmax = new Pixie(lookAtMap.get(currentKey));
            startPixieFound = true;
        }
        while (keys.hasNext()) {
            currentKey = keys.next();
            if (excludeMap.containsKey(currentKey)) continue;
            Pixie ptest = lookAtMap.get(currentKey);
            if (!(pmax.getCompVal() < ptest.getCompVal())) continue;
            pmax = new Pixie(ptest);
        }
        return pmax;
    }

    public Pixie maxValPixie(boolean border) {
        return this.maxValPixie(new HashMap<String, Pixie>(), border);
    }

    public int getNumPixies() {
        return this.puddleMap.size();
    }

    private double growAdjacentPixies(Map<String, Pixie> excludeMap, PixiePuddle pcParent, double dthreshold, double dmax_threshold, Map<String, Pixie> foundPixieMap) {
        foundPixieMap.clear();
        for (String currentKey : this.borderMap.keySet()) {
            Pixie pi = this.borderMap.get(currentKey);
            int im = -1;
            while (im <= 1) {
                int in = -1;
                while (in <= 1) {
                    Pixie px;
                    boolean notInExcludeMap;
                    boolean notInPuddleMap;
                    PixieCoord cx;
                    String cxKey;
                    boolean inPcParent;
                    boolean okayPixie;
                    boolean centerPixie;
                    boolean bl = centerPixie = im == 0 && in == 0;
                    if (!centerPixie && (okayPixie = (inPcParent = pcParent.puddleMap.containsKey(cxKey = (cx = new PixieCoord(pi.getRow() + im, pi.getCol() + in)).getKey())) & (notInPuddleMap = !this.puddleMap.containsKey(cxKey)) & (notInExcludeMap = !excludeMap.containsKey(cxKey))) && (px = pcParent.puddleMap.get(cxKey)).getCompVal() > dthreshold) {
                        if (dmax_threshold < 0.0) {
                            foundPixieMap.put(px.getKey(), new Pixie(px));
                        } else if (px.getCompVal() <= dmax_threshold) {
                            foundPixieMap.put(px.getKey(), new Pixie(px));
                        }
                    }
                    ++in;
                }
                ++im;
            }
        }
        double dminPixieValueFound = 1.0E33;
        for (String currentKey : foundPixieMap.keySet()) {
            Pixie foundPixie = foundPixieMap.get(currentKey);
            if (dminPixieValueFound > foundPixie.getCompVal()) {
                dminPixieValueFound = foundPixie.getCompVal();
            }
            this.addPixie(foundPixie);
        }
        return dminPixieValueFound;
    }

    private void growRing(Map<String, Pixie> excludeMap, PixiePuddle pcParent, double dthreshold, double dmax_threshold) {
        HashMap<String, Pixie> foundPixieMap = new HashMap<String, Pixie>();
        this.growAdjacentPixies(excludeMap, pcParent, dthreshold, dmax_threshold, foundPixieMap);
        int addedPixies = foundPixieMap.size();
        while (foundPixieMap.size() > 0) {
            this.growAdjacentPixies(excludeMap, pcParent, dthreshold, dmax_threshold, foundPixieMap);
            addedPixies += foundPixieMap.size();
        }
    }

    public static ArrayList<PixiePuddle> findBlendedPixiePuddles(PixieImage pi, double dthreshold) {
        ArrayList<PixiePuddle> pcList = new ArrayList<PixiePuddle>();
        PixiePuddle pcParent = new PixiePuddle(pi, dthreshold, 1.0E33);
        int pcListIndex = 0;
        Pixie pseed = pcParent.maxValPixie(false);
        HashMap<String, Pixie> excludeMap = new HashMap<String, Pixie>();
        while (pseed.getCompVal() >= dthreshold) {
            PixiePuddle pc = new PixiePuddle();
            pc.addPixie(pseed);
            pc.growRing(excludeMap, pcParent, dthreshold, 1.0E33);
            pcList.add(pcListIndex, pc);
            ++pcListIndex;
            pc.addToExcludeMap(excludeMap);
            pseed = pcParent.maxValPixie(excludeMap, false);
        }
        return pcList;
    }

    public ArrayList<PixiePuddle> deblend(double dthreshold, int iminPixelDistance, int iminNumOfPixies) {
        ArrayList<PixiePuddle> pcList = new ArrayList<PixiePuddle>();
        if (this.getNumPixies() < iminNumOfPixies) {
            pcList.add(0, this.makeCopy());
            return pcList;
        }
        pcList.add(0, new PixiePuddle());
        Pixie pseed = this.maxValPixie(false);
        pcList.get(0).addPixie(pseed);
        HashMap<String, Pixie> excludeMap = new HashMap<String, Pixie>();
        pcList.get(0).addToExcludeMap(excludeMap);
        PixiePuddle origPuddle = this.makeCopy();
        this.checkMapKeys(origPuddle.puddleMap, "origPuddle");
        this.checkMapKeys(origPuddle.borderMap, "origPuddle");
        double dthresholdAllRings = 1.0E33;
        int inumOfPixiesOld = 0;
        PixiePuddle.countNumPixiesInList(pcList);
        int inumOfPixiesNew = 1;
        PixiePuddle.countNumPixiesInList(pcList);
        while (inumOfPixiesNew - inumOfPixiesOld > 0) {
            dthresholdAllRings = 1.0E33;
            excludeMap.clear();
            int icol = 0;
            while (icol < pcList.size()) {
                HashMap<String, Pixie> foundPixieMap;
                PixiePuddle pcTest = new PixiePuddle(pcList.get(icol));
                double dminPixieValueFound = pcTest.growAdjacentPixies(excludeMap, origPuddle, dthreshold, 1.0E33, foundPixieMap = new HashMap<String, Pixie>());
                if (dthresholdAllRings > dminPixieValueFound) {
                    dthresholdAllRings = dminPixieValueFound;
                }
                ++icol;
            }
            ArrayList<PixiePuddle> pcListOldCopy = new ArrayList<PixiePuddle>();
            pcListOldCopy.clear();
            int icol2 = 0;
            while (icol2 < pcList.size()) {
                pcListOldCopy.add(icol2, new PixiePuddle(pcList.get(icol2)));
                ++icol2;
            }
            icol2 = 0;
            while (icol2 < pcList.size()) {
                excludeMap.clear();
                int jcol = 0;
                while (jcol < pcList.size()) {
                    if (icol2 != jcol) {
                        pcListOldCopy.get(jcol).addToExcludeMap(excludeMap);
                    }
                    ++jcol;
                }
                pcList.get(icol2).growRing(excludeMap, origPuddle, dthresholdAllRings, 1.0E33);
                ++icol2;
            }
            this.removeSharedPixels(pcListOldCopy, pcList);
            excludeMap.clear();
            icol2 = 0;
            while (icol2 < pcList.size()) {
                pcList.get(icol2).addToExcludeMap(excludeMap);
                ++icol2;
            }
            PixiePuddle pcCopy = new PixiePuddle(origPuddle);
            pseed = pcCopy.maxValPixie(excludeMap, false);
            while (pseed.getCompVal() > dthresholdAllRings) {
                int imin = pcList.get(0).findClosestSquareDistanceToPuddleEdge(pseed.getCoord());
                int icol3 = 0;
                while (icol3 < pcList.size()) {
                    int itest = pcList.get(icol3).findClosestSquareDistanceToPuddleEdge(pseed.getCoord());
                    if (imin > itest) {
                        imin = itest;
                    }
                    ++icol3;
                }
                if (imin > iminPixelDistance * iminPixelDistance) {
                    PixiePuddle newPc = new PixiePuddle();
                    newPc.addPixie(pseed);
                    newPc.growRing(excludeMap, origPuddle, dthresholdAllRings, 1.0E33);
                    pcList.add(newPc);
                    newPc.addToExcludeMap(excludeMap);
                } else {
                    pseed.setCompVal(0.0);
                    pcCopy.removePixie(pseed.getCoord());
                }
                pseed = pcCopy.maxValPixie(false);
            }
            inumOfPixiesOld = inumOfPixiesNew;
            inumOfPixiesNew = PixiePuddle.countNumPixiesInList(pcList);
        }
        return pcList;
    }

    private int findClosestSquareDistanceToPuddleEdge(PixieCoord ctest) {
        Iterator<String> keys = this.borderMap.keySet().iterator();
        String kBorder = "";
        PixieCoord cBorder = new PixieCoord();
        if (!keys.hasNext()) {
            return -1;
        }
        kBorder = keys.next();
        cBorder = this.borderMap.get(kBorder).getCoord();
        int imin = (ctest.getRow() - cBorder.getRow()) * (ctest.getRow() - cBorder.getRow()) + (ctest.getCol() - cBorder.getCol()) * (ctest.getCol() - cBorder.getCol());
        while (keys.hasNext()) {
            kBorder = keys.next();
            cBorder = this.borderMap.get(kBorder).getCoord();
            int itest = (ctest.getRow() - cBorder.getRow()) * (ctest.getRow() - cBorder.getRow()) + (ctest.getCol() - cBorder.getCol()) * (ctest.getCol() - cBorder.getCol());
            if (itest >= imin) continue;
            imin = itest;
        }
        return imin;
    }

    private void removeSharedPixels(ArrayList<PixiePuddle> pcListOldCopy, ArrayList<PixiePuddle> pcList) {
        if (pcList.size() != pcListOldCopy.size()) {
            return;
        }
        int icol = 0;
        while (icol < pcList.size()) {
            for (String testKey : pcList.get((int)icol).puddleMap.keySet()) {
                if (!pcList.get((int)icol).puddleMap.containsKey(testKey)) continue;
                PixieCoord ctest = pcList.get((int)icol).puddleMap.get(testKey).getCoord();
                int itestDist = pcListOldCopy.get(icol).findClosestSquareDistanceToPuddleEdge(ctest);
                int jcol = 0;
                while (jcol < pcList.size()) {
                    int icheckDist;
                    if (icol != jcol && pcList.get((int)jcol).puddleMap.containsKey(testKey) && (icheckDist = pcListOldCopy.get(jcol).findClosestSquareDistanceToPuddleEdge(ctest)) >= itestDist) {
                        pcList.get(jcol).removePixie(ctest);
                    }
                    ++jcol;
                }
            }
            ++icol;
        }
    }

    public void writetoFitsFile(PixieCoord pllhc, PixieCoord purhc, String fitsFileName) {
        PixieImage piTestImage = this.makePixieImage(pllhc, purhc, false);
        try {
            piTestImage.writeToFitsFile(fitsFileName);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
    }

    public PixieCoord getURHCoord() {
        Iterator<String> keys = this.puddleMap.keySet().iterator();
        PixieCoord cmax = new PixieCoord();
        if (keys.hasNext()) {
            String kmax = keys.next();
            cmax = new PixieCoord(this.puddleMap.get(kmax).getCoord());
        }
        while (keys.hasNext()) {
            String nextKey = keys.next();
            PixieCoord nextCoord = this.puddleMap.get(nextKey).getCoord();
            if (cmax.getRow() < nextCoord.getRow()) {
                cmax.setRow(nextCoord.getRow());
            }
            if (cmax.getCol() >= nextCoord.getCol()) continue;
            cmax.setCol(nextCoord.getCol());
        }
        return cmax;
    }

    public PixieCoord getLLHCoord() {
        Iterator<String> keys = this.puddleMap.keySet().iterator();
        PixieCoord cmin = new PixieCoord();
        if (keys.hasNext()) {
            String kmin = keys.next();
            cmin = new PixieCoord(this.puddleMap.get(kmin).getCoord());
        }
        while (keys.hasNext()) {
            String nextKey = keys.next();
            PixieCoord nextCoord = this.puddleMap.get(nextKey).getCoord();
            if (cmin.getRow() > nextCoord.getRow()) {
                cmin.setRow(nextCoord.getRow());
            }
            if (cmin.getCol() <= nextCoord.getCol()) continue;
            cmin.setCol(nextCoord.getCol());
        }
        return cmin;
    }

    public Iterator puddleMapKeyIterator() {
        Iterator<String> keys = this.puddleMap.keySet().iterator();
        return keys;
    }

    public Iterator borderMapKeyIterator() {
        Iterator<String> keys = this.borderMap.keySet().iterator();
        return keys;
    }

    public Pixie getPuddlePixie(String key) {
        Pixie p1 = this.puddleMap.get(key);
        return p1;
    }

    public Pixie getPuddlePixie(PixieCoord pc) {
        Pixie p1 = this.puddleMap.get(pc.getKey());
        return p1;
    }

    public Pixie getBorderPixie(String key) {
        Pixie p1 = this.borderMap.get(key);
        return p1;
    }

    public Pixie getBorderPixie(PixieCoord pc) {
        Pixie p1 = this.borderMap.get(pc.getKey());
        return p1;
    }

    public static ArrayList<PixiePuddle> findAndDeblendPixiePuddles(PixieImage piComposite, PixieImage piGBand, PixieImage piRBand, PixieImage piIBand, double dthreshold, int pixieResolution, int minNumPixiesInPuddle, double minPuddleDepth) {
        ArrayList<PixiePuddle> pcList = PixiePuddle.findBlendedPixiePuddles(piComposite, dthreshold);
        ArrayList<PixiePuddle> pcListDeblended = new ArrayList<PixiePuddle>();
        int ipud = 0;
        while (ipud < pcList.size()) {
            ArrayList<PixiePuddle> pcSubList = pcList.get(ipud).deblend(dthreshold, pixieResolution, minNumPixiesInPuddle);
            PixiePuddle.reBlend(pcSubList, minPuddleDepth);
            int isubpud = 0;
            while (isubpud < pcSubList.size()) {
                if (pcSubList.get(isubpud).getNumPixies() >= minNumPixiesInPuddle) {
                    pcListDeblended.add(new PixiePuddle(pcSubList.get(isubpud)));
                }
                ++isubpud;
            }
            ++ipud;
        }
        ipud = 0;
        while (ipud < pcListDeblended.size()) {
            if (piGBand != null) {
                pcListDeblended.get(ipud).addPixieColor(piGBand, 0);
            }
            if (piRBand != null) {
                pcListDeblended.get(ipud).addPixieColor(piRBand, 1);
            }
            if (piIBand != null) {
                pcListDeblended.get(ipud).addPixieColor(piIBand, 2);
            }
            ++ipud;
        }
        return pcListDeblended;
    }

    public void gaussianFilter() {
        String currentKey;
        PixiePuddle pdCopy = this.makeCopy();
        double[][] mask = new double[3][3];
        mask[0][0] = 0.0625;
        mask[0][1] = 0.125;
        mask[0][2] = 0.0625;
        mask[1][0] = 0.125;
        mask[1][1] = 0.25;
        mask[1][2] = 0.125;
        mask[2][0] = 0.0625;
        mask[2][1] = 0.125;
        mask[2][2] = 0.0625;
        Iterator keys = this.puddleMapKeyIterator();
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            Pixie p1 = this.puddleMap.get(currentKey);
            Pixie[][] padjacent = this.adjacentPixies(p1);
            double val = 0.0;
            double maskSum = 0.0;
            int ii = 0;
            while (ii <= 2) {
                int ij = 0;
                while (ij <= 2) {
                    if (padjacent[ii][ij] != null) {
                        val += padjacent[ii][ij].getCompVal() * mask[ii][ij];
                        maskSum += mask[ii][ij];
                    }
                    ++ij;
                }
                ++ii;
            }
            pdCopy.puddleMap.get(currentKey).setCompVal(val /= maskSum);
        }
        keys = this.puddleMapKeyIterator();
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            double val = pdCopy.puddleMap.get(currentKey).getCompVal();
            this.puddleMap.get(currentKey).setCompVal(val);
            if (!this.borderMap.containsKey(currentKey)) continue;
            this.borderMap.get(currentKey).setCompVal(val);
        }
    }

    public void medianFilter() {
        String currentKey;
        PixiePuddle pdCopy = this.makeCopy();
        Iterator keys = this.puddleMapKeyIterator();
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            Pixie p1 = this.puddleMap.get(currentKey);
            Pixie[][] padjacent = this.adjacentPixies(p1);
            double[] val = new double[10];
            int icount = 1;
            int ii = 0;
            while (ii <= 2) {
                int ij = 0;
                while (ij <= 2) {
                    if (padjacent[ii][ij] != null) {
                        val[icount] = padjacent[ii][ij].getCompVal();
                        ++icount;
                    }
                    ++ij;
                }
                ++ii;
            }
            double medVal = NR.select(--icount / 2 + 1, icount, val);
            pdCopy.puddleMap.get(currentKey).setCompVal(medVal);
        }
        keys = this.puddleMapKeyIterator();
        while (keys.hasNext()) {
            currentKey = (String)keys.next();
            double val = pdCopy.puddleMap.get(currentKey).getCompVal();
            this.puddleMap.get(currentKey).setCompVal(val);
            if (!this.borderMap.containsKey(currentKey)) continue;
            this.borderMap.get(currentKey).setCompVal(val);
        }
    }

    private Pixie[][] adjacentPixies(Pixie pcenter) {
        Pixie[][] padjacent = new Pixie[3][3];
        int ii = -1;
        while (ii <= 1) {
            int ij = -1;
            while (ij <= 1) {
                padjacent[ii + 1][ij + 1] = null;
                PixieCoord pcoord = new PixieCoord(pcenter.getRow() + ii, pcenter.getCol() + ij);
                Pixie ptest = this.puddleMap.get(pcoord.getKey());
                if (ptest != null) {
                    padjacent[ii + 1][ij + 1] = new Pixie(ptest);
                }
                ++ij;
            }
            ++ii;
        }
        return padjacent;
    }

    private Map<String, Pixie> findCommonBorder(PixiePuddle pd2) {
        HashMap<String, Pixie> commonBorder = new HashMap<String, Pixie>();
        Iterator keys = this.borderMapKeyIterator();
        while (keys.hasNext()) {
            Pixie pb = this.getBorderPixie((String)keys.next());
            int idistSquare = pd2.findClosestSquareDistanceToPuddleEdge(pb.getCoord());
            if (idistSquare < 0 || idistSquare > 2) continue;
            commonBorder.put(pb.getKey(), new Pixie(pb));
        }
        return commonBorder;
    }

    private boolean shouldReblend(PixiePuddle pd2, double minPuddleDepth) {
        Map<String, Pixie> commonBorder = this.findCommonBorder(pd2);
        double dborderValue = 0.0;
        double dpuddleValue = 0.0;
        if (commonBorder.size() < 1) {
            return false;
        }
        Iterator<String> keys = commonBorder.keySet().iterator();
        Pixie pborderMax = new Pixie(commonBorder.get(keys.next()));
        while (keys.hasNext()) {
            Pixie ptest = commonBorder.get(keys.next());
            if (!(ptest.getCompVal() > pborderMax.getCompVal())) continue;
            pborderMax = new Pixie(ptest);
        }
        dborderValue = pborderMax.getCompVal();
        double depth = dborderValue / (dpuddleValue = this.medianValueAdjacentPixies(this.maxValPixie(false)));
        return !(depth < minPuddleDepth);
    }

    public static void reBlend(ArrayList<PixiePuddle> pdList, double minPuddleDepth) {
        int ipuddleListSize = pdList.size();
        if (ipuddleListSize <= 1) {
            return;
        }
        int ipuddle = 0;
        while (ipuddle < ipuddleListSize) {
            int itestPuddle = 0;
            while (itestPuddle < ipuddleListSize) {
                if (itestPuddle != ipuddle && pdList.get(ipuddle).shouldReblend(pdList.get(itestPuddle), minPuddleDepth)) {
                    pdList.get(ipuddle).addPuddle(pdList.get(itestPuddle));
                    pdList.remove(itestPuddle);
                    itestPuddle = ipuddleListSize = pdList.size();
                    ipuddle = -1;
                }
                ++itestPuddle;
            }
            ++ipuddle;
        }
    }

    private double medianValueAdjacentPixies(Pixie pcenter) {
        Pixie[][] padjacent = this.adjacentPixies(pcenter);
        double[] val = new double[10];
        int icount = 1;
        int ii = 0;
        while (ii <= 2) {
            int ij = 0;
            while (ij <= 2) {
                if (padjacent[ii][ij] != null) {
                    val[icount] = padjacent[ii][ij].getCompVal();
                    ++icount;
                }
                ++ij;
            }
            ++ii;
        }
        double medVal = NR.select(--icount / 2 + 1, icount, val);
        return medVal;
    }
}

