/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.Pixie;
import com.astrofizzbizz.pixie.PixieCoord;
import com.astrofizzbizz.pixie.PixieImage;
import com.astrofizzbizz.pixie.PixieImageException;
import com.astrofizzbizz.pixie.PixieImageRGBPlotter;
import com.astrofizzbizz.utilities.FileChooserWrapper;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class PixieTestImage
extends JFrame
implements ActionListener {
    static JFrame frame = null;
    private String lastDirectoryPath = null;
    PixieImage pixieImage = null;
    Pixie psize = null;
    JTextField imageSizeTextField = null;
    PixieImageRGBPlotter plotter = null;
    ImageIcon imageIcon = null;
    JLabel imageIconLabel = null;
    JTextField thetaTextField = new JTextField(8);
    JTextField intensityTextField = new JTextField(8);
    JTextField sigmaxTextField = new JTextField(8);
    JTextField sigmayTextField = new JTextField(8);
    JTextField powerTextField = new JTextField(8);
    JTextField col_pos_fracTextField = new JTextField(8);
    JTextField row_pos_fracTextField = new JTextField(8);
    double dtheta = 0.0;
    double dintensity = 100.0;
    double dsigmax = 30.0;
    double dsigmay = 30.0;
    double dpower = 2.0;
    double dcol_pos_frac = 0.5;
    double drow_pos_frac = 0.5;

    public PixieTestImage() {
        this.psize = new Pixie(new PixieCoord(200, 200), -1.0);
    }

    private Component createComponents() {
        this.imageSizeTextField = new JTextField(5);
        this.imageSizeTextField.setText(Integer.toString(this.psize.getRow() + 1));
        JLabel imageSizeLabel = new JLabel("Image Size");
        JPanel imageSizePanel = new JPanel();
        imageSizePanel.setLayout(new GridLayout(1, 2, 5, 5));
        imageSizePanel.add(imageSizeLabel);
        imageSizePanel.add(this.imageSizeTextField);
        JPanel imageDisplayPanel = new JPanel();
        this.imageIcon = new ImageIcon();
        this.imageIconLabel = new JLabel(this.imageIcon);
        imageDisplayPanel.add(this.imageIconLabel);
        JPanel imagePanel = new JPanel();
        imagePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        imagePanel.add(imageSizePanel);
        imagePanel.add(imageDisplayPanel);
        this.thetaTextField.setText(Double.toString(this.dtheta));
        this.intensityTextField.setText(Double.toString(this.dintensity));
        this.sigmaxTextField.setText(Double.toString(this.dsigmax));
        this.sigmayTextField.setText(Double.toString(this.dsigmay));
        this.powerTextField.setText(Double.toString(this.dpower));
        this.col_pos_fracTextField.setText(Double.toString(this.dcol_pos_frac));
        this.row_pos_fracTextField.setText(Double.toString(this.drow_pos_frac));
        JLabel thetaTextLabel = new JLabel("Theta");
        JLabel intensityTextLabel = new JLabel("Intensity");
        JLabel sigmaxTextLabel = new JLabel("Sigma X");
        JLabel sigmayTextLabel = new JLabel("Sigma Y");
        JLabel powerTextLabel = new JLabel("Power");
        JLabel col_pos_fracTextLabel = new JLabel("Col. Pos. Frac.");
        JLabel row_pos_fracTextLabel = new JLabel("Row. Pos. Frac.");
        JPanel ellipseSettingsPanel = new JPanel();
        ellipseSettingsPanel.setLayout(new GridLayout(7, 2, 5, 5));
        ellipseSettingsPanel.add(thetaTextLabel);
        ellipseSettingsPanel.add(this.thetaTextField);
        ellipseSettingsPanel.add(intensityTextLabel);
        ellipseSettingsPanel.add(this.intensityTextField);
        ellipseSettingsPanel.add(sigmaxTextLabel);
        ellipseSettingsPanel.add(this.sigmaxTextField);
        ellipseSettingsPanel.add(sigmayTextLabel);
        ellipseSettingsPanel.add(this.sigmayTextField);
        ellipseSettingsPanel.add(powerTextLabel);
        ellipseSettingsPanel.add(this.powerTextField);
        ellipseSettingsPanel.add(col_pos_fracTextLabel);
        ellipseSettingsPanel.add(this.col_pos_fracTextField);
        ellipseSettingsPanel.add(row_pos_fracTextLabel);
        ellipseSettingsPanel.add(this.row_pos_fracTextField);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Images", imagePanel);
        tabbedPane.addTab("Ellipse Settings", ellipseSettingsPanel);
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 5, 5));
        mainPanel.setLayout(new GridLayout(1, 4, 5, 5));
        mainPanel.add(tabbedPane);
        return mainPanel;
    }

    private JMenuBar addMenu() {
        JMenuBar menuBar = new JMenuBar();
        String[] menuText = new String[]{"File", "Add", "Help"};
        String[][] itemText = new String[][]{{"New Image", "Save Image", "Exit"}, {"Ellipse"}, {"Help", "About"}};
        int i = 0;
        while (i < menuText.length) {
            JMenu menu = new JMenu(menuText[i]);
            menuBar.add(menu);
            int j = 0;
            while (j < itemText[i].length) {
                JMenuItem item = new JMenuItem(itemText[i][j]);
                menu.add(item);
                item.setActionCommand(String.valueOf(menuText[i]) + "." + itemText[i][j]);
                item.addActionListener(this);
                ++j;
            }
            ++i;
        }
        return menuBar;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getActionCommand().equals("File.New Image")) {
            this.onNewFile();
        }
        if (arg0.getActionCommand().equals("File.Save Image")) {
            this.onSaveFile();
        }
        if (arg0.getActionCommand().equals("Add.Ellipse")) {
            this.onAddEllipse();
        }
        if (arg0.getActionCommand().equals("File.Exit")) {
            System.exit(0);
        }
        if (arg0.getActionCommand().equals("Help.Help")) {
            JOptionPane.showMessageDialog(frame, "You've got to be kidding.");
        }
        if (arg0.getActionCommand().equals("Help.About")) {
            JOptionPane.showMessageDialog(frame, "McGinnis Philanthropies Foundation\nAll Rights Reserved");
        }
    }

    private void onNewFile() {
        int isize = Integer.valueOf(this.imageSizeTextField.getText());
        this.psize = new Pixie(new PixieCoord(isize - 1, isize - 1), 0.0);
        this.pixieImage = new PixieImage(this.psize);
        this.plotter = new PixieImageRGBPlotter();
        this.plotter.setImages(this.pixieImage, this.pixieImage, this.pixieImage);
        this.plotter.setScaleType("linear");
        this.plotter.setInvertImage(false);
        this.plotter.setAutoScale(true);
        this.plotter.setColorSpectrum(true);
        this.plotter.setPixelValueLimits(this.pixieImage);
        this.plotter.setScaleTable(null);
        this.imageIcon = new ImageIcon(this.plotter.makeBufferedImage());
        this.imageIconLabel.setIcon(this.imageIcon);
        frame.pack();
    }

    private void onAddEllipse() {
        if (this.pixieImage == null) {
            this.onNewFile();
        }
        this.dtheta = Double.valueOf(this.thetaTextField.getText());
        this.dintensity = Double.valueOf(this.intensityTextField.getText());
        this.dsigmax = Double.valueOf(this.sigmaxTextField.getText());
        this.dsigmay = Double.valueOf(this.sigmayTextField.getText());
        this.dpower = Double.valueOf(this.powerTextField.getText());
        this.dcol_pos_frac = Double.valueOf(this.col_pos_fracTextField.getText());
        this.drow_pos_frac = Double.valueOf(this.row_pos_fracTextField.getText());
        double[][] dpix = this.pixieImage.getPix();
        int ii = 0;
        while (ii <= this.psize.getRow()) {
            int ij = 0;
            while (ij <= this.psize.getCol()) {
                double dx = ((double)ij - this.dcol_pos_frac * (double)this.psize.getCol()) * Math.cos(this.dtheta) + ((double)ii - this.drow_pos_frac * (double)this.psize.getRow()) * Math.sin(this.dtheta);
                dx = Math.pow(Math.abs(dx) / this.dsigmax, this.dpower);
                double dy = -((double)ij - this.dcol_pos_frac * (double)this.psize.getCol()) * Math.sin(this.dtheta) + ((double)ii - this.drow_pos_frac * (double)this.psize.getRow()) * Math.cos(this.dtheta);
                dy = Math.pow(Math.abs(dy) / this.dsigmay, this.dpower);
                dpix[ii][ij] = dpix[ii][ij] + this.dintensity * Math.exp(-(dx + dy) / this.dpower);
                ++ij;
            }
            ++ii;
        }
        this.plotter = new PixieImageRGBPlotter();
        this.plotter.setImages(this.pixieImage, this.pixieImage, this.pixieImage);
        this.plotter.setScaleType("linear");
        this.plotter.setInvertImage(false);
        this.plotter.setAutoScale(true);
        this.plotter.setColorSpectrum(true);
        this.plotter.setPixelValueLimits(this.pixieImage);
        this.plotter.setScaleTable(null);
        this.imageIcon = new ImageIcon(this.plotter.makeBufferedImage());
        this.imageIconLabel.setIcon(this.imageIcon);
        frame.pack();
    }

    private void onSaveFile() {
        if (this.pixieImage == null) {
            return;
        }
        FileChooserWrapper fc = new FileChooserWrapper(this);
        File saveFile = fc.fSaveFile("fit", this.lastDirectoryPath);
        if (saveFile == null) {
            return;
        }
        this.lastDirectoryPath = saveFile.getPath();
        try {
            this.pixieImage.writeToFitsFile(saveFile);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame = new JFrame("Image Simulator");
        PixieTestImage app = new PixieTestImage();
        Component contents = app.createComponents();
        frame.getContentPane().add(contents, "Center");
        frame.setJMenuBar(app.addMenu());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }
}

