/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.utilities;

import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.MenuElement;
import javax.swing.filechooser.FileNameExtensionFilter;

public class DpmSwingUtilities {
    public static JMenu findMenu(JMenuBar menuBar, String menuName) {
        MenuElement[] menus = menuBar.getSubElements();
        int ii = 0;
        while (ii < menus.length) {
            JMenu menu = (JMenu)menus[ii].getComponent();
            if (menu.getText().equals(menuName)) {
                return menu;
            }
            ++ii;
        }
        return null;
    }

    public static JMenuItem findMenuItem(JMenu menu, String menuItemName) {
        if (menu.getItemCount() > 0) {
            int ii = 0;
            while (ii < menu.getItemCount()) {
                JMenuItem menuItem = menu.getItem(ii);
                if (menuItem.getText().equals(menuItemName)) {
                    return menuItem;
                }
                ++ii;
            }
        }
        return null;
    }

    public static void messageDialog(String string, JFrame parentFrame) {
        JOptionPane.showMessageDialog(parentFrame, string);
    }

    public static void messageDialog(String string, JDialog parentDialog) {
        JOptionPane.showMessageDialog(parentDialog, string);
    }

    public static int optionDialog(String title, String text, String option1, String option2, int defaultOption, JFrame parentFrame) {
        if (defaultOption < 1) {
            defaultOption = 1;
        }
        if (defaultOption > 2) {
            defaultOption = 2;
        }
        Object[] options = new Object[]{option1, option2};
        int n = JOptionPane.showOptionDialog(parentFrame, text, title, 1, 3, null, options, options[defaultOption - 1]);
        return ++n;
    }

    public static File chooseFile(String directoryPath, String dialogTitle, String selectedFileName, boolean saveDialog, String[] extensions, JFrame parentFrame) {
        File file = null;
        JFileChooser fc = null;
        fc = directoryPath != null ? new JFileChooser(directoryPath) : new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        fc.setSelectedFile(new File(selectedFileName));
        if (extensions != null) {
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileFilter(DpmSwingUtilities.makeFileNameExtensionFilter(extensions));
        }
        fc.setDialogTitle(dialogTitle);
        int returnVal = 0;
        returnVal = saveDialog ? fc.showSaveDialog(parentFrame) : fc.showOpenDialog(parentFrame);
        if (returnVal == 0) {
            file = fc.getSelectedFile();
        }
        return file;
    }

    public static FileNameExtensionFilter makeFileNameExtensionFilter(String[] extensions) {
        if (extensions == null) {
            return null;
        }
        int numExtensions = 0;
        int ii = 0;
        while (ii < extensions.length) {
            if (extensions[ii] != null) {
                ++numExtensions;
            }
            ++ii;
        }
        String[] nne = new String[numExtensions];
        int iext = 0;
        String extensionDesc = "";
        int ii2 = 0;
        while (ii2 < extensions.length) {
            if (extensions[ii2] != null) {
                nne[iext] = extensions[ii2];
                if (iext == 0) {
                    extensionDesc = String.valueOf(extensionDesc) + "*." + extensions[ii2];
                }
                if (iext > 0) {
                    extensionDesc = String.valueOf(extensionDesc) + ", *." + extensions[ii2];
                }
                ++iext;
            }
            ++ii2;
        }
        if (numExtensions == 1) {
            return new FileNameExtensionFilter(extensionDesc, nne[0]);
        }
        if (numExtensions == 2) {
            return new FileNameExtensionFilter(extensionDesc, nne[0], nne[1]);
        }
        if (numExtensions == 3) {
            return new FileNameExtensionFilter(extensionDesc, nne[0], nne[1], nne[2]);
        }
        if (numExtensions >= 4) {
            return new FileNameExtensionFilter(extensionDesc, nne[0], nne[1], nne[2], nne[3]);
        }
        return null;
    }
}

