/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.utilities;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Date;
import java.util.List;

public class FileChangeNotifier {
    public static void main(String[] args) throws IOException, InterruptedException {
        FileChangeNotifier.watchDir("C:\\EclipseWorkSpace2014\\LinacLego\\EssLinacXmlFiles");
    }

    public static void watchDir(String dir) throws IOException, InterruptedException {
        WatchKey key;
        boolean valid;
        WatchService service = FileSystems.getDefault().newWatchService();
        Path path = Paths.get(dir, new String[0]);
        path.register(service, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        Date oldDate = new Date();
        do {
            key = service.take();
            List<WatchEvent<?>> event = key.pollEvents();
            Date newDate = new Date();
            if (newDate.getTime() - oldDate.getTime() <= 1000L) continue;
            int ii = 0;
            while (ii < event.size()) {
                System.out.println(event.get(ii).kind() + ": " + event.get(ii).context());
                ++ii;
            }
            oldDate.setTime(newDate.getTime());
        } while (valid = key.reset());
    }
}

