/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import nom.tam.util.TruncationException;

public final class ByteFormatter {
    private byte[] tbuf1 = new byte[32];
    private byte[] tbuf2 = new byte[32];
    private static final double ilog10 = 1.0 / Math.log(10.0);
    private boolean truncateOnOverflow = true;
    private byte truncationFill = (byte)42;
    private boolean truncationThrow = true;
    private boolean align = false;
    double simpleMin = 0.001;
    double simpleMax = 1000000.0;
    private static final double[] tenpow;
    private static final int zeropow;
    private static final byte[] digits;

    static {
        int min = (int)Math.floor((int)(Math.log(Double.MIN_VALUE) * ilog10));
        int max = (int)Math.floor((int)(Math.log(Double.MAX_VALUE) * ilog10));
        tenpow = new double[++max - min + 1];
        int i = 0;
        while (i < tenpow.length) {
            ByteFormatter.tenpow[i] = Math.pow(10.0, i + min);
            ++i;
        }
        zeropow = -min;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }

    public void setTruncateOnOverflow(boolean val) {
        this.truncateOnOverflow = val;
    }

    public void setTruncationThrow(boolean throwException) {
        this.truncationThrow = throwException;
    }

    public void setTruncationFill(char val) {
        this.truncationFill = (byte)val;
    }

    public void setAlign(boolean val) {
        this.align = val;
    }

    public void setSimpleRange(double min, double max) {
        this.simpleMin = min;
        this.simpleMax = max;
    }

    public int format(int val, byte[] array) throws TruncationException {
        return this.format(val, array, 0, array.length);
    }

    public int format(int val, byte[] buf, int off, int len) throws TruncationException {
        if (val == Integer.MIN_VALUE) {
            if (len > 10 || !this.truncateOnOverflow && buf.length - off > 10) {
                return this.format("-2147483648", buf, off, len);
            }
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        int pos = Math.abs(val);
        int ndig = 1;
        int dmax = 10;
        while (ndig < 10 && pos >= dmax) {
            ++ndig;
            dmax *= 10;
        }
        if (val < 0) {
            ++ndig;
        }
        if (this.truncateOnOverflow && ndig > len || ndig > buf.length - off) {
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        if (this.align) {
            off = this.alignFill(buf, off, len - ndig);
        }
        int xoff = (off += ndig) - 1;
        do {
            buf[xoff] = digits[pos % 10];
            --xoff;
        } while ((pos /= 10) > 0);
        if (val < 0) {
            buf[xoff] = 45;
        }
        return off;
    }

    public int format(long val, byte[] array) throws TruncationException {
        return this.format(val, array, 0, array.length);
    }

    public int format(long val, byte[] buf, int off, int len) throws TruncationException {
        if (val == Long.MIN_VALUE) {
            if (len > 19 || !this.truncateOnOverflow && buf.length - off > 19) {
                return this.format("-9223372036854775808", buf, off, len);
            }
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        long pos = Math.abs(val);
        int ndig = 1;
        long dmax = 10L;
        while (ndig < 19 && pos >= dmax) {
            ++ndig;
            dmax *= 10L;
        }
        if (val < 0L) {
            ++ndig;
        }
        if (this.truncateOnOverflow && ndig > len || ndig > buf.length - off) {
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        if (this.align) {
            off = this.alignFill(buf, off, len - ndig);
        }
        int xoff = (off += ndig) - 1;
        buf[xoff] = 48;
        boolean last = pos == 0L;
        block1: while (!last) {
            int giga = (int)(pos % 1000000000L);
            last = (pos /= 1000000000L) == 0L;
            int i = 0;
            while (i < 9) {
                buf[xoff] = digits[giga % 10];
                --xoff;
                if (last && (giga /= 10) == 0) continue block1;
                ++i;
            }
        }
        if (val < 0L) {
            buf[xoff] = 45;
        }
        return off;
    }

    public int format(boolean val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(boolean val, byte[] array, int off, int len) {
        if (this.align && len > 1) {
            off = this.alignFill(array, off, len - 1);
        }
        if (len > 0) {
            array[off] = val ? 84 : 70;
            ++off;
        }
        return off;
    }

    public int format(String val, byte[] array) {
        return this.format(val, array, 0, array.length);
    }

    public int format(String val, byte[] array, int off, int len) {
        if (val == null) {
            int i = 0;
            while (i < len) {
                array[off + i] = 32;
                ++i;
            }
            return off + len;
        }
        int slen = val.length();
        if (this.truncateOnOverflow && slen > len || slen > array.length - off) {
            val = val.substring(0, len);
            slen = len;
        }
        if (this.align && len > slen) {
            off = this.alignFill(array, off, len - slen);
        }
        System.arraycopy(val.getBytes(), 0, array, off, slen);
        return off + slen;
    }

    public int format(float val, byte[] array) throws TruncationException {
        return this.format(val, array, 0, array.length);
    }

    public int format(float val, byte[] buf, int off, int len) throws TruncationException {
        float scale;
        float pos = Math.abs(val);
        if ((double)pos == 0.0) {
            return this.format("0.0", buf, off, len);
        }
        if (Float.isNaN(val)) {
            return this.format("NaN", buf, off, len);
        }
        if (Float.isInfinite(val)) {
            if (val > 0.0f) {
                return this.format("Infinity", buf, off, len);
            }
            return this.format("-Infinity", buf, off, len);
        }
        int power = (int)Math.floor(Math.log(pos) * ilog10);
        int shift = 8 - power;
        float scale2 = 1.0f;
        if (shift < 30) {
            scale = (float)tenpow[shift + zeropow];
        } else {
            scale2 = (float)tenpow[30 + zeropow];
            scale = (float)tenpow[shift - 30 + zeropow];
        }
        pos = pos * scale * scale2;
        int bits = Float.floatToIntBits(pos);
        int exp = ((bits & 0x7F800000) >> 23) - 127;
        int numb = bits & 0x7FFFFF;
        if (exp > -127) {
            numb |= 0x800000;
        } else {
            ++exp;
        }
        boolean oldAlign = this.align;
        this.align = false;
        int ndig = this.format(numb <<= (int)((long)exp - 23L), this.tbuf1, 0, 32);
        this.align = oldAlign;
        return this.combineReal(val, buf, off, len, this.tbuf1, ndig, shift);
    }

    public int format(double val, byte[] array) throws TruncationException {
        return this.format(val, array, 0, array.length);
    }

    public int format(double val, byte[] buf, int off, int len) throws TruncationException {
        double scale;
        double pos = Math.abs(val);
        if (pos == 0.0) {
            return this.format("0.0", buf, off, len);
        }
        if (Double.isNaN(val)) {
            return this.format("NaN", buf, off, len);
        }
        if (Double.isInfinite(val)) {
            if (val > 0.0) {
                return this.format("Infinity", buf, off, len);
            }
            return this.format("-Infinity", buf, off, len);
        }
        int power = (int)(Math.log(pos) * ilog10);
        int shift = 17 - power;
        double scale2 = 1.0;
        if (shift < 200) {
            scale = tenpow[shift + zeropow];
        } else {
            scale2 = tenpow[200 + zeropow];
            scale = tenpow[shift - 200 + zeropow];
        }
        pos = pos * scale * scale2;
        long bits = Double.doubleToLongBits(pos);
        int exp = (int)(((bits & 0x7FF0000000000000L) >> 52) - 1023L);
        long numb = bits & 0xFFFFFFFFFFFFFL;
        if (exp > -1023) {
            numb |= 0x10000000000000L;
        } else {
            ++exp;
        }
        boolean oldAlign = this.align;
        this.align = false;
        int ndig = this.format(numb <<= exp - 52, this.tbuf1, 0, 32);
        this.align = oldAlign;
        return this.combineReal(val, buf, off, len, this.tbuf1, ndig, shift);
    }

    int combineReal(double val, byte[] buf, int off, int len, byte[] mant, int lmant, int shift) throws TruncationException {
        int maxSize;
        int minSize;
        double pos = Math.abs(val);
        boolean simple = false;
        if (pos >= this.simpleMin && pos <= this.simpleMax) {
            simple = true;
        }
        int exp = lmant - shift - 1;
        int lexp = 0;
        if (!simple) {
            boolean oldAlign = this.align;
            this.align = false;
            lexp = this.format(exp, this.tbuf2, 0, 32);
            this.align = oldAlign;
            minSize = lexp + 2;
            maxSize = lexp + lmant + 2;
        } else if (exp >= 0) {
            minSize = exp + 1;
            int i = 0;
            while (i < lmant && i <= exp) {
                if (mant[i] != 57) break;
                ++i;
            }
            if (i > exp && i < lmant && mant[i] >= 53) {
                ++minSize;
            }
            if ((maxSize = lmant + 1) <= minSize) {
                maxSize = minSize + 1;
            }
        } else {
            minSize = 2;
            maxSize = 1 + Math.abs(exp) + lmant;
        }
        if (val < 0.0) {
            ++minSize;
            ++maxSize;
        }
        if (this.truncateOnOverflow && minSize > len || minSize > buf.length - off) {
            this.truncationFiller(buf, off, len);
            return off + len;
        }
        if (maxSize < len && this.align) {
            int nal = len - maxSize;
            off = this.alignFill(buf, off, nal);
            len -= nal;
        }
        int off0 = off;
        if (val < 0.0) {
            buf[off] = 45;
            ++off;
            --len;
        }
        if (simple) {
            return Math.abs(this.mantissa(mant, lmant, exp, simple, buf, off, len));
        }
        if ((off = this.mantissa(mant, lmant, 0, simple, buf, off, len - lexp - 1)) < 0) {
            off = -off;
            len -= off;
            if (exp == 9 || exp == 99) {
                if (off + len == minSize) {
                    this.truncationFiller(buf, off, len);
                    return off + len;
                }
                --off;
            }
            lexp = this.format(++exp, this.tbuf2, 0, 32);
        }
        buf[off] = 69;
        System.arraycopy(this.tbuf2, 0, buf, ++off, lexp);
        return off + lexp;
    }

    /*
     * Unable to fully structure code
     */
    int mantissa(byte[] mant, int lmant, int exp, boolean simple, byte[] buf, int off, int len) {
        block15: {
            off0 = off;
            pos = 0;
            if (exp >= 0) ** GOTO lbl23
            buf[off] = 48;
            ++off;
            if (--len > 0) {
                buf[off] = 46;
                ++off;
                --len;
            }
            cexp = exp;
            while (cexp < -1 && len > 0) {
                buf[off] = 48;
                ++cexp;
                ++off;
                --len;
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                buf[off] = mant[pos];
                ++off;
                ++pos;
                --len;
                --exp;
lbl23:
                // 2 sources

                ** while (exp >= 0 && pos < lmant)
            }
lbl24:
            // 1 sources

            i = 0;
            while (i <= exp) {
                buf[off] = 48;
                ++off;
                --len;
                ++i;
            }
            if (len > 0) {
                buf[off] = 46;
                --len;
                ++off;
            }
        }
        while (len > 0 && pos < lmant) {
            buf[off] = mant[pos];
            ++off;
            --exp;
            --len;
            ++pos;
        }
        if (pos < lmant && mant[pos] >= 53) {
            i = off - 1;
            while (i >= off0) {
                if (buf[i] != 46 && buf[i] != 45) {
                    if (buf[i] == 57) {
                        buf[i] = 48;
                    } else {
                        v0 = i;
                        buf[v0] = (byte)(buf[v0] + 1);
                        break;
                    }
                }
                --i;
            }
            if (i < off0) {
                buf[off0] = 49;
                foundDecimal = false;
                i = off0 + 1;
                while (i < off) {
                    if (buf[i] == 46) {
                        foundDecimal = true;
                        if (!simple) break;
                        buf[i] = 48;
                        if (++i >= off) break;
                        buf[i] = 46;
                        break;
                    }
                    ++i;
                }
                if (simple && !foundDecimal) {
                    buf[off + 1] = 48;
                    ++off;
                }
                off = -off;
            }
        }
        return off;
    }

    void truncationFiller(byte[] buffer, int offset, int length) throws TruncationException {
        int i = offset;
        while (i < offset + length) {
            buffer[i] = this.truncationFill;
            ++i;
        }
        if (this.truncationThrow) {
            throw new TruncationException();
        }
    }

    public int alignFill(byte[] buffer, int offset, int len) {
        int i = offset;
        while (i < offset + len) {
            buffer[i] = 32;
            ++i;
        }
        return offset + len;
    }
}

