/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.PixieImage;
import com.astrofizzbizz.pixie.PixieImageException;
import com.astrofizzbizz.pixie.PixieImageRGBPlotterNoSwing;

public class SimpleImageProcess {
    private PixieImage piRed = null;
    private PixieImage piGreen = null;
    private PixieImage piBlue = null;

    public SimpleImageProcess(String redFitsFileName, String greenFitsFileName, String blueFitsFileName) throws PixieImageException {
        this.piRed = new PixieImage(redFitsFileName);
        this.piGreen = new PixieImage(greenFitsFileName);
        this.piBlue = new PixieImage(blueFitsFileName);
    }

    public void subtractDarkImage(String darkFitsFileName) throws PixieImageException {
        PixieImage dark = new PixieImage(darkFitsFileName);
        int nrows = dark.getRowCount();
        int ncols = dark.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                this.piRed.getPix()[ir][ic] = this.piRed.getPix()[ir][ic] - dark.getPix()[ir][ic];
                this.piGreen.getPix()[ir][ic] = this.piGreen.getPix()[ir][ic] - dark.getPix()[ir][ic];
                this.piBlue.getPix()[ir][ic] = this.piBlue.getPix()[ir][ic] - dark.getPix()[ir][ic];
                ++ic;
            }
            ++ir;
        }
    }

    public void normalize(boolean subtractMean, boolean normalize) {
        if (!subtractMean && !normalize) {
            return;
        }
        double[] meanSigmaRed = this.piRed.findNoiseMeanSigma();
        double[] meanSigmaGreen = this.piGreen.findNoiseMeanSigma();
        double[] meanSigmaBlue = this.piBlue.findNoiseMeanSigma();
        if (subtractMean) {
            this.piRed.rescalePixels(1.0, -meanSigmaRed[0]);
            this.piGreen.rescalePixels(1.0, -meanSigmaGreen[0]);
            this.piBlue.rescalePixels(1.0, -meanSigmaBlue[0]);
        }
        if (normalize) {
            this.piGreen.rescalePixels(meanSigmaRed[1] / meanSigmaGreen[1], 0.0);
            this.piBlue.rescalePixels(meanSigmaRed[1] / meanSigmaBlue[1], 0.0);
        }
        double maxRed = this.piRed.findMinMaxSumMean()[1];
        double maxGreen = this.piGreen.findMinMaxSumMean()[1];
        double maxBlue = this.piBlue.findMinMaxSumMean()[1];
        double top = maxRed;
        if (top > maxGreen) {
            top = maxGreen;
        }
        if (top > maxBlue) {
            top = maxBlue;
        }
        int nrows = this.piRed.getRowCount();
        int ncols = this.piRed.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                if (this.piRed.getPix()[ir][ic] < 0.0) {
                    this.piRed.getPix()[ir][ic] = 0.0;
                }
                if (this.piGreen.getPix()[ir][ic] < 0.0) {
                    this.piGreen.getPix()[ir][ic] = 0.0;
                }
                if (this.piBlue.getPix()[ir][ic] < 0.0) {
                    this.piBlue.getPix()[ir][ic] = 0.0;
                }
                if (this.piRed.getPix()[ir][ic] > top) {
                    this.piRed.getPix()[ir][ic] = top;
                }
                if (this.piGreen.getPix()[ir][ic] > top) {
                    this.piGreen.getPix()[ir][ic] = top;
                }
                if (this.piBlue.getPix()[ir][ic] > top) {
                    this.piBlue.getPix()[ir][ic] = top;
                }
                ++ic;
            }
            ++ir;
        }
    }

    public void gainAdjust(String imageName, double gain) {
        if (gain == 1.0) {
            return;
        }
        PixieImage refImage = null;
        if (imageName.equals("red")) {
            refImage = this.piRed;
        }
        if (imageName.equals("green")) {
            refImage = this.piGreen;
        }
        if (imageName.equals("blue")) {
            refImage = this.piBlue;
        }
        double max = refImage.findMinMaxSumMean()[1];
        int nrows = refImage.getRowCount();
        int ncols = refImage.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                refImage.getPix()[ir][ic] = refImage.getPix()[ir][ic] * gain;
                if (refImage.getPix()[ir][ic] < 0.0) {
                    refImage.getPix()[ir][ic] = 0.0;
                }
                if (refImage.getPix()[ir][ic] > max) {
                    refImage.getPix()[ir][ic] = max;
                }
                ++ic;
            }
            ++ir;
        }
    }

    public void writeOutFitsFiles(String redFitsFileName, String greenFitsFileName, String blueFitsFileName) throws PixieImageException {
        this.piRed.writeToFitsFile(redFitsFileName);
        this.piGreen.writeToFitsFile(greenFitsFileName);
        this.piBlue.writeToFitsFile(blueFitsFileName);
    }

    public void fitsToPng(String pngFileName, int scaleType, boolean plotRed, boolean plotGreen, boolean plotBlue) {
        PixieImage piBlank;
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        plotter.setAutoScale(true);
        PixieImage piRedPlot = piBlank = new PixieImage(this.piRed.getRowCount(), this.piRed.getColCount());
        PixieImage piGreenPlot = piBlank;
        PixieImage piBluePlot = piBlank;
        if (plotRed) {
            piRedPlot = this.piRed;
        }
        if (plotGreen) {
            piGreenPlot = this.piGreen;
        }
        if (plotBlue) {
            piBluePlot = this.piBlue;
        }
        plotter.setImages(piRedPlot, piGreenPlot, piBluePlot);
        double maxRed = piRedPlot.findMinMaxSumMean()[1];
        double maxGreen = piGreenPlot.findMinMaxSumMean()[1];
        double maxBlue = piBluePlot.findMinMaxSumMean()[1];
        double top = maxRed;
        if (top < maxGreen) {
            top = maxGreen;
        }
        if (top < maxBlue) {
            top = maxBlue;
        }
        plotter.setPixelValueLimits(0.0, top);
        if (plotRed) {
            plotter.setScaleTable(piRedPlot);
        } else if (plotGreen) {
            plotter.setScaleTable(piGreenPlot);
        } else {
            plotter.setScaleTable(piBluePlot);
        }
        plotter.toPNGFile(pngFileName);
    }

    public void shiftImage(String imageName, int ix, int iy) {
        PixieImage refImage = null;
        if (imageName.equals("red")) {
            refImage = this.piRed;
        }
        if (imageName.equals("green")) {
            refImage = this.piGreen;
        }
        if (imageName.equals("blue")) {
            refImage = this.piBlue;
        }
        int nrows = refImage.getRowCount();
        int ncols = refImage.getColCount();
        PixieImage shiftImage = new PixieImage(nrows, ncols);
        int ir = 0;
        while (ir < nrows) {
            int ir2 = ir - iy;
            if (ir2 >= 0 && ir2 < nrows) {
                int ic = 0;
                while (ic < ncols) {
                    int ic2 = ic - ix;
                    if (ic2 >= 0 && ic2 < ncols) {
                        shiftImage.getPix()[ir][ic] = refImage.getPix()[ir2][ic2];
                    }
                    ++ic;
                }
            }
            ++ir;
        }
        if (imageName.equals("red")) {
            this.piRed = shiftImage;
        }
        if (imageName.equals("green")) {
            this.piGreen = shiftImage;
        }
        if (imageName.equals("blue")) {
            this.piBlue = shiftImage;
        }
    }

    public static double starSize(String fitsFileName) {
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        plotter.setScaleType("log");
        plotter.setAutoScale(true);
        PixieImage pi = null;
        try {
            pi = new PixieImage(fitsFileName);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
        double[] noiseMeanSigma = pi.findNoiseMeanSigma();
        pi.rescalePixels(1.0, -noiseMeanSigma[0]);
        int nrows = pi.getRowCount();
        int ncols = pi.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                if (pi.getPix()[ir][ic] < 0.5 * noiseMeanSigma[0]) {
                    pi.getPix()[ir][ic] = 0.0;
                }
                ++ic;
            }
            ++ir;
        }
        int irowMax = 0;
        int icolMax = 0;
        double max = -1.0;
        double[] neighbor = new double[4];
        int ir2 = 20;
        while (ir2 < nrows - 20) {
            int ic = 20;
            while (ic < ncols - 20) {
                if (max < pi.getPix()[ir2][ic]) {
                    double center = pi.getPix()[ir2][ic];
                    neighbor[0] = pi.getPix()[ir2 - 1][ic];
                    neighbor[1] = pi.getPix()[ir2 + 1][ic];
                    neighbor[2] = pi.getPix()[ir2][ic - 1];
                    neighbor[3] = pi.getPix()[ir2][ic + 1];
                    if (neighbor[0] > 0.5 * center && neighbor[1] > 0.5 * center && neighbor[2] > 0.5 * center && neighbor[3] > 0.5 * center) {
                        max = pi.getPix()[ir2][ic];
                        irowMax = ir2;
                        icolMax = ic;
                    }
                }
                ++ic;
            }
            ++ir2;
        }
        if (max < 0.0) {
            return -1.0;
        }
        double meanX = 0.0;
        double meanY = 0.0;
        double sum = 0.0;
        int ir3 = irowMax - 19;
        while (ir3 < irowMax + 19) {
            int ic = icolMax - 19;
            while (ic < icolMax + 19) {
                if (pi.getPix()[ir3][ic] < max) {
                    meanX += pi.getPix()[ir3][ic] * (double)ic;
                    meanY += pi.getPix()[ir3][ic] * (double)ir3;
                    sum += pi.getPix()[ir3][ic];
                }
                ++ic;
            }
            ++ir3;
        }
        meanX /= sum;
        meanY /= sum;
        double sigmaX = 0.0;
        double sigmaY = 0.0;
        int ir4 = irowMax - 19;
        while (ir4 < irowMax + 19) {
            int ic = icolMax - 19;
            while (ic < icolMax + 19) {
                if (pi.getPix()[ir4][ic] < max) {
                    sigmaX += pi.getPix()[ir4][ic] * ((double)ic - meanX) * ((double)ic - meanX);
                    sigmaY += pi.getPix()[ir4][ic] * ((double)ir4 - meanY) * ((double)ir4 - meanY);
                }
                ++ic;
            }
            ++ir4;
        }
        double sigma = Math.sqrt((sigmaX /= sum) + (sigmaY /= sum));
        return sigma;
    }

    public static void fitsToPng(String fitsFileName, String pngFileName, int scaleType) {
        PixieImage pi = null;
        try {
            pi = new PixieImage(fitsFileName);
        }
        catch (PixieImageException e) {
            e.printStackTrace();
        }
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        plotter.setAutoScale(true);
        plotter.setImages(pi);
        plotter.setPixelValueLimits(pi);
        plotter.setScaleTable(pi);
        plotter.toPNGFile(pngFileName);
    }

    public static void main(String[] args) throws PixieImageException {
        double sigma = SimpleImageProcess.starSize("C:\\temp\\darkM13-20100811-60s-seo.fits");
        System.out.println("Sigma = " + sigma);
    }
}

