/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;

public class FitsUtil {
    private static boolean wroteCheckingError = false;

    public static void reposition(Object o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + "   Exception:" + e);
        }
    }

    public static long findOffset(Object o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static int padding(int size) {
        return FitsUtil.padding((long)size);
    }

    public static int padding(long size) {
        int mod = (int)(size % 2880L);
        if (mod > 0) {
            mod = 2880 - mod;
        }
        return mod;
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    public static long addPadding(long size) {
        return size + (long)FitsUtil.padding(size);
    }

    /*
     * Loose catch block
     */
    public static boolean isCompressed(File test) {
        InputStream fis;
        block18: {
            block19: {
                block20: {
                    fis = null;
                    if (!test.exists()) break block18;
                    fis = new FileInputStream(test);
                    int mag1 = fis.read();
                    int mag2 = fis.read();
                    fis.close();
                    if (mag1 != 31 || mag2 != 139 && mag2 != 157) break block19;
                    if (fis == null) break block20;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return true;
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
            catch (IOException e) {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
                catch (Throwable throwable) {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isCompressed(String filename) {
        if (filename == null) {
            return false;
        }
        Object fis = null;
        File test = new File(filename);
        if (test.exists()) {
            return FitsUtil.isCompressed(test);
        }
        int len = filename.length();
        return len > 2 && (filename.substring(len - 3).equalsIgnoreCase(".gz") || filename.substring(len - 2).equals(".Z"));
    }

    public static int maxLength(String[] o) throws FitsException {
        int max = 0;
        int i = 0;
        while (i < o.length) {
            if (o[i] != null && o[i].length() > max) {
                max = o[i].length();
            }
            ++i;
        }
        return max;
    }

    public static byte[] stringsToByteArray(String[] o, int maxLen) {
        byte[] res = new byte[o.length * maxLen];
        int i = 0;
        while (i < o.length) {
            byte[] bstr = o[i] == null ? new byte[]{} : o[i].getBytes(FitsFactory.ASCII);
            int cnt = bstr.length;
            if (cnt > maxLen) {
                cnt = maxLen;
            }
            System.arraycopy(bstr, 0, res, i * maxLen, cnt);
            int j = cnt;
            while (j < maxLen) {
                res[i * maxLen + j] = 32;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static String[] byteArrayToStrings(byte[] o, int maxLen) {
        boolean checking = FitsFactory.getCheckAsciiStrings();
        String[] res = new String[o.length / maxLen];
        int i = 0;
        while (i < res.length) {
            int start = i * maxLen;
            int end = start + maxLen;
            while (start < end) {
                if (o[start] != 32) break;
                ++start;
            }
            while (end > start) {
                if (o[end - 1] != 32) break;
                --end;
            }
            boolean errFound = false;
            int j = start;
            while (j < end) {
                if (o[j] == 0) {
                    end = j;
                    break;
                }
                if (checking && (o[j] < 32 || o[j] > 126)) {
                    errFound = true;
                    o[j] = 32;
                }
                ++j;
            }
            res[i] = new String(o, start, end - start, FitsFactory.ASCII);
            if (errFound && !wroteCheckingError) {
                System.err.println("Warning: Invalid ASCII character[s] detected in string:" + res[i]);
                System.err.println("   Converted to space[s].  Any subsequent invalid characters will be converted silently");
                wroteCheckingError = true;
            }
            ++i;
        }
        return res;
    }

    static byte[] booleanToByte(boolean[] bool) {
        byte[] byt = new byte[bool.length];
        int i = 0;
        while (i < bool.length) {
            byt[i] = bool[i] ? 84 : 70;
            ++i;
        }
        return byt;
    }

    static boolean[] byteToBoolean(byte[] byt) {
        boolean[] bool = new boolean[byt.length];
        int i = 0;
        while (i < byt.length) {
            bool[i] = byt[i] == 84;
            ++i;
        }
        return bool;
    }

    public static InputStream getURLStream(URL url, int level) throws IOException {
        if (level > 5) {
            throw new IOException("Two many levels of redirection in URL");
        }
        URLConnection conn = url.openConnection();
        Map<String, List<String>> hdrs = conn.getHeaderFields();
        String[] keys = hdrs.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            String val;
            String key = keys[i];
            if (key != null && key.toLowerCase().equals("location") && (val = hdrs.get(key).get(0)) != null && (val = val.trim()).length() > 0) {
                return FitsUtil.getURLStream(new URL(val), level + 1);
            }
            ++i;
        }
        return conn.getInputStream();
    }

    public static void pad(ArrayDataOutput stream, long size) throws FitsException {
        FitsUtil.pad(stream, size, (byte)0);
    }

    public static void pad(ArrayDataOutput stream, long size, byte fill) throws FitsException {
        int len = FitsUtil.padding(size);
        if (len > 0) {
            byte[] buf = new byte[len];
            int i = 0;
            while (i < len) {
                buf[i] = fill;
                ++i;
            }
            try {
                stream.write(buf);
                stream.flush();
            }
            catch (Exception e) {
                throw new FitsException("Unable to write padding", e);
            }
        }
    }
}

