/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.Pixie;
import com.astrofizzbizz.pixie.PixieCoord;
import com.astrofizzbizz.pixie.PixieImageException;
import com.astrofizzbizz.pixie.PixieImageRGBPlotter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.ImageHDU;
import nom.tam.image.ImageTiler;
import nom.tam.util.BufferedFile;
import nom.tam.util.Cursor;

public class PixieImage {
    private double[][] pix = null;
    private Header header = new Header();

    PixieImage() {
    }

    public PixieImage(PixieImage pi) {
        this();
        int nrow = 0;
        int ncol = 0;
        nrow = pi.getRowCount();
        ncol = pi.getColCount();
        if (nrow > 0 && ncol > 0) {
            this.pix = new double[nrow][ncol];
            int ii = 0;
            while (ii < nrow) {
                int ij = 0;
                while (ij < ncol) {
                    this.pix[ii][ij] = pi.pix[ii][ij];
                    ++ij;
                }
                ++ii;
            }
        }
        this.copyHeaderCards(pi.header);
    }

    public int getBitPix() {
        return this.header.getIntValue("BITPIX");
    }

    public PixieImage(int nrow, int ncol) {
        this();
        if (nrow > 0 && ncol > 0) {
            this.pix = new double[nrow][ncol];
            int ii = 0;
            while (ii < nrow) {
                int ij = 0;
                while (ij < ncol) {
                    this.pix[ii][ij] = 0.0;
                    ++ij;
                }
                ++ii;
            }
        }
    }

    public PixieImage(Pixie pmax) {
        this(pmax.getRow() + 1, pmax.getCol() + 1);
    }

    public PixieImage(PixieCoord pmax) {
        this(pmax.getRow() + 1, pmax.getCol() + 1);
    }

    public PixieImage(String fitsFileName) throws PixieImageException {
        this();
        try {
            int ij;
            int ii;
            int ncol;
            int nrow;
            Fits fits = new Fits(fitsFileName);
            ImageHDU hdu = (ImageHDU)fits.readHDU();
            Header hdr = hdu.getHeader();
            int ibitpix = hdr.getIntValue("BITPIX");
            Object kernal = hdu.getData().getKernel();
            int naxis = hdr.getIntValue("NAXIS");
            if (naxis < 2) {
                fits = null;
                hdu = null;
                hdr = null;
                throw new FitsException();
            }
            if (hdr.getIntValue("BITPIX") == -16) {
                throw new PixieImageException();
            }
            if (ibitpix == 8) {
                char[][] cimage = (char[][])kernal;
                nrow = cimage.length;
                ncol = cimage[0].length;
                this.pix = new double[nrow][ncol];
                ii = 0;
                while (ii < nrow) {
                    ij = 0;
                    while (ij < ncol) {
                        this.pix[ii][ij] = (double)cimage[ii][ij] + 128.0;
                        ++ij;
                    }
                    ++ii;
                }
                cimage = null;
            }
            if (ibitpix == 16) {
                short[][] simage = (short[][])kernal;
                nrow = simage.length;
                ncol = simage[0].length;
                this.pix = new double[nrow][ncol];
                ii = 0;
                while (ii < nrow) {
                    ij = 0;
                    while (ij < ncol) {
                        this.pix[ii][ij] = (double)simage[ii][ij] + 32768.0;
                        ++ij;
                    }
                    ++ii;
                }
                simage = null;
            }
            if (ibitpix == 32) {
                int[][] iimage = (int[][])kernal;
                nrow = iimage.length;
                ncol = iimage[0].length;
                this.pix = new double[nrow][ncol];
                ii = 0;
                while (ii < nrow) {
                    ij = 0;
                    while (ij < ncol) {
                        this.pix[ii][ij] = (double)iimage[ii][ij] + 32768.0;
                        ++ij;
                    }
                    ++ii;
                }
                iimage = null;
            }
            if (ibitpix == -32) {
                float[][] fimage = null;
                if (naxis == 2) {
                    fimage = (float[][])kernal;
                }
                if (naxis == 4) {
                    float[][][][] kernal4D = (float[][][][])kernal;
                    fimage = kernal4D[0][0];
                }
                int nrow2 = fimage.length;
                ncol = fimage[0].length;
                this.pix = new double[nrow2][ncol];
                ii = 0;
                while (ii < nrow2) {
                    ij = 0;
                    while (ij < ncol) {
                        this.pix[ii][ij] = fimage[ii][ij];
                        ++ij;
                    }
                    ++ii;
                }
                fimage = null;
            }
            this.copyHeaderCards(hdu.getHeader());
            fits = null;
            hdu = null;
            hdr = null;
        }
        catch (FitsException e) {
            e.printStackTrace();
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    public PixieImage(File fitsFile) throws PixieImageException {
        this(fitsFile.getPath());
    }

    public PixieImage(String fitsFileName, int centerRow, int centerCol, int nrows, int ncols) throws PixieImageException {
        this();
        try {
            int ij;
            int ii;
            Fits fits = new Fits(fitsFileName);
            ImageHDU hdu = (ImageHDU)fits.readHDU();
            Header hdr = hdu.getHeader();
            int maxRows = hdr.getIntValue("NAXIS2");
            int maxCols = hdr.getIntValue("NAXIS1");
            boolean goodParam = true;
            if (centerRow > maxRows - 1) {
                goodParam = false;
            }
            if (centerCol > maxCols - 1) {
                goodParam = false;
            }
            if (centerRow < 1) {
                goodParam = false;
            }
            if (centerCol < 1) {
                goodParam = false;
            }
            if (hdr.getIntValue("NAXIS") != 2) {
                goodParam = false;
            }
            int ibitpix = hdr.getIntValue("BITPIX");
            if (hdr.getIntValue("BITPIX") != -32 && hdr.getIntValue("BITPIX") != 16) {
                goodParam = false;
            }
            if (!goodParam) {
                fits = null;
                hdu = null;
                hdr = null;
                throw new FitsException();
            }
            if (centerRow + nrows / 2 >= maxRows) {
                nrows = 2 * (maxRows - centerRow) - 1;
            }
            if (centerCol + ncols / 2 >= maxCols) {
                ncols = 2 * (maxCols - centerCol);
            }
            int startRow = centerRow - nrows / 2;
            int startCol = centerCol - ncols / 2;
            ImageTiler imageTiler = hdu.getTiler();
            this.pix = new double[nrows][ncols];
            if (ibitpix == 8) {
                char[] ctile = new char[nrows * ncols];
                imageTiler.getTile(ctile, new int[]{startRow, startCol}, new int[]{nrows, ncols});
                ii = 0;
                while (ii < ncols) {
                    ij = 0;
                    while (ij < nrows) {
                        this.pix[ij][ii] = (double)ctile[ii + ij * ncols] + 128.0;
                        ++ij;
                    }
                    ++ii;
                }
                ctile = null;
            }
            if (ibitpix == 16) {
                short[] stile = new short[nrows * ncols];
                imageTiler.getTile(stile, new int[]{startRow, startCol}, new int[]{nrows, ncols});
                ii = 0;
                while (ii < ncols) {
                    ij = 0;
                    while (ij < nrows) {
                        this.pix[ij][ii] = (double)stile[ii + ij * ncols] + 32768.0;
                        ++ij;
                    }
                    ++ii;
                }
                stile = null;
            }
            if (ibitpix == 32) {
                int[] itile = new int[nrows * ncols];
                imageTiler.getTile(itile, new int[]{startRow, startCol}, new int[]{nrows, ncols});
                ii = 0;
                while (ii < ncols) {
                    ij = 0;
                    while (ij < nrows) {
                        this.pix[ij][ii] = itile[ii + ij * ncols];
                        ++ij;
                    }
                    ++ii;
                }
                itile = null;
            }
            if (ibitpix == -32) {
                float[] ftile = new float[nrows * ncols];
                imageTiler.getTile(ftile, new int[]{startRow, startCol}, new int[]{nrows, ncols});
                ii = 0;
                while (ii < ncols) {
                    ij = 0;
                    while (ij < nrows) {
                        this.pix[ij][ii] = ftile[ii + ij * ncols];
                        ++ij;
                    }
                    ++ii;
                }
                ftile = null;
            }
            if (ibitpix == -64) {
                double[] dtile = new double[nrows * ncols];
                imageTiler.getTile(dtile, new int[]{startRow, startCol}, new int[]{nrows, ncols});
                ii = 0;
                while (ii < ncols) {
                    ij = 0;
                    while (ij < nrows) {
                        this.pix[ij][ii] = dtile[ii + ij * ncols];
                        ++ij;
                    }
                    ++ii;
                }
                dtile = null;
            }
            this.copyHeaderCards(hdu.getHeader());
            try {
                int[] rowCol = new int[]{startRow + nrows / 2, startCol + ncols / 2};
                double[] raDec = this.rowColToRaDec(rowCol[0], rowCol[1]);
                this.header.addValue("CRVAL1", raDec[0], "RA at Reference Pixel");
                this.header.addValue("CRVAL2", raDec[1], "DEC at Reference Pixel");
                this.header.addValue("CRPIX1", (double)(ncols / 2), "Column Pixel Coordinate of Ref. Pixel");
                this.header.addValue("CRPIX2", (double)(nrows / 2), "Row Pixel Coordinate of Ref. Pixel");
            }
            catch (HeaderCardException e) {
                System.out.println("Problem changing Fits Header in PixieImage");
            }
            fits = null;
            hdu = null;
            hdr = null;
            imageTiler = null;
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    public PixieImage(File fitsFile, int centerRow, int centerCol, int nrows, int ncols) throws PixieImageException {
        this(fitsFile.getPath(), centerRow, centerCol, nrows, ncols);
    }

    public void addCommentToHeaderEnd(String comment) {
        Cursor it = this.header.iterator();
        while (it.hasNext()) {
            it.next();
        }
        try {
            this.header.insertComment(comment);
        }
        catch (HeaderCardException e) {
            System.out.println("Problem changing Fits Header in PixieImage");
        }
    }

    public int getRowCount() {
        int nrow = 0;
        if (this.pix != null) {
            nrow = this.pix.length;
        }
        return nrow;
    }

    public static int getRowCount(String fitsFileName) throws PixieImageException {
        try {
            Fits fits = new Fits(fitsFileName);
            ImageHDU hdu = (ImageHDU)fits.readHDU();
            Header hdr = hdu.getHeader();
            int maxRows = hdr.getIntValue("NAXIS2");
            fits = null;
            hdu = null;
            hdr = null;
            return maxRows;
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    public static int getRowCount(File fitsFile) throws PixieImageException {
        return PixieImage.getRowCount(fitsFile.getPath());
    }

    public static int getColCount(String fitsFileName) throws PixieImageException {
        try {
            Fits fits = new Fits(fitsFileName);
            ImageHDU hdu = (ImageHDU)fits.readHDU();
            Header hdr = hdu.getHeader();
            int maxCols = hdr.getIntValue("NAXIS1");
            fits = null;
            hdu = null;
            hdr = null;
            return maxCols;
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    public int[] rADecToRowCol(double ra, double dec) {
        int[] rowCol = PixieImage.rADecToRowCol(this.header, ra, dec);
        return rowCol;
    }

    public static int[] rADecToRowCol(String fitsFileName, double ra, double dec) throws PixieImageException {
        try {
            Fits fits = new Fits(fitsFileName);
            ImageHDU hdu = (ImageHDU)fits.readHDU();
            Header hdr = hdu.getHeader();
            int[] rowCol = PixieImage.rADecToRowCol(hdr, ra, dec);
            fits = null;
            hdu = null;
            hdr = null;
            return rowCol;
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    private static int[] rADecToRowCol(Header hdr, double ra, double dec) {
        double[][] CD = new double[2][2];
        double[][] CD_INV = new double[2][2];
        double[] CRPIX = new double[2];
        double[] CRVAL = new double[2];
        double[] colRow = new double[2];
        double[] raDec = new double[2];
        int[] rowCol = new int[2];
        PixieImage.getRaDecMatrix(hdr, CD, CD_INV, CRPIX, CRVAL);
        raDec[0] = (ra - CRVAL[0]) * Math.cos(3.141592654 * dec / 180.0);
        raDec[1] = dec - CRVAL[1];
        int ii = 0;
        while (ii < 2) {
            colRow[ii] = CRPIX[ii];
            int ij = 0;
            while (ij < 2) {
                colRow[ii] = colRow[ii] + CD_INV[ii][ij] * raDec[ij];
                ++ij;
            }
            ++ii;
        }
        rowCol[0] = (int)colRow[1];
        rowCol[1] = (int)colRow[0];
        return rowCol;
    }

    public double[] rowColToRaDec(int row, int col) {
        double[] raDec = PixieImage.rowColToRaDec(this.header, row, col);
        return raDec;
    }

    public static double[] rowColToRaDec(String fitsFileName, int row, int col) throws PixieImageException {
        try {
            Fits fits = new Fits(fitsFileName);
            ImageHDU hdu = (ImageHDU)fits.readHDU();
            Header hdr = hdu.getHeader();
            double[] raDec = PixieImage.rowColToRaDec(hdr, row, col);
            fits = null;
            hdu = null;
            hdr = null;
            return raDec;
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    public static double[] rowColToRaDec(Header hdr, int row, int col) {
        double[][] CD = new double[2][2];
        double[][] CD_INV = new double[2][2];
        double[] CRPIX = new double[2];
        double[] CRVAL = new double[2];
        double[] colRow = new double[2];
        double[] raDec = new double[2];
        PixieImage.getRaDecMatrix(hdr, CD, CD_INV, CRPIX, CRVAL);
        colRow[0] = col;
        colRow[1] = row;
        int ii = 0;
        while (ii < 2) {
            raDec[ii] = 0.0;
            int ij = 0;
            while (ij < 2) {
                raDec[ii] = raDec[ii] + CD[ii][ij] * (colRow[ij] - CRPIX[ij]);
                ++ij;
            }
            ++ii;
        }
        raDec[1] = CRVAL[1] + raDec[1];
        raDec[0] = CRVAL[0] + raDec[0] / Math.cos(3.141592654 * raDec[1] / 180.0);
        return raDec;
    }

    private static void getRaDecMatrix(Header hdr, double[][] CD, double[][] CD_INV, double[] CRPIX, double[] CRVAL) {
        CD[0][0] = hdr.getDoubleValue("CD1_1");
        CD[0][1] = hdr.getDoubleValue("CD1_2");
        CD[1][0] = hdr.getDoubleValue("CD2_1");
        CD[1][1] = hdr.getDoubleValue("CD2_2");
        CRPIX[0] = hdr.getDoubleValue("CRPIX1");
        CRPIX[1] = hdr.getDoubleValue("CRPIX2");
        CRVAL[0] = hdr.getDoubleValue("CRVAL1");
        CRVAL[1] = hdr.getDoubleValue("CRVAL2");
        CD_INV[0][0] = CD[1][1] / (CD[0][0] * CD[1][1] - CD[1][0] * CD[0][1]);
        CD_INV[1][1] = CD[0][0] / (CD[0][0] * CD[1][1] - CD[1][0] * CD[0][1]);
        CD_INV[1][0] = -CD[1][0] / (CD[0][0] * CD[1][1] - CD[1][0] * CD[0][1]);
        CD_INV[0][1] = -CD[0][1] / (CD[0][0] * CD[1][1] - CD[1][0] * CD[0][1]);
    }

    public static int getColCount(File fitsFile) throws PixieImageException {
        return PixieImage.getColCount(fitsFile.getPath());
    }

    public int getColCount() {
        int ncol = 0;
        if (this.pix != null) {
            ncol = this.pix[0].length;
        }
        return ncol;
    }

    public boolean iValidCoord(Pixie pi) {
        Pixie pmax = this.getURHCPixie();
        boolean iok = false;
        if (pi.getRow() >= 0 && pi.getRow() <= pmax.getRow() && pi.getCol() >= 0 && pi.getCol() <= pmax.getCol()) {
            iok = true;
        }
        return iok;
    }

    public Pixie getURHCPixie() {
        Pixie pmax = new Pixie();
        pmax.setRow(this.getRowCount() - 1);
        pmax.setCol(this.getColCount() - 1);
        pmax.setCompVal(this.pix[pmax.getRow()][pmax.getCol()]);
        return pmax;
    }

    public Pixie getMaxValPixie() {
        double max = this.pix[0][0];
        int imax = 0;
        int jmax = 0;
        int ii = 0;
        while (ii < this.getRowCount()) {
            int ij = 0;
            while (ij < this.getColCount()) {
                if (max < this.pix[ii][ij]) {
                    imax = ii;
                    jmax = ij;
                    max = this.pix[ii][ij];
                }
                ++ij;
            }
            ++ii;
        }
        Pixie pmaxVal = new Pixie(new PixieCoord(imax, jmax), max);
        return pmaxVal;
    }

    public double[][] getPix() {
        return this.pix;
    }

    public double getPixieValue(Pixie p) {
        double val = -1.0;
        if (p.getRow() >= 0 && p.getRow() <= this.getRowCount() && p.getCol() >= 0 && p.getCol() <= this.getColCount()) {
            val = this.pix[p.getRow()][p.getCol()];
        }
        return val;
    }

    public void setPixieValue(Pixie p) {
        if (p.getRow() >= 0 && p.getRow() <= this.getRowCount() && p.getCol() >= 0 && p.getCol() <= this.getColCount()) {
            this.pix[p.getRow()][p.getCol()] = p.getCompVal();
        }
    }

    public void copyHeaderCards(Header headerIn) {
        Cursor it = headerIn.iterator();
        while (it.hasNext()) {
            HeaderCard headerCard = (HeaderCard)it.next();
            this.header.addLine(headerCard);
        }
    }

    private void appendHeaderCards(Header headerOut, Header headerIn) {
        Cursor it = headerIn.iterator();
        boolean okayCardToAdd = true;
        while (it.hasNext()) {
            HeaderCard headerCard = (HeaderCard)it.next();
            okayCardToAdd = true;
            if (headerCard.getKey().equals("SIMPLE")) {
                okayCardToAdd = false;
            }
            if (headerCard.getKey().equals("BITPIX")) {
                okayCardToAdd = false;
            }
            if (headerCard.getKey().equals("NAXIS")) {
                okayCardToAdd = false;
            }
            if (headerCard.getKey().equals("NAXIS1")) {
                okayCardToAdd = false;
            }
            if (headerCard.getKey().equals("NAXIS2")) {
                okayCardToAdd = false;
            }
            if (headerCard.getKey().equals("EXTEND")) {
                okayCardToAdd = false;
            }
            if (!okayCardToAdd) continue;
            headerOut.addLine(headerCard);
        }
    }

    public void addHeadercard(String key, double value, String comment) throws PixieImageException {
        try {
            this.header.addLine(new HeaderCard(key, value, comment));
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
    }

    public void writeToFitsFile(String fitsFileName) throws PixieImageException {
        try {
            double pixVal;
            if (this.pix == null) {
                throw new FitsException();
            }
            int ibitpix = this.header.getIntValue("BITPIX");
            if (ibitpix == -16) {
                throw new PixieImageException();
            }
            if (ibitpix > 0) {
                ibitpix = 32;
            }
            int nrow = this.pix.length;
            int ncol = this.pix[0].length;
            Fits fits = new Fits();
            int[][] iimage = null;
            BasicHDU hdu = null;
            if (ibitpix == 32) {
                iimage = new int[nrow][ncol];
                int ii = 0;
                while (ii < nrow) {
                    int ij = 0;
                    while (ij < ncol) {
                        pixVal = this.pix[ii][ij] - 32768.0;
                        if (pixVal < -2.147483648E9) {
                            pixVal = -2.147483648E9;
                        }
                        if (pixVal > 2.147483647E9) {
                            pixVal = 2.147483647E9;
                        }
                        iimage[ii][ij] = (int)pixVal;
                        ++ij;
                    }
                    ++ii;
                }
                hdu = (ImageHDU)Fits.makeHDU(iimage);
            }
            if (ibitpix == -32) {
                int ij;
                int ii;
                int naxis = this.header.getIntValue("NAXIS");
                if (naxis == 2) {
                    float[][] fimage = null;
                    fimage = new float[nrow][ncol];
                    ii = 0;
                    while (ii < nrow) {
                        ij = 0;
                        while (ij < ncol) {
                            pixVal = this.pix[ii][ij];
                            fimage[ii][ij] = (float)pixVal;
                            ++ij;
                        }
                        ++ii;
                    }
                    hdu = (ImageHDU)Fits.makeHDU(fimage);
                }
                if (naxis == 4) {
                    float[][][][] fimage = null;
                    fimage = new float[1][1][nrow][ncol];
                    ii = 0;
                    while (ii < nrow) {
                        ij = 0;
                        while (ij < ncol) {
                            pixVal = this.pix[ii][ij];
                            fimage[0][0][ii][ij] = (float)pixVal;
                            ++ij;
                        }
                        ++ii;
                    }
                    hdu = (ImageHDU)Fits.makeHDU(fimage);
                }
            }
            Header hdr = hdu.getHeader();
            this.appendHeaderCards(hdr, this.header);
            fits.addHDU(hdu);
            BufferedFile bf = new BufferedFile(fitsFileName, "rw");
            fits.write(bf);
            bf.flush();
            bf.close();
            bf = null;
            fits = null;
            iimage = null;
            hdu = null;
        }
        catch (FitsException e) {
            throw new PixieImageException(e);
        }
        catch (IOException e) {
            throw new PixieImageException(e);
        }
    }

    public void writeToFitsFile(File fitsFile) throws PixieImageException {
        this.writeToFitsFile(fitsFile.getPath());
    }

    public double[] findMinMaxSumMean() {
        double[][] pix = null;
        double imageMean = 0.0;
        int edge = 0;
        int nrows = this.getRowCount();
        int ncols = this.getColCount();
        pix = this.getPix();
        int totpix = nrows * ncols;
        double imageSum = 0.0;
        double imageMin = 1.0E33;
        double imageMax = -1.0E33;
        int ii = edge;
        while (ii < nrows - edge) {
            int ij = edge;
            while (ij < ncols - edge) {
                if (pix[ii][ij] > 0.1) {
                    imageSum += pix[ii][ij];
                    if (pix[ii][ij] < imageMin) {
                        imageMin = pix[ii][ij];
                    }
                    if (pix[ii][ij] > imageMax) {
                        imageMax = pix[ii][ij];
                    }
                } else {
                    pix[ii][ij] = 0.0;
                }
                ++ij;
            }
            ++ii;
        }
        if (totpix > 0) {
            imageMean = imageSum / (double)totpix;
        }
        double[] minMaxSumMean = new double[]{imageMin, imageMax, imageSum, imageMean};
        return minMaxSumMean;
    }

    public double[] findNoiseMeanSigma() {
        int edge = 25;
        int nrows = this.getRowCount();
        int ncols = this.getColCount();
        double[][] pix = this.getPix();
        double[] minMaxSumMean = this.findMinMaxSumMean();
        double imageMin = minMaxSumMean[0];
        double imageMax = minMaxSumMean[1];
        double imageMean = minMaxSumMean[3];
        if (imageMean - imageMin > 100.0) {
            imageMin = imageMean - 100.0;
        }
        if (imageMin < 1.0) {
            imageMin = 1.0;
        }
        double sigmaOld = 1.0;
        double imageNoiseSigma = 2000.0;
        double imageNoiseMean = 0.0;
        int itry = 0;
        while (itry < 20 && Math.abs(sigmaOld - imageNoiseSigma) > 0.02 * sigmaOld) {
            int ij;
            sigmaOld = imageNoiseSigma;
            imageNoiseMean = 0.0;
            double count = 0.0;
            int ii = edge;
            while (ii < nrows - edge) {
                ij = edge;
                while (ij < ncols - edge) {
                    if (imageMin <= pix[ii][ij] && pix[ii][ij] <= imageMax) {
                        imageNoiseMean += pix[ii][ij];
                        count += 1.0;
                    }
                    ++ij;
                }
                ++ii;
            }
            imageNoiseMean /= count;
            imageNoiseSigma = 0.0;
            ii = edge;
            while (ii < nrows - edge) {
                ij = edge;
                while (ij < ncols - edge) {
                    if (imageMin <= pix[ii][ij] && pix[ii][ij] <= imageMax) {
                        imageNoiseSigma += (pix[ii][ij] - imageNoiseMean) * (pix[ii][ij] - imageNoiseMean);
                    }
                    ++ij;
                }
                ++ii;
            }
            imageMin = imageNoiseMean - 3.0 * (imageNoiseSigma = Math.sqrt(imageNoiseSigma / count));
            if (imageMin < 1.0) {
                imageMin = 1.0;
            }
            imageMax = imageNoiseMean + 3.0 * imageNoiseSigma;
            ++itry;
        }
        double[] noiseMeanSigma = new double[]{imageNoiseMean, imageNoiseSigma};
        return noiseMeanSigma;
    }

    public void rescalePixels(double scale, double offset) {
        int nrows = this.getRowCount();
        int ncols = this.getColCount();
        double[][] pix = this.getPix();
        int ii = 0;
        while (ii < nrows) {
            int ij = 0;
            while (ij < ncols) {
                pix[ii][ij] = scale * (pix[ii][ij] + offset);
                ++ij;
            }
            ++ii;
        }
    }

    public static int findColorCharIndexInFileName(String fileName, char colorChar) {
        int colorCharIndex = 0;
        int ii = 0;
        while (ii < fileName.length()) {
            if (fileName.charAt(ii) == colorChar) {
                colorCharIndex = ii;
            }
            ++ii;
        }
        return colorCharIndex;
    }

    public static int findColorCharIndexInFileName(String fileName1, String fileName2) {
        int colorCharIndex = 0;
        int difCount = 0;
        int ii = 0;
        while (ii < fileName1.length()) {
            char ctest2;
            char ctest1 = fileName1.charAt(ii);
            if (ctest1 != (ctest2 = fileName2.charAt(ii))) {
                ++difCount;
                colorCharIndex = ii;
            }
            ++ii;
        }
        if (difCount > 1) {
            colorCharIndex = 0;
        }
        return colorCharIndex;
    }

    public static String writeColorCharIntoFileName(String inputFileName, String colorChar, int colorCharIndex) {
        String outputFileName = null;
        String[] fileNamePart = new String[3];
        int fileNameLength = inputFileName.length();
        fileNamePart[0] = inputFileName.substring(0, colorCharIndex);
        fileNamePart[1] = colorChar;
        fileNamePart[2] = inputFileName.substring(colorCharIndex + 1, fileNameLength);
        outputFileName = String.valueOf(fileNamePart[0]) + fileNamePart[1] + fileNamePart[2];
        return outputFileName;
    }

    public Header getHeader() {
        return this.header;
    }

    public static void unGzipFile(String inputFileName, String outputFileName) throws FileNotFoundException, IOException {
        int len;
        GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream(inputFileName));
        FileOutputStream out = new FileOutputStream(outputFileName);
        byte[] buf = new byte[1024];
        while ((len = gzipInputStream.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        gzipInputStream.close();
        ((OutputStream)out).close();
    }

    public static void gzipFile(String inFilename, String gzipFileName) throws FileNotFoundException, IOException {
        int len;
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(gzipFileName));
        FileInputStream in = new FileInputStream(inFilename);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.finish();
        out.close();
    }

    public static String getFileExtension(File file) {
        return PixieImage.getFileExtension(file.getName());
    }

    public static String getFileExtension(String fileName) {
        int ilen = fileName.length();
        int ii = ilen - 1;
        int iperiod = -1;
        boolean periodFound = false;
        while (ii >= 0 && !periodFound) {
            if (fileName.charAt(ii) == '.') {
                iperiod = ii;
                periodFound = true;
                continue;
            }
            --ii;
        }
        if (iperiod < 0) {
            return null;
        }
        String extension = fileName.substring(iperiod + 1, ilen);
        return extension;
    }

    public static void fitsToPng(String fitsFileName, String pngFileName, int scaleType) throws PixieImageException {
        PixieImage pi = new PixieImage(fitsFileName);
        PixieImageRGBPlotter plotter = new PixieImageRGBPlotter();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        plotter.setAutoScale(true);
        plotter.setImages(pi);
        plotter.setPixelValueLimits(pi);
        plotter.setScaleTable(pi);
        plotter.toPNGFile(pngFileName);
    }

    public static void main(String[] args) throws PixieImageException {
        String command;
        int iarg = 0;
        if ((command = args[iarg++]).equals("fitsToPng")) {
            String inputFile = args[iarg++];
            String outputFile = args[iarg++];
            int itype = Integer.parseInt(args[iarg++]);
            PixieImage.fitsToPng(inputFile, outputFile, itype);
        }
    }
}

