/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.PixieImage;
import com.astrofizzbizz.pixie.PixieImageException;
import com.astrofizzbizz.pixie.PixieImageRGBPlotterNoSwing;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

public class SingleSimpleImageProcess {
    private PixieImage pixieImage = null;
    private double[] brightStarLocation = new double[]{-1.0, -1.0};
    private double brightStarSize = -1.0;
    private double maxPixelValue = -1.0;

    public SingleSimpleImageProcess(String fitsFileName) throws PixieImageException {
        this.pixieImage = new PixieImage(fitsFileName);
    }

    public SingleSimpleImageProcess(SingleSimpleImageProcess ssip) throws PixieImageException {
        this.pixieImage = new PixieImage(ssip.getPixieImage());
    }

    public PixieImage[] createRGBPixieImage() {
        PixieImage[] pi = new PixieImage[]{this.getPixieImage(), this.getPixieImage(), this.getPixieImage()};
        return pi;
    }

    public void subtractImage(String subtractFitsFileName) throws PixieImageException {
        PixieImage subtractImage = new PixieImage(subtractFitsFileName);
        int nrows = subtractImage.getRowCount();
        int ncols = subtractImage.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                this.pixieImage.getPix()[ir][ic] = this.pixieImage.getPix()[ir][ic] - subtractImage.getPix()[ir][ic];
                if (this.pixieImage.getPix()[ir][ic] < 0.0) {
                    this.pixieImage.getPix()[ir][ic] = 0.0;
                }
                ++ic;
            }
            ++ir;
        }
    }

    public void addImage(String addFitsFileName) throws PixieImageException {
        PixieImage addImage = new PixieImage(addFitsFileName);
        int nrows = addImage.getRowCount();
        int ncols = addImage.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                this.pixieImage.getPix()[ir][ic] = this.pixieImage.getPix()[ir][ic] > 0.1 && addImage.getPix()[ir][ic] > 0.1 ? this.pixieImage.getPix()[ir][ic] + addImage.getPix()[ir][ic] : 0.0;
                ++ic;
            }
            ++ir;
        }
    }

    public void divideImage(String divideFitsFileName) throws PixieImageException {
        PixieImage divideImage = new PixieImage(divideFitsFileName);
        int nrows = divideImage.getRowCount();
        int ncols = divideImage.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                this.pixieImage.getPix()[ir][ic] = this.pixieImage.getPix()[ir][ic] / (divideImage.getPix()[ir][ic] + 1.0E-33);
                ++ic;
            }
            ++ir;
        }
    }

    public PixieImage getPixieImage() {
        return this.pixieImage;
    }

    public void subtractMean() {
        double[] meanSigma = this.pixieImage.findNoiseMeanSigma();
        this.pixieImage.rescalePixels(1.0, -meanSigma[0]);
    }

    public void normalize(String refFitsFileName) throws PixieImageException {
        PixieImage refImage = new PixieImage(refFitsFileName);
        double[] meanSigma = this.pixieImage.findNoiseMeanSigma();
        double[] meanSigmaRef = refImage.findNoiseMeanSigma();
        this.pixieImage.rescalePixels(1.0, -meanSigma[0]);
        this.pixieImage.rescalePixels(meanSigmaRef[1] / meanSigma[1], 0.0);
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                if (this.pixieImage.getPix()[ir][ic] < 0.0) {
                    this.pixieImage.getPix()[ir][ic] = 0.0;
                }
                ++ic;
            }
            ++ir;
        }
    }

    public void gainAdjust(double gain) throws PixieImageException {
        if (gain == 1.0) {
            return;
        }
        double max = this.pixieImage.findMinMaxSumMean()[1];
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                this.pixieImage.getPix()[ir][ic] = this.pixieImage.getPix()[ir][ic] * gain;
                if (this.pixieImage.getPix()[ir][ic] < 0.0) {
                    this.pixieImage.getPix()[ir][ic] = 0.0;
                }
                if (this.pixieImage.getPix()[ir][ic] > max) {
                    this.pixieImage.getPix()[ir][ic] = max;
                }
                ++ic;
            }
            ++ir;
        }
    }

    public void writeOutFitsFile(String fitsFileName) throws PixieImageException {
        this.pixieImage.writeToFitsFile(fitsFileName);
    }

    public void fitsToPng(String pngFileName, int scaleType) {
        double max;
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        plotter.setAutoScale(true);
        plotter.setImages(this.pixieImage, this.pixieImage, this.pixieImage);
        double top = max = this.pixieImage.findMinMaxSumMean()[1];
        plotter.setPixelValueLimits(0.0, top);
        plotter.setScaleTable(this.pixieImage);
        plotter.toPNGFile(pngFileName);
    }

    public BufferedImage fitsToBufferedImage(int scaleType) {
        double max;
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        plotter.setAutoScale(true);
        plotter.setImages(this.pixieImage, this.pixieImage, this.pixieImage);
        double top = max = this.pixieImage.findMinMaxSumMean()[1];
        plotter.setPixelValueLimits(0.0, top);
        plotter.setScaleTable(this.pixieImage);
        return plotter.makeBufferedImage();
    }

    public void shiftImage(int ix, int iy) {
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        PixieImage shiftImage = new PixieImage(nrows, ncols);
        shiftImage.copyHeaderCards(this.pixieImage.getHeader());
        int ir = 0;
        while (ir < nrows) {
            int ir2 = ir - iy;
            if (ir2 >= 0 && ir2 < nrows) {
                int ic = 0;
                while (ic < ncols) {
                    int ic2 = ic - ix;
                    if (ic2 >= 0 && ic2 < ncols) {
                        shiftImage.getPix()[ir][ic] = this.pixieImage.getPix()[ir2][ic2];
                    }
                    ++ic;
                }
            }
            ++ir;
        }
        this.pixieImage = shiftImage;
    }

    private void calcMaxPixelValue() {
        PixieImage pixieImageTemp = new PixieImage(this.pixieImage);
        int nrows = pixieImageTemp.getRowCount();
        int ncols = pixieImageTemp.getColCount();
        double[] noiseMeanSigma = pixieImageTemp.findNoiseMeanSigma();
        pixieImageTemp.rescalePixels(1.0, -noiseMeanSigma[0]);
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                if (pixieImageTemp.getPix()[ir][ic] < 0.5 * noiseMeanSigma[0]) {
                    pixieImageTemp.getPix()[ir][ic] = 0.0;
                }
                ++ic;
            }
            ++ir;
        }
        int irowMax = 0;
        int icolMax = 0;
        double max = -1.0;
        double[] neighbor = new double[4];
        int ir2 = 20;
        while (ir2 < nrows - 20) {
            int ic = 20;
            while (ic < ncols - 20) {
                if (max < pixieImageTemp.getPix()[ir2][ic]) {
                    double center = pixieImageTemp.getPix()[ir2][ic];
                    neighbor[0] = pixieImageTemp.getPix()[ir2 - 1][ic];
                    neighbor[1] = pixieImageTemp.getPix()[ir2 + 1][ic];
                    neighbor[2] = pixieImageTemp.getPix()[ir2][ic - 1];
                    neighbor[3] = pixieImageTemp.getPix()[ir2][ic + 1];
                    if (neighbor[0] > 0.3 * center && neighbor[1] > 0.3 * center && neighbor[2] > 0.3 * center && neighbor[3] > 0.3 * center) {
                        max = pixieImageTemp.getPix()[ir2][ic];
                        irowMax = ir2;
                        icolMax = ic;
                    }
                }
                ++ic;
            }
            ++ir2;
        }
        this.maxPixelValue = 0.0;
        if (max > 0.0) {
            this.maxPixelValue = this.pixieImage.getPix()[irowMax][icolMax];
        }
    }

    public double getExposureLevel() {
        if (this.maxPixelValue < 0.0) {
            this.calcMaxPixelValue();
        }
        return 100.0 * this.maxPixelValue / 65535.0;
    }

    public void removeHotSpots() {
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        double nearNeighborValue = 0.0;
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                nearNeighborValue = this.nearestNeighborMaxValue(ir, ic);
                if (this.pixieImage.getPix()[ir][ic] > 10.0 * nearNeighborValue) {
                    this.pixieImage.getPix()[ir][ic] = nearNeighborValue;
                }
                ++ic;
            }
            ++ir;
        }
    }

    private double nearestNeighborMaxValue(int irow, int icol) {
        double maxValue = -1.0E33;
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        int ir = irow - 1;
        while (ir <= irow + 1) {
            if (ir >= 0 && ir < nrows) {
                int ic = icol - 1;
                while (ic <= icol + 1) {
                    if (ic >= 0 && ic < ncols && (ir != irow || ic != icol) && this.pixieImage.getPix()[ir][ic] > maxValue) {
                        maxValue = this.pixieImage.getPix()[ir][ic];
                    }
                    ++ic;
                }
            }
            ++ir;
        }
        return maxValue;
    }

    public void calcBrightStarSize() {
        double sigma;
        PixieImage pixieImageTemp = new PixieImage(this.pixieImage);
        double[] noiseMeanSigma = pixieImageTemp.findNoiseMeanSigma();
        pixieImageTemp.rescalePixels(1.0, -noiseMeanSigma[0]);
        int nrows = pixieImageTemp.getRowCount();
        int ncols = pixieImageTemp.getColCount();
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                if (pixieImageTemp.getPix()[ir][ic] < 0.5 * noiseMeanSigma[0]) {
                    pixieImageTemp.getPix()[ir][ic] = 0.0;
                }
                ++ic;
            }
            ++ir;
        }
        int irowMax = 0;
        int icolMax = 0;
        double max = -1.0;
        double[] neighbor = new double[4];
        int ir2 = 20;
        while (ir2 < nrows - 20) {
            int ic = 20;
            while (ic < ncols - 20) {
                if (max < pixieImageTemp.getPix()[ir2][ic]) {
                    double center = pixieImageTemp.getPix()[ir2][ic];
                    neighbor[0] = pixieImageTemp.getPix()[ir2 - 1][ic];
                    neighbor[1] = pixieImageTemp.getPix()[ir2 + 1][ic];
                    neighbor[2] = pixieImageTemp.getPix()[ir2][ic - 1];
                    neighbor[3] = pixieImageTemp.getPix()[ir2][ic + 1];
                    if (neighbor[0] > 0.3 * center && neighbor[1] > 0.3 * center && neighbor[2] > 0.3 * center && neighbor[3] > 0.3 * center) {
                        max = pixieImageTemp.getPix()[ir2][ic];
                        irowMax = ir2;
                        icolMax = ic;
                    }
                }
                ++ic;
            }
            ++ir2;
        }
        if (max < 0.0) {
            this.maxPixelValue = 0.0;
            this.brightStarSize = -1.0;
            this.brightStarLocation[0] = -1.0;
            this.brightStarLocation[1] = -1.0;
            return;
        }
        this.maxPixelValue = this.pixieImage.getPix()[irowMax][icolMax];
        double meanX = 0.0;
        double meanY = 0.0;
        double sum = 0.0;
        int ir3 = irowMax - 19;
        while (ir3 < irowMax + 19) {
            int ic = icolMax - 19;
            while (ic < icolMax + 19) {
                if (pixieImageTemp.getPix()[ir3][ic] < max) {
                    meanX += pixieImageTemp.getPix()[ir3][ic] * (double)ic;
                    meanY += pixieImageTemp.getPix()[ir3][ic] * (double)ir3;
                    sum += pixieImageTemp.getPix()[ir3][ic];
                }
                ++ic;
            }
            ++ir3;
        }
        this.brightStarLocation[0] = meanX /= sum;
        this.brightStarLocation[1] = meanY /= sum;
        double sigmaX = 0.0;
        double sigmaY = 0.0;
        int ir4 = irowMax - 19;
        while (ir4 < irowMax + 19) {
            int ic = icolMax - 19;
            while (ic < icolMax + 19) {
                if (pixieImageTemp.getPix()[ir4][ic] < max) {
                    sigmaX += pixieImageTemp.getPix()[ir4][ic] * ((double)ic - meanX) * ((double)ic - meanX);
                    sigmaY += pixieImageTemp.getPix()[ir4][ic] * ((double)ir4 - meanY) * ((double)ir4 - meanY);
                }
                ++ic;
            }
            ++ir4;
        }
        this.brightStarSize = sigma = Math.sqrt((sigmaX /= sum) + (sigmaY /= sum));
    }

    public double getBrightStarSize() {
        return this.brightStarSize;
    }

    public boolean[][][] exposureLevelCut() {
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        boolean[][][] exposureLevelCut = new boolean[3][nrows][ncols];
        int ip = 0;
        while (ip < 3) {
            int ir = 0;
            while (ir < nrows) {
                int ic = 0;
                while (ic < ncols) {
                    exposureLevelCut[ip][ir][ic] = false;
                    ++ic;
                }
                ++ir;
            }
            ++ip;
        }
        if (this.maxPixelValue > 0.0) {
            int ir = 0;
            while (ir < nrows) {
                int ic = 0;
                while (ic < ncols) {
                    if (this.pixieImage.getPix()[ir][ic] > 0.9 * this.maxPixelValue) {
                        exposureLevelCut[0][ir][ic] = true;
                    } else if (this.pixieImage.getPix()[ir][ic] > 0.5 * this.maxPixelValue) {
                        exposureLevelCut[1][ir][ic] = true;
                    } else {
                        exposureLevelCut[0][ir][ic] = true;
                        exposureLevelCut[1][ir][ic] = true;
                        exposureLevelCut[2][ir][ic] = true;
                    }
                    ++ic;
                }
                ++ir;
            }
        }
        return exposureLevelCut;
    }

    public void fitsToPngWithBrightStarLocation(String pngFileName, int scaleType, boolean plotBrightStar, boolean[][][] exposureLevelCut) {
        double max;
        double[] minMaxSumMean = this.pixieImage.findMinMaxSumMean();
        double top = max = minMaxSumMean[1];
        PixieImage[] colorPi = new PixieImage[]{new PixieImage(this.pixieImage), new PixieImage(this.pixieImage), new PixieImage(this.pixieImage)};
        int nrows = this.pixieImage.getRowCount();
        int ncols = this.pixieImage.getColCount();
        if (exposureLevelCut != null) {
            int ip = 0;
            while (ip < 3) {
                int ir = 0;
                while (ir < nrows) {
                    int ic = 0;
                    while (ic < ncols) {
                        if (!exposureLevelCut[ip][ir][ic]) {
                            colorPi[ip].getPix()[ir][ic] = 0.0;
                        }
                        ++ic;
                    }
                    ++ir;
                }
                ++ip;
            }
        }
        double markerMult = 2.0;
        if (this.brightStarSize > 0.0) {
            int itop = (int)Math.round(this.brightStarLocation[1] + markerMult * this.brightStarSize);
            int ibot = (int)Math.round(this.brightStarLocation[1] - markerMult * this.brightStarSize);
            int ilef = (int)Math.round(this.brightStarLocation[0] + markerMult * this.brightStarSize);
            int irig = (int)Math.round(this.brightStarLocation[0] - markerMult * this.brightStarSize);
            if (itop >= nrows) {
                itop = nrows - 1;
            }
            if (ibot < 0) {
                ibot = 0;
            }
            if (ilef >= ncols) {
                ilef = ncols - 1;
            }
            if (irig < 0) {
                irig = 0;
            }
            int irowCenter = (int)Math.round(this.brightStarLocation[1]);
            int icolCenter = (int)Math.round(this.brightStarLocation[0]);
            int ir = irowCenter - 15;
            while (ir < irowCenter + 15) {
                colorPi[1].getPix()[ir][ilef] = top;
                colorPi[1].getPix()[ir][irig] = top;
                ++ir;
            }
            int ic = icolCenter - 15;
            while (ic < icolCenter + 15) {
                colorPi[1].getPix()[itop][ic] = top;
                colorPi[1].getPix()[ibot][ic] = top;
                ++ic;
            }
        }
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        plotter.setAutoScale(true);
        plotter.setImages(colorPi[0], colorPi[1], colorPi[2]);
        plotter.setPixelValueLimits(0.0, top);
        plotter.setScaleTable(this.pixieImage);
        plotter.toPNGFile(pngFileName);
    }

    public static void threeColorPng(String redFitsFileName, String greenFitsFileName, String blueFitsFileName, String pngFileName, int scaleType, double minPerc, double maxPerc) throws PixieImageException {
        PixieImage redPixieImage = null;
        PixieImage greenPixieImage = null;
        PixieImage bluePixieImage = null;
        try {
            redPixieImage = new PixieImage(redFitsFileName);
        }
        catch (PixieImageException pixieImageException) {
            // empty catch block
        }
        try {
            greenPixieImage = new PixieImage(greenFitsFileName);
        }
        catch (PixieImageException pixieImageException) {
            // empty catch block
        }
        try {
            bluePixieImage = new PixieImage(blueFitsFileName);
        }
        catch (PixieImageException pixieImageException) {
            // empty catch block
        }
        SingleSimpleImageProcess.threeColorPng(redPixieImage, greenPixieImage, bluePixieImage, pngFileName, scaleType, minPerc, maxPerc);
    }

    public static void threeColorPng(PixieImage redPixieImage, PixieImage greenPixieImage, PixieImage bluePixieImage, String pngFileName, int scaleType, double minPerc, double maxPerc) throws PixieImageException {
        PixieImageRGBPlotterNoSwing plotter = SingleSimpleImageProcess.threeColor(redPixieImage, greenPixieImage, bluePixieImage, scaleType, minPerc, maxPerc);
        plotter.toPNGFile(pngFileName);
    }

    public static PixieImageRGBPlotterNoSwing threeColorOld(PixieImage redPixieImage, PixieImage greenPixieImage, PixieImage bluePixieImage, int scaleType) throws PixieImageException {
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        plotter.setAutoScale(true);
        int nrows = 0;
        int ncols = 0;
        if (redPixieImage != null) {
            nrows = redPixieImage.getRowCount();
            ncols = redPixieImage.getColCount();
        } else if (greenPixieImage != null) {
            nrows = greenPixieImage.getRowCount();
            ncols = greenPixieImage.getColCount();
        } else if (bluePixieImage != null) {
            nrows = bluePixieImage.getRowCount();
            ncols = bluePixieImage.getColCount();
        } else {
            throw new PixieImageException();
        }
        if (redPixieImage == null) {
            redPixieImage = new PixieImage(nrows, ncols);
        }
        if (greenPixieImage == null) {
            greenPixieImage = new PixieImage(nrows, ncols);
        }
        if (bluePixieImage == null) {
            bluePixieImage = new PixieImage(nrows, ncols);
        }
        double[] redMinMaxSumMean = redPixieImage.findMinMaxSumMean();
        double[] greenMinMaxSumMean = greenPixieImage.findMinMaxSumMean();
        double[] blueMinMaxSumMean = bluePixieImage.findMinMaxSumMean();
        double maxRed = redPixieImage.findMinMaxSumMean()[1];
        double maxGreen = greenPixieImage.findMinMaxSumMean()[1];
        double maxBlue = bluePixieImage.findMinMaxSumMean()[1];
        double top = redMinMaxSumMean[1];
        if (redMinMaxSumMean[1] > 0.1) {
            top = redMinMaxSumMean[1];
        }
        if (greenMinMaxSumMean[1] > 0.1 && top > greenMinMaxSumMean[1]) {
            top = greenMinMaxSumMean[1];
        }
        if (blueMinMaxSumMean[1] > 0.1 && top > blueMinMaxSumMean[1]) {
            top = blueMinMaxSumMean[1];
        }
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                if (redPixieImage.getPix()[ir][ic] < 0.0) {
                    redPixieImage.getPix()[ir][ic] = 0.0;
                }
                if (greenPixieImage.getPix()[ir][ic] < 0.0) {
                    greenPixieImage.getPix()[ir][ic] = 0.0;
                }
                if (bluePixieImage.getPix()[ir][ic] < 0.0) {
                    bluePixieImage.getPix()[ir][ic] = 0.0;
                }
                if (redPixieImage.getPix()[ir][ic] > top) {
                    redPixieImage.getPix()[ir][ic] = top;
                }
                if (greenPixieImage.getPix()[ir][ic] > top) {
                    greenPixieImage.getPix()[ir][ic] = top;
                }
                if (bluePixieImage.getPix()[ir][ic] > top) {
                    bluePixieImage.getPix()[ir][ic] = top;
                }
                ++ic;
            }
            ++ir;
        }
        plotter.setImages(redPixieImage, greenPixieImage, bluePixieImage);
        plotter.setPixelValueLimits(0.0, top);
        if (maxRed > 0.1 && maxRed <= maxGreen && maxRed <= maxBlue) {
            plotter.setScaleTable(redPixieImage);
        }
        if (maxGreen > 0.1 && maxGreen <= maxRed && maxGreen <= maxBlue) {
            plotter.setScaleTable(greenPixieImage);
        }
        if (maxGreen > 0.1 && maxBlue <= maxRed && maxBlue <= maxGreen) {
            plotter.setScaleTable(bluePixieImage);
        }
        return plotter;
    }

    public static PixieImageRGBPlotterNoSwing threeColor(PixieImage redPixieImage, PixieImage greenPixieImage, PixieImage bluePixieImage, int scaleType, double minPerc, double maxPerc) throws PixieImageException {
        PixieImage[] pi3 = new PixieImage[3];
        PixieImage[] pi3new = new PixieImage[3];
        pi3[0] = redPixieImage;
        pi3[1] = greenPixieImage;
        pi3[2] = bluePixieImage;
        PixieImageRGBPlotterNoSwing plotter = new PixieImageRGBPlotterNoSwing();
        if (scaleType == 0) {
            plotter.setScaleType("linear");
        }
        if (scaleType == 1) {
            plotter.setScaleType("log");
        }
        if (scaleType == 2) {
            plotter.setScaleType("hist");
        }
        if (scaleType == 3) {
            plotter.setScaleType("sqrt");
        }
        if (scaleType == 4) {
            plotter.setScaleType("asinh");
        }
        plotter.setAutoScale(true);
        int nrows = -1;
        int ncols = -1;
        double dnumImages = 0.0;
        int ii = 0;
        while (ii < 3) {
            if (pi3[ii] != null) {
                nrows = pi3[ii].getRowCount();
                ncols = pi3[ii].getColCount();
                dnumImages += 1.0;
            }
            ++ii;
        }
        if (nrows < 0) {
            throw new PixieImageException();
        }
        PixieImage piAvg = new PixieImage(nrows, ncols);
        int ir = 0;
        while (ir < nrows) {
            int ic = 0;
            while (ic < ncols) {
                int ii2 = 0;
                while (ii2 < 3) {
                    if (pi3[ii2] != null) {
                        piAvg.getPix()[ir][ic] = piAvg.getPix()[ir][ic] + pi3[ii2].getPix()[ir][ic];
                    }
                    ++ii2;
                }
                piAvg.getPix()[ir][ic] = piAvg.getPix()[ir][ic] / dnumImages;
                ++ic;
            }
            ++ir;
        }
        double[] minMaxSumMean = piAvg.findMinMaxSumMean();
        double bot = minMaxSumMean[1] * minPerc / 100.0;
        double top = minMaxSumMean[1] * maxPerc / 100.0;
        int ii3 = 0;
        while (ii3 < 3) {
            if (pi3[ii3] != null) {
                pi3new[ii3] = new PixieImage(pi3[ii3]);
            } else {
                pi3new[ii3] = new PixieImage(nrows, ncols);
                int ir2 = 0;
                while (ir2 < nrows) {
                    int ic = 0;
                    while (ic < ncols) {
                        pi3new[ii3].getPix()[ir2][ic] = bot;
                        ++ic;
                    }
                    ++ir2;
                }
            }
            ++ii3;
        }
        plotter.setImages(pi3new[0], pi3new[1], pi3new[2]);
        plotter.setPixelValueLimits(bot, top);
        plotter.setScaleTable(piAvg);
        return plotter;
    }

    public static PixieImage[] makeZoomedPixieImage(PixieImage[] pixieImageDisplay, double zoom, int iRowCenter, int iColCenter) {
        if (zoom < 1.0) {
            zoom = 1.0;
        }
        int nrows = pixieImageDisplay[0].getRowCount();
        int ncols = pixieImageDisplay[0].getColCount();
        int nrowsZoom = (int)((double)nrows / zoom);
        int ncolsZoom = (int)((double)ncols / zoom);
        int irowStart = iRowCenter - nrowsZoom / 2;
        int irowStop = irowStart + nrowsZoom - 1;
        if (irowStart < 0) {
            irowStart = 0;
            irowStop = irowStart + nrowsZoom - 1;
        }
        if (irowStop >= nrows) {
            irowStop = nrows - 1;
            irowStart = irowStop - nrowsZoom + 1;
        }
        int icolStart = iColCenter - ncolsZoom / 2;
        int icolStop = icolStart + ncolsZoom - 1;
        if (icolStart < 0) {
            icolStart = 0;
            icolStop = icolStart + ncolsZoom - 1;
        }
        if (icolStop >= ncols) {
            icolStop = ncols - 1;
            icolStart = icolStop - ncolsZoom + 1;
        }
        PixieImage[] zoomPixieImageDisplay = new PixieImage[3];
        int ii = 0;
        while (ii < 3) {
            zoomPixieImageDisplay[ii] = new PixieImage(nrowsZoom, ncolsZoom);
            int ir = 0;
            while (ir < nrowsZoom) {
                int ic = 0;
                while (ic < ncolsZoom) {
                    zoomPixieImageDisplay[ii].getPix()[ir][ic] = pixieImageDisplay[ii].getPix()[ir + irowStart][ic + icolStart];
                    ++ic;
                }
                ++ir;
            }
            ++ii;
        }
        return zoomPixieImageDisplay;
    }

    public static void makeExposureImage(String[] args) throws PixieImageException {
        String inputFitsFileName = "";
        String outputPngFileName = "";
        boolean dark = false;
        int numArgs = args.length;
        int iarg = 0;
        while (iarg < numArgs) {
            if (args[iarg].indexOf(".fits") >= 0) {
                inputFitsFileName = args[iarg];
            }
            if (args[iarg].indexOf(".png") >= 0) {
                outputPngFileName = args[iarg];
            }
            if (args[iarg].indexOf("-dark") >= 0) {
                dark = true;
            }
            ++iarg;
        }
        SingleSimpleImageProcess ssip = new SingleSimpleImageProcess(inputFitsFileName);
        if (!dark) {
            ssip.calcBrightStarSize();
            double starSize = ssip.getBrightStarSize();
            if (starSize > 0.0) {
                System.out.println("Star found in field");
                DecimalFormat tp = new DecimalFormat("###.##");
                System.out.println(String.valueOf(tp.format(starSize)) + "pixels star size");
                tp = new DecimalFormat("###.#");
                System.out.println(String.valueOf(tp.format(ssip.getExposureLevel())) + "% Exposure level");
                boolean[][][] exposureLevelCut = null;
                exposureLevelCut = ssip.exposureLevelCut();
                ssip.removeHotSpots();
                ssip.subtractMean();
                ssip.fitsToPngWithBrightStarLocation(outputPngFileName, 3, true, exposureLevelCut);
            } else {
                System.out.println("Star not found in field");
                System.out.println("0.00pixels star size");
                System.out.println("0.0% Exposure level");
                ssip.fitsToPng(outputPngFileName, 0);
            }
        } else {
            System.out.println("Star not found in field");
            System.out.println("0.00pixels star size");
            System.out.println("0.0% Exposure level");
            ssip.fitsToPng(outputPngFileName, 0);
        }
    }

    public static void main(String[] args) throws PixieImageException {
        int numArgs = args.length;
        if (numArgs > 0) {
            int iarg = 0;
            while (iarg < numArgs) {
                if (args[iarg].indexOf("-exp") >= 0) {
                    SingleSimpleImageProcess.makeExposureImage(args);
                }
                ++iarg;
            }
        }
    }
}

