/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.utilities.spectrogramPlotter;

import com.astrofizzbizz.utilities.spectrogramPlotter.SpectrogramXYZDataset;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.GrayPaintScale;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

public class SpectrogramPlotter {
    private Font titleFont = new Font("SansSerif", 1, 16);
    private double[] xseries;
    private double[] yseries;
    private double[] zseries;
    private double dx;
    private double dy;
    private double zmax;
    private double zmin;
    private String sfileName = "test.png";
    private String xAxisTitle;
    private String yAxisTitle;
    private String zAxisTitle;
    private String chartTitle;
    private int chartPixelWidth = 800;
    private int chartPixelHeight = 600;
    private int numZscaleTicks = 256;
    boolean colorSpectrumScale = true;
    boolean colorGrayScale = false;
    double colorGrayScaleHue = 1.0;
    private boolean xaxisAutoScale = true;
    private double[] xaxisRange = new double[]{-1.0, 1.0};
    private boolean yaxisAutoScale = true;
    private double[] yaxisRange = new double[]{-1.0, 1.0};
    private boolean displayLegend = true;
    private boolean zaxisClip = false;

    public void makePngChart(double[] xseries, double[] yseries, double[] zseries, double dx, double dy, double zmax, String sfileName, String xAxisTitle, String yAxisTitle, String chartTitle, int chartPixelWidth, int chartPixelHeight) throws IOException {
        this.setChartPixelHeight(chartPixelHeight);
        this.setChartPixelWidth(chartPixelWidth);
        this.setFileName(sfileName);
        this.setChartTitle(chartTitle);
        this.setXAxisTitle(xAxisTitle);
        this.setYAxisTitle(yAxisTitle);
        this.setDx(dx);
        this.setDy(dy);
        this.setZmax(zmax);
        this.setXseries(xseries);
        this.setYseries(yseries);
        this.setZseries(zseries);
        this.makePngChart();
    }

    public void makePngChart() throws IOException {
        JFreeChart chart = this.createSpectrogramChart();
        ChartUtilities.saveChartAsPNG(new File(this.sfileName), chart, this.chartPixelWidth, this.chartPixelHeight);
    }

    public JFreeChart createSpectrogramChart() {
        SpectrogramXYZDataset myXYZDataset = new SpectrogramXYZDataset(this.xseries, this.yseries, this.zseries);
        JFreeChart chart = this.createSpectrogramChart(myXYZDataset);
        chart.getTitle().setFont(this.titleFont);
        return chart;
    }

    private LookupPaintScale spectrumPaintScale(boolean clip) {
        LookupPaintScale scale = null;
        scale = clip ? new LookupPaintScale(-1.0E33, 1.0E33, Color.black) : new LookupPaintScale(this.zmin, this.zmax, Color.black);
        if (clip) {
            scale.add(-1.0E33, (Paint)Color.getHSBColor(0.72f, 1.0f, 1.0f));
        }
        int ii = 0;
        while (ii < this.numZscaleTicks) {
            double dc = (double)ii / (double)(this.numZscaleTicks - 1);
            double hue = (1.0 - dc) * 0.72;
            scale.add(this.zmin + (this.zmax - this.zmin) * dc, (Paint)Color.getHSBColor((float)hue, 1.0f, 1.0f));
            ++ii;
        }
        if (clip) {
            scale.add(1.0E33, (Paint)Color.getHSBColor(0.0f, 1.0f, 1.0f));
        }
        return scale;
    }

    private LookupPaintScale colorGrayScale() {
        LookupPaintScale scale = new LookupPaintScale(this.zmin, this.zmax, Color.black);
        int ii = 0;
        while (ii < this.numZscaleTicks) {
            double dc = (double)ii / (double)(this.numZscaleTicks - 1);
            scale.add(this.zmin + (this.zmax - this.zmin) * dc, (Paint)Color.getHSBColor((float)this.colorGrayScaleHue, 1.0f, (float)dc));
            ++ii;
        }
        return scale;
    }

    public double[] findZminZmax() {
        int npts = this.zseries.length;
        double[] zminZmax = new double[]{this.zseries[0], this.zseries[0]};
        int ipt = 1;
        while (ipt < npts) {
            if (zminZmax[0] > this.zseries[ipt]) {
                zminZmax[0] = this.zseries[ipt];
            }
            if (zminZmax[1] < this.zseries[ipt]) {
                zminZmax[1] = this.zseries[ipt];
            }
            ++ipt;
        }
        return zminZmax;
    }

    public void setZminZmax(double[] zminZmax) {
        this.setZmin(zminZmax[0]);
        this.setZmax(zminZmax[1]);
    }

    private int[] binZSeries() {
        int[] bins = new int[this.numZscaleTicks];
        double binSize = (this.zmax - this.zmin) / (double)this.numZscaleTicks;
        int ii = 0;
        while (ii < this.numZscaleTicks) {
            bins[ii] = 0;
            ++ii;
        }
        int npts = this.zseries.length;
        int ipt = 0;
        while (ipt < npts) {
            double bin = this.zseries[ipt] - this.zmin;
            if ((bin /= binSize) - Math.floor(bin) > 0.5) {
                bin = Math.floor(bin) + 1.0;
            } else {
                Math.floor(bin);
            }
            if (bin < 0.0) {
                bin = 0.0;
            }
            if (bin > (double)(this.numZscaleTicks - 1)) {
                bin = this.numZscaleTicks - 1;
            }
            bins[(int)bin] = bins[(int)bin] + 1;
            ++ipt;
        }
        return bins;
    }

    private int[] makeHistEqScaleTable() {
        double[] transfer = new double[this.numZscaleTicks];
        int[] bins = this.binZSeries();
        int[] scaleTable = new int[this.numZscaleTicks];
        transfer[0] = bins[0];
        int ii = 1;
        while (ii < this.numZscaleTicks) {
            transfer[ii] = transfer[ii - 1] + (double)bins[ii];
            ++ii;
        }
        ii = 0;
        while (ii < this.numZscaleTicks) {
            transfer[ii] = (double)(this.numZscaleTicks - 1) * transfer[ii] / transfer[this.numZscaleTicks - 1];
            ++ii;
        }
        ii = 0;
        while (ii < this.numZscaleTicks) {
            scaleTable[ii] = (int)transfer[ii];
            if (scaleTable[ii] < 0) {
                scaleTable[ii] = 0;
            }
            if (scaleTable[ii] >= this.numZscaleTicks) {
                scaleTable[ii] = this.numZscaleTicks - 1;
            }
            ++ii;
        }
        return scaleTable;
    }

    public void histEqZseries() {
        int[] scaleTable = this.makeHistEqScaleTable();
        int npts = this.zseries.length;
        double binSize = (this.zmax - this.zmin) / (double)this.numZscaleTicks;
        int ipt = 0;
        while (ipt < npts) {
            double bin = this.zseries[ipt] - this.zmin;
            if ((bin /= binSize) - Math.floor(bin) > 0.5) {
                bin = Math.floor(bin) + 1.0;
            } else {
                Math.floor(bin);
            }
            if (bin < 0.0) {
                bin = 0.0;
            }
            if (bin > (double)(this.numZscaleTicks - 1)) {
                bin = this.numZscaleTicks - 1;
            }
            this.zseries[ipt] = scaleTable[(int)bin];
            ++ipt;
        }
        this.zmin = scaleTable[0];
        this.zmax = scaleTable[this.numZscaleTicks - 1];
    }

    private JFreeChart createSpectrogramChart(XYZDataset dataset) {
        NumberAxis xAxis = new NumberAxis(this.xAxisTitle);
        if (!this.xaxisAutoScale) {
            xAxis.setRange(this.xaxisRange[0], this.xaxisRange[1]);
        }
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        xAxis.setAxisLinePaint(Color.white);
        xAxis.setTickMarkPaint(Color.white);
        NumberAxis yAxis = new NumberAxis(this.yAxisTitle);
        if (!this.yaxisAutoScale) {
            yAxis.setRange(this.yaxisRange[0], this.yaxisRange[1]);
        }
        yAxis.setLowerMargin(0.0);
        yAxis.setUpperMargin(0.0);
        yAxis.setAxisLinePaint(Color.white);
        yAxis.setTickMarkPaint(Color.white);
        XYBlockRenderer renderer = new XYBlockRenderer();
        renderer.setBlockWidth(this.dx);
        renderer.setBlockHeight(this.dy);
        PaintScale scaleLegend = null;
        PaintScale scaleRender = null;
        if (this.colorSpectrumScale) {
            scaleRender = this.spectrumPaintScale(this.zaxisClip);
            scaleLegend = this.spectrumPaintScale(false);
        } else if (this.colorGrayScale) {
            scaleRender = this.colorGrayScale();
            scaleLegend = this.colorGrayScale();
        } else {
            scaleRender = new GrayPaintScale(this.zmin, this.zmax);
            scaleLegend = new GrayPaintScale(this.zmin, this.zmax);
        }
        renderer.setPaintScale(scaleRender);
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, renderer);
        JFreeChart chart = new JFreeChart(this.chartTitle, plot);
        chart.removeLegend();
        NumberAxis scaleAxis = new NumberAxis(this.zAxisTitle);
        scaleAxis.setAxisLinePaint(Color.white);
        scaleAxis.setTickMarkPaint(Color.white);
        scaleAxis.setTickLabelFont(new Font("Dialog", 0, 7));
        PaintScaleLegend legend = new PaintScaleLegend(scaleLegend, scaleAxis);
        legend.setSubdivisionCount(50);
        legend.setAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        legend.setAxisOffset(5.0);
        legend.setMargin(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        legend.setFrame(new BlockBorder(Color.red));
        legend.setPadding(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        legend.setStripWidth(10.0);
        legend.setPosition(RectangleEdge.RIGHT);
        if (!this.displayLegend) {
            legend.setVisible(false);
        }
        chart.addSubtitle(legend);
        ChartUtilities.applyCurrentTheme(chart);
        plot.setBackgroundPaint(Color.WHITE);
        return chart;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public double[] getXseries() {
        return this.xseries;
    }

    public void setXseries(double[] xseries) {
        this.xseries = xseries;
    }

    public double[] getYseries() {
        return this.yseries;
    }

    public void setYseries(double[] yseries) {
        this.yseries = yseries;
    }

    public double[] getZseries() {
        return this.zseries;
    }

    public void setZseries(double[] zseries) {
        this.zseries = zseries;
    }

    public double getDx() {
        return this.dx;
    }

    public void setDx(double dx) {
        this.dx = dx;
    }

    public double getDy() {
        return this.dy;
    }

    public void setDy(double dy) {
        this.dy = dy;
    }

    public void setDisplayLegend(boolean displayLegend) {
        this.displayLegend = displayLegend;
    }

    public double getZmax() {
        return this.zmax;
    }

    public void setZmax(double zmax) {
        this.zmax = zmax;
    }

    public String getSfileName() {
        return this.sfileName;
    }

    public void setFileName(String sfileName) {
        this.sfileName = sfileName;
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public void setXAxisTitle(String axisTitle) {
        this.xAxisTitle = axisTitle;
    }

    public void setXAxisRage(double minValue, double maxValue) {
        this.xaxisAutoScale = false;
        this.xaxisRange[0] = minValue;
        this.xaxisRange[1] = maxValue;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public void setYAxisTitle(String axisTitle) {
        this.yAxisTitle = axisTitle;
    }

    public void setYAxisRage(double minValue, double maxValue) {
        this.yaxisAutoScale = false;
        this.yaxisRange[0] = minValue;
        this.yaxisRange[1] = maxValue;
    }

    public void setZAxisTitle(String axisTitle) {
        this.zAxisTitle = axisTitle;
    }

    public void setZmin(double zmin) {
        this.zmin = zmin;
    }

    public void setNumZscaleTicks(int numZscaleTicks) {
        this.numZscaleTicks = numZscaleTicks;
    }

    public void setColorSpectrumScale(boolean colorSpectrumScale) {
        this.colorSpectrumScale = colorSpectrumScale;
        if (colorSpectrumScale) {
            this.colorGrayScale = false;
        }
    }

    public void setColorGrayScale(boolean colorGrayScale) {
        this.colorGrayScale = colorGrayScale;
        if (colorGrayScale) {
            this.colorSpectrumScale = false;
        }
    }

    public void setColorGrayScaleHue(double colorGrayScaleHue) {
        this.colorGrayScaleHue = colorGrayScaleHue;
    }

    public void setZaxisClip(boolean zaxisClip) {
        this.zaxisClip = zaxisClip;
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public void setChartTitle(String chartTitle) {
        this.chartTitle = chartTitle;
    }

    public int getChartPixelWidth() {
        return this.chartPixelWidth;
    }

    public void setChartPixelWidth(int chartPixelWidth) {
        this.chartPixelWidth = chartPixelWidth;
    }

    public int getChartPixelHeight() {
        return this.chartPixelHeight;
    }

    public void setChartPixelHeight(int chartPixelHeight) {
        this.chartPixelHeight = chartPixelHeight;
    }

    public static void main(String[] args) throws IOException {
        double[] xseries = new double[10000];
        double[] yseries = new double[10000];
        double[] zseries = new double[10000];
        double dx = 0.02;
        double dy = 0.02;
        double zmax = 0.0;
        int ic = 0;
        int ix = 0;
        while (ix < 100) {
            int iy = 0;
            while (iy < 100) {
                xseries[ic] = -1.0 + 2.0 * (double)ix / 99.0;
                yseries[ic] = -1.0 + 2.0 * (double)iy / 99.0;
                double r = Math.sqrt(xseries[ic] * xseries[ic] + yseries[ic] * yseries[ic]);
                zseries[ic] = Math.exp(-r);
                if (zmax < zseries[ic]) {
                    zmax = zseries[ic];
                }
                ++ic;
                ++iy;
            }
            ++ix;
        }
        SpectrogramPlotter sp = new SpectrogramPlotter();
        sp.setChartPixelHeight(600);
        sp.setChartPixelWidth(800);
        sp.setFileName("Test.png");
        sp.setChartTitle("Test");
        sp.setXAxisTitle("X axis");
        sp.setYAxisTitle("Y axis");
        sp.setZAxisTitle("Z axis");
        sp.setDx(dx);
        sp.setDy(dy);
        sp.setZmax(zmax);
        sp.setXseries(xseries);
        sp.setYseries(yseries);
        sp.setZseries(zseries);
        sp.setZaxisClip(false);
        sp.setDisplayLegend(false);
        sp.setZminZmax(sp.findZminZmax());
        sp.histEqZseries();
        sp.makePngChart();
    }
}

