/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.utilities.spectrogramPlotter;

import com.astrofizzbizz.utilities.spectrogramPlotter.SpectrogramPlotter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.jfree.chart.ChartPanel;

public class SpectrogramPlotterJFrame
extends JFrame {
    private static final long serialVersionUID = -6165604043529116140L;
    JTabbedPane jtab = new JTabbedPane();
    SpectrogramPlotter[] specPlot;
    ChartPanel[] chartPanel;

    public SpectrogramPlotterJFrame(String jFrameTitle, SpectrogramPlotter[] sp) {
        super(jFrameTitle);
        this.specPlot = sp;
        this.setJMenuBar(this.addMenu());
        int nplots = this.specPlot.length;
        this.chartPanel = new ChartPanel[nplots];
        int ip = 0;
        while (ip < nplots) {
            this.chartPanel[ip] = new ChartPanel(this.specPlot[ip].createSpectrogramChart());
            this.jtab.addTab(this.specPlot[ip].getChartTitle(), this.chartPanel[ip]);
            ++ip;
        }
        this.getContentPane().add((Component)this.jtab, "Center");
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDefaultCloseOperation(3);
        this.pack();
        this.setVisible(true);
    }

    private JMenuBar addMenu() {
        JMenuBar menuBar = new JMenuBar();
        String[] menuText = new String[]{"Set Plot Type", "Set Z Scale"};
        String[][] itemText = new String[][]{{"Color Spectrum", "Color Gray", "BW Gray"}, {"Set Zmax", "Set Zmin"}};
        int i = 0;
        while (i < menuText.length) {
            JMenu menu = new JMenu(menuText[i]);
            menuBar.add(menu);
            int j = 0;
            while (j < itemText[i].length) {
                JMenuItem item = new JMenuItem(itemText[i][j]);
                menu.add(item);
                item.addActionListener(new SpectrogramPlotterJFrameActionListeners(String.valueOf(menuText[i]) + "." + itemText[i][j], this));
                ++j;
            }
            ++i;
        }
        return menuBar;
    }

    public static void main(String[] args) {
        double[] xseries = new double[10000];
        double[] yseries = new double[10000];
        double[] zseries = new double[10000];
        double dx = 0.02;
        double dy = 0.02;
        double zmax = 0.0;
        int ic = 0;
        int ix = 0;
        while (ix < 100) {
            int iy = 0;
            while (iy < 100) {
                xseries[ic] = -1.0 + 2.0 * (double)ix / 99.0;
                yseries[ic] = -1.0 + 2.0 * (double)iy / 99.0;
                double r = Math.sqrt(xseries[ic] * xseries[ic] + yseries[ic] * yseries[ic]);
                zseries[ic] = Math.exp(-r);
                if (zmax < zseries[ic]) {
                    zmax = zseries[ic];
                }
                ++ic;
                ++iy;
            }
            ++ix;
        }
        SpectrogramPlotter sp = new SpectrogramPlotter();
        sp.setChartPixelHeight(600);
        sp.setChartPixelWidth(800);
        sp.setFileName("Test.png");
        sp.setChartTitle("Test");
        sp.setXAxisTitle("X axis");
        sp.setYAxisTitle("Y axis");
        sp.setZAxisTitle("Z axis");
        sp.setDx(dx);
        sp.setDy(dy);
        sp.setZmax(zmax);
        sp.setXseries(xseries);
        sp.setYseries(yseries);
        sp.setZseries(zseries);
        SpectrogramPlotter[] spVec = new SpectrogramPlotter[]{sp, sp, sp};
        new SpectrogramPlotterJFrame("Test", spVec);
    }

    class SpectrogramPlotterJFrameActionListeners
    implements ActionListener {
        String actionString = "";
        JFrame parentJFrame;

        SpectrogramPlotterJFrameActionListeners(String actionString, JFrame parentJFrame) {
            this.actionString = actionString;
            this.parentJFrame = parentJFrame;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s;
            int itab;
            if ("Set Plot Type.Color Spectrum".equals(this.actionString)) {
                itab = SpectrogramPlotterJFrame.this.jtab.getSelectedIndex();
                SpectrogramPlotterJFrame.this.specPlot[itab].setColorSpectrumScale(true);
                SpectrogramPlotterJFrame.this.chartPanel[itab] = new ChartPanel(SpectrogramPlotterJFrame.this.specPlot[itab].createSpectrogramChart());
                SpectrogramPlotterJFrame.this.jtab.remove(itab);
                SpectrogramPlotterJFrame.this.jtab.insertTab(SpectrogramPlotterJFrame.this.specPlot[itab].getChartTitle(), null, SpectrogramPlotterJFrame.this.chartPanel[itab], "", itab);
                SpectrogramPlotterJFrame.this.jtab.setSelectedIndex(itab);
            }
            if ("Set Plot Type.Color Gray".equals(this.actionString)) {
                itab = SpectrogramPlotterJFrame.this.jtab.getSelectedIndex();
                SpectrogramPlotterJFrame.this.specPlot[itab].setColorGrayScale(true);
                SpectrogramPlotterJFrame.this.chartPanel[itab] = new ChartPanel(SpectrogramPlotterJFrame.this.specPlot[itab].createSpectrogramChart());
                SpectrogramPlotterJFrame.this.jtab.remove(itab);
                SpectrogramPlotterJFrame.this.jtab.insertTab(SpectrogramPlotterJFrame.this.specPlot[itab].getChartTitle(), null, SpectrogramPlotterJFrame.this.chartPanel[itab], "", itab);
                SpectrogramPlotterJFrame.this.jtab.setSelectedIndex(itab);
            }
            if ("Set Plot Type.BW Gray".equals(this.actionString)) {
                itab = SpectrogramPlotterJFrame.this.jtab.getSelectedIndex();
                SpectrogramPlotterJFrame.this.specPlot[itab].setColorGrayScale(false);
                SpectrogramPlotterJFrame.this.specPlot[itab].setColorSpectrumScale(false);
                SpectrogramPlotterJFrame.this.chartPanel[itab] = new ChartPanel(SpectrogramPlotterJFrame.this.specPlot[itab].createSpectrogramChart());
                SpectrogramPlotterJFrame.this.jtab.remove(itab);
                SpectrogramPlotterJFrame.this.jtab.insertTab(SpectrogramPlotterJFrame.this.specPlot[itab].getChartTitle(), null, SpectrogramPlotterJFrame.this.chartPanel[itab], "", itab);
                SpectrogramPlotterJFrame.this.jtab.setSelectedIndex(itab);
            }
            if ("Set Z Scale.Set Zmax".equals(this.actionString) && (s = (String)JOptionPane.showInputDialog(this.parentJFrame, "Enter Zmax", "Zmax", -1, null, null, "")) != null && s.length() > 0) {
                double zmax = Double.valueOf(s);
                System.out.println(s);
                int itab2 = SpectrogramPlotterJFrame.this.jtab.getSelectedIndex();
                SpectrogramPlotterJFrame.this.specPlot[itab2].setZmax(zmax);
                SpectrogramPlotterJFrame.this.chartPanel[itab2] = new ChartPanel(SpectrogramPlotterJFrame.this.specPlot[itab2].createSpectrogramChart());
                SpectrogramPlotterJFrame.this.jtab.remove(itab2);
                SpectrogramPlotterJFrame.this.jtab.insertTab(SpectrogramPlotterJFrame.this.specPlot[itab2].getChartTitle(), null, SpectrogramPlotterJFrame.this.chartPanel[itab2], "", itab2);
                SpectrogramPlotterJFrame.this.jtab.setSelectedIndex(itab2);
                return;
            }
            if ("Set Z Scale.Set Zmin".equals(this.actionString) && (s = (String)JOptionPane.showInputDialog(this.parentJFrame, "Enter Zmin", "Zmin", -1, null, null, "")) != null && s.length() > 0) {
                double zmin = Double.valueOf(s);
                System.out.println(s);
                int itab3 = SpectrogramPlotterJFrame.this.jtab.getSelectedIndex();
                SpectrogramPlotterJFrame.this.specPlot[itab3].setZmin(zmin);
                SpectrogramPlotterJFrame.this.chartPanel[itab3] = new ChartPanel(SpectrogramPlotterJFrame.this.specPlot[itab3].createSpectrogramChart());
                SpectrogramPlotterJFrame.this.jtab.remove(itab3);
                SpectrogramPlotterJFrame.this.jtab.insertTab(SpectrogramPlotterJFrame.this.specPlot[itab3].getChartTitle(), null, SpectrogramPlotterJFrame.this.chartPanel[itab3], "", itab3);
                SpectrogramPlotterJFrame.this.jtab.setSelectedIndex(itab3);
                return;
            }
        }
    }
}

