/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import nom.tam.util.ArrayDataInput;

public class BufferedDataInputStream
extends BufferedInputStream
implements ArrayDataInput {
    private long primitiveArrayCount;
    private byte[] bb = new byte[8];
    private byte[] skipBuf = null;

    public BufferedDataInputStream(InputStream o) {
        super(o, 32768);
    }

    public BufferedDataInputStream(InputStream o, int bufLength) {
        super(o, bufLength);
    }

    @Override
    public int read(byte[] obuf, int offset, int len) throws IOException {
        int total = 0;
        while (len > 0) {
            int xlen = super.read(obuf, offset, len);
            if (xlen <= 0) {
                if (total == 0) {
                    throw new EOFException();
                }
                return total;
            }
            len -= xlen;
            total += xlen;
            offset += xlen;
        }
        return total;
    }

    @Override
    public boolean readBoolean() throws IOException {
        int b = this.read();
        return b == 1;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.read() | 0xFF;
    }

    @Override
    public int readInt() throws IOException {
        if (this.read(this.bb, 0, 4) < 4) {
            throw new EOFException();
        }
        int i = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        return i;
    }

    @Override
    public short readShort() throws IOException {
        if (this.read(this.bb, 0, 2) < 2) {
            throw new EOFException();
        }
        short s = (short)(this.bb[0] << 8 | this.bb[1] & 0xFF);
        return s;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.read(this.bb, 0, 2) < 2) {
            throw new EOFException();
        }
        return (this.bb[0] & 0xFF) << 8 | this.bb[1] & 0xFF;
    }

    @Override
    public char readChar() throws IOException {
        byte[] b = new byte[2];
        if (this.read(b, 0, 2) < 2) {
            throw new EOFException();
        }
        char c = (char)(b[0] << 8 | b[1] & 0xFF);
        return c;
    }

    @Override
    public long readLong() throws IOException {
        if (this.read(this.bb, 0, 8) < 8) {
            throw new EOFException();
        }
        int i1 = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        int i2 = this.bb[4] << 24 | (this.bb[5] & 0xFF) << 16 | (this.bb[6] & 0xFF) << 8 | this.bb[7] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    @Override
    public float readFloat() throws IOException {
        if (this.read(this.bb, 0, 4) < 4) {
            throw new EOFException();
        }
        int i = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    @Override
    public double readDouble() throws IOException {
        if (this.read(this.bb, 0, 8) < 8) {
            throw new EOFException();
        }
        int i1 = this.bb[0] << 24 | (this.bb[1] & 0xFF) << 16 | (this.bb[2] & 0xFF) << 8 | this.bb[3] & 0xFF;
        int i2 = this.bb[4] << 24 | (this.bb[5] & 0xFF) << 16 | (this.bb[6] & 0xFF) << 8 | this.bb[7] & 0xFF;
        return Double.longBitsToDouble((long)i1 << 32 | (long)i2 & 0xFFFFFFFFL);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IOException("Attempt to read outside byte array");
        }
        if (this.read(b, off, len) < len) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int toSkip) throws IOException {
        return (int)this.skipBytes((long)toSkip);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long skipBytes(long toSkip) throws IOException {
        need = toSkip;
        block2: while (need > 0L) {
            try {
                got = this.skip(need);
                if (got <= 0L) break;
                need -= got;
                continue;
            }
            catch (IOException e) {
                if (this.skipBuf == null) {
                    this.skipBuf = new byte[8192];
                }
                ** while (need > 8192L)
            }
lbl-1000:
            // 1 sources

            {
                got = this.read(this.skipBuf, 0, 8192);
                if (got <= 0) break;
                need -= (long)got;
                continue;
            }
lbl16:
            // 3 sources

            while (need > 0L) {
                got = this.read(this.skipBuf, 0, (int)need);
                if (got <= 0) continue block2;
                need -= (long)got;
            }
        }
        if (need > 0L) {
            throw new EOFException();
        }
        return toSkip;
    }

    @Override
    public String readUTF() throws IOException {
        DataInputStream d = new DataInputStream(this);
        return d.readUTF();
    }

    @Override
    public String readLine() throws IOException {
        BufferedReader d = new BufferedReader(new InputStreamReader(this));
        return d.readLine();
    }

    public int readPrimitiveArray(Object o) throws IOException {
        this.primitiveArrayCount = 0L;
        return (int)this.readLArray(o);
    }

    @Override
    public int readArray(Object o) throws IOException {
        return (int)this.readLArray(o);
    }

    @Override
    public long readLArray(Object o) throws IOException {
        this.primitiveArrayCount = 0L;
        return this.primitiveArrayRecurse(o);
    }

    protected long primitiveArrayRecurse(Object o) throws IOException {
        if (o == null) {
            return this.primitiveArrayCount;
        }
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataInputStream.readArray:" + className);
        }
        if (className.charAt(1) == '[') {
            int i = 0;
            while (i < ((Object[])o).length) {
                this.primitiveArrayRecurse(((Object[])o)[i]);
                ++i;
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.primitiveArrayCount += (long)this.read((boolean[])o, 0, ((boolean[])o).length);
                    break;
                }
                case 'B': {
                    int len = this.read((byte[])o, 0, ((byte[])o).length);
                    this.primitiveArrayCount += (long)len;
                    if (len < ((byte[])o).length) {
                        throw new EOFException();
                    }
                    break;
                }
                case 'C': {
                    this.primitiveArrayCount += (long)this.read((char[])o, 0, ((char[])o).length);
                    break;
                }
                case 'S': {
                    this.primitiveArrayCount += (long)this.read((short[])o, 0, ((short[])o).length);
                    break;
                }
                case 'I': {
                    this.primitiveArrayCount += (long)this.read((int[])o, 0, ((int[])o).length);
                    break;
                }
                case 'J': {
                    this.primitiveArrayCount += (long)this.read((long[])o, 0, ((long[])o).length);
                    break;
                }
                case 'F': {
                    this.primitiveArrayCount += (long)this.read((float[])o, 0, ((float[])o).length);
                    break;
                }
                case 'D': {
                    this.primitiveArrayCount += (long)this.read((double[])o, 0, ((double[])o).length);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.Object;")) {
                        int i = 0;
                        while (i < ((Object[])o).length) {
                            this.primitiveArrayRecurse(((Object[])o)[i]);
                            ++i;
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataInputStream.readArray: " + className);
                }
            }
        }
        return this.primitiveArrayCount;
    }

    private void fillBuf(int need) throws IOException {
        if (this.count > this.pos) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
            this.count -= this.pos;
            need -= this.count;
            this.pos = 0;
        } else {
            this.count = 0;
            this.pos = 0;
        }
        while (need > 0) {
            int len = this.in.read(this.buf, this.count, this.buf.length - this.count);
            if (len <= 0) {
                throw new EOFException();
            }
            this.count += len;
            need -= len;
        }
    }

    @Override
    public int read(boolean[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(boolean[] b, int start, int len) throws IOException {
        int i = start;
        try {
            while (i < start + len) {
                if (this.pos >= this.count) {
                    this.fillBuf(1);
                }
                b[i] = this.buf[this.pos] == 1;
                ++this.pos;
                ++i;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, i, start, 1);
        }
        return len;
    }

    @Override
    public int read(short[] s) throws IOException {
        return this.read(s, 0, s.length);
    }

    @Override
    public int read(short[] s, int start, int len) throws IOException {
        int i = start;
        try {
            while (i < start + len) {
                if (this.count - this.pos < 2) {
                    this.fillBuf(2);
                }
                s[i] = (short)(this.buf[this.pos] << 8 | this.buf[this.pos + 1] & 0xFF);
                this.pos += 2;
                ++i;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, i, start, 2);
        }
        return 2 * len;
    }

    @Override
    public int read(char[] c) throws IOException {
        return this.read(c, 0, c.length);
    }

    @Override
    public int read(char[] c, int start, int len) throws IOException {
        int i = start;
        try {
            while (i < start + len) {
                if (this.count - this.pos < 2) {
                    this.fillBuf(2);
                }
                c[i] = (char)(this.buf[this.pos] << 8 | this.buf[this.pos + 1] & 0xFF);
                this.pos += 2;
                ++i;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, i, start, 2);
        }
        return 2 * len;
    }

    @Override
    public int read(int[] i) throws IOException {
        return this.read(i, 0, i.length);
    }

    @Override
    public int read(int[] i, int start, int len) throws IOException {
        int ii = start;
        try {
            while (ii < start + len) {
                if (this.count - this.pos < 4) {
                    this.fillBuf(4);
                }
                i[ii] = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                this.pos += 4;
                ++ii;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, ii, start, 4);
        }
        return i.length * 4;
    }

    @Override
    public int read(long[] l) throws IOException {
        return this.read(l, 0, l.length);
    }

    @Override
    public int read(long[] l, int start, int len) throws IOException {
        int i = start;
        try {
            while (i < start + len) {
                if (this.count - this.pos < 8) {
                    this.fillBuf(8);
                }
                int i1 = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                int i2 = this.buf[this.pos + 4] << 24 | (this.buf[this.pos + 5] & 0xFF) << 16 | (this.buf[this.pos + 6] & 0xFF) << 8 | this.buf[this.pos + 7] & 0xFF;
                l[i] = (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
                this.pos += 8;
                ++i;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, i, start, 8);
        }
        return 8 * len;
    }

    @Override
    public int read(float[] f) throws IOException {
        return this.read(f, 0, f.length);
    }

    @Override
    public int read(float[] f, int start, int len) throws IOException {
        int i = start;
        try {
            while (i < start + len) {
                if (this.count - this.pos < 4) {
                    this.fillBuf(4);
                }
                int t = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                f[i] = Float.intBitsToFloat(t);
                this.pos += 4;
                ++i;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, i, start, 4);
        }
        return 4 * len;
    }

    @Override
    public int read(double[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    @Override
    public int read(double[] d, int start, int len) throws IOException {
        int i = start;
        try {
            while (i < start + len) {
                if (this.count - this.pos < 8) {
                    this.fillBuf(8);
                }
                int i1 = this.buf[this.pos] << 24 | (this.buf[this.pos + 1] & 0xFF) << 16 | (this.buf[this.pos + 2] & 0xFF) << 8 | this.buf[this.pos + 3] & 0xFF;
                int i2 = this.buf[this.pos + 4] << 24 | (this.buf[this.pos + 5] & 0xFF) << 16 | (this.buf[this.pos + 6] & 0xFF) << 8 | this.buf[this.pos + 7] & 0xFF;
                d[i] = Double.longBitsToDouble((long)i1 << 32 | (long)i2 & 0xFFFFFFFFL);
                this.pos += 8;
                ++i;
            }
        }
        catch (EOFException e) {
            return this.eofCheck(e, i, start, 8);
        }
        return 8 * len;
    }

    private int eofCheck(EOFException e, int i, int start, int length) throws EOFException {
        if (i == start) {
            throw e;
        }
        return (i - start) * length;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[count=" + this.count + ",pos=" + this.pos + "]";
    }
}

