/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import java.io.PrintStream;

public abstract class SimplexOptimize {
    int numTotalVariables;
    int numOptVariables;
    double simLimit;
    int optLimitType;
    OptimizeVariable[] variable = null;
    int[] lookupVector = null;
    PrintStream chatterStream = null;

    public abstract double fChiSquare();

    public abstract void setupOptimization();

    int iAmoeba(double[][] p, double[] y, int ndim, double ftol, int[] nfunk) {
        int i;
        double sum;
        int mpts = ndim + 1;
        double[] psum = null;
        double ftime = 0.0;
        double TINY = 1.0E-33;
        psum = new double[ndim + 1];
        nfunk[0] = 0;
        int j = 1;
        while (j <= ndim) {
            sum = 0.0;
            i = 1;
            while (i <= mpts) {
                sum += p[i][j];
                ++i;
            }
            psum[j] = sum;
            ++j;
        }
        block2: while (true) {
            int inhi;
            int ihi;
            int ilo = 1;
            if (y[1] > y[2]) {
                ihi = 1;
                inhi = 2;
            } else {
                ihi = 2;
                inhi = 1;
            }
            i = 1;
            while (i <= mpts) {
                if (y[i] <= y[ilo]) {
                    ilo = i;
                }
                if (y[i] > y[ihi]) {
                    inhi = ihi;
                    ihi = i;
                } else if (y[i] > y[inhi] && i != ihi) {
                    inhi = i;
                }
                ++i;
            }
            if (nfunk[0] > (int)this.simLimit && this.optLimitType == 1) {
                double dswap = y[1];
                y[1] = y[ilo];
                y[ilo] = dswap;
                i = 1;
                while (i <= ndim) {
                    dswap = p[1][i];
                    p[1][i] = p[ilo][i];
                    p[ilo][i] = dswap;
                    ++i;
                }
                psum = null;
                return -1;
            }
            if (ftime > this.simLimit && this.optLimitType == 2) {
                double dswap = y[1];
                y[1] = y[ilo];
                y[ilo] = dswap;
                i = 1;
                while (i <= ndim) {
                    dswap = p[1][i];
                    p[1][i] = p[ilo][i];
                    p[ilo][i] = dswap;
                    ++i;
                }
                psum = null;
                return -2;
            }
            if (y[ilo] < this.simLimit && this.optLimitType == 3) {
                double dswap = y[1];
                y[1] = y[ilo];
                y[ilo] = dswap;
                i = 1;
                while (i <= ndim) {
                    dswap = p[1][i];
                    p[1][i] = p[ilo][i];
                    p[ilo][i] = dswap;
                    ++i;
                }
                psum = null;
                return -3;
            }
            double rtol = 2.0 * Math.abs(y[ihi] - y[ilo]) / (Math.abs(y[ihi]) + Math.abs(y[ilo]) + TINY);
            if (rtol < ftol) {
                double dswap = y[1];
                y[1] = y[ilo];
                y[ilo] = dswap;
                i = 1;
                while (i <= ndim) {
                    dswap = p[1][i];
                    p[1][i] = p[ilo][i];
                    p[ilo][i] = dswap;
                    ++i;
                }
                break;
            }
            nfunk[0] = nfunk[0] + 2;
            double ytry = this.amotry(p, y, psum, ndim, ihi, -1.0);
            if (ytry < 0.0) {
                psum = null;
                return -100;
            }
            if (ytry <= y[ilo]) {
                ytry = this.amotry(p, y, psum, ndim, ihi, 2.0);
                if (!(ytry < 0.0)) continue;
                psum = null;
                return -100;
            }
            if (ytry >= y[inhi]) {
                double ysave = y[ihi];
                ytry = this.amotry(p, y, psum, ndim, ihi, 0.5);
                if (ytry < 0.0) {
                    psum = null;
                    return -100;
                }
                if (!(ytry >= ysave)) continue;
                i = 1;
                while (i <= mpts) {
                    if (i != ilo) {
                        j = 1;
                        while (j <= ndim) {
                            p[i][j] = psum[j] = 0.5 * (p[i][j] + p[ilo][j]);
                            ++j;
                        }
                        this.vSetupTrial(psum);
                        y[i] = this.fChiSquare();
                        if (y[i] < 0.0) {
                            psum = null;
                            return -100;
                        }
                    }
                    ++i;
                }
                nfunk[0] = nfunk[0] + ndim;
                j = 1;
                while (true) {
                    if (j > ndim) continue block2;
                    sum = 0.0;
                    i = 1;
                    while (i <= mpts) {
                        sum += p[i][j];
                        ++i;
                    }
                    psum[j] = sum;
                    ++j;
                }
            }
            nfunk[0] = nfunk[0] - 1;
        }
        psum = null;
        return 0;
    }

    double amotry(double[][] p, double[] y, double[] psum, int ndim, int ihi, double fac) {
        double[] ptry = null;
        ptry = new double[ndim + 1];
        double fac1 = (1.0 - fac) / (double)ndim;
        double fac2 = fac1 - fac;
        int j = 1;
        while (j <= ndim) {
            ptry[j] = psum[j] * fac1 - p[ihi][j] * fac2;
            ++j;
        }
        this.vSetupTrial(ptry);
        double ytry = this.fChiSquare();
        if (ytry < 0.0) {
            ptry = null;
            return ytry;
        }
        if (ytry < y[ihi]) {
            y[ihi] = ytry;
            j = 1;
            while (j <= ndim) {
                int n = j;
                psum[n] = psum[n] + (ptry[j] - p[ihi][j]);
                p[ihi][j] = ptry[j];
                ++j;
            }
        }
        ptry = null;
        return ytry;
    }

    public int Optimize(double ftol) {
        int[] infunc = new int[2];
        double[] fvary_param = null;
        double[] fchi_square = null;
        double[][] fsolutions = null;
        fvary_param = new double[this.numOptVariables + 1];
        fchi_square = new double[this.numOptVariables + 1 + 1];
        fsolutions = new double[this.numOptVariables + 1 + 1][this.numOptVariables + 1];
        double fchiba = 0.0;
        int iparam = 1;
        while (iparam <= this.numOptVariables) {
            fvary_param[iparam] = 0.0;
            ++iparam;
        }
        this.vSetupTrial(fvary_param);
        fchiba = this.fChiSquare();
        if (fchiba < 0.0) {
            fvary_param = null;
            fchi_square = null;
            fsolutions = null;
            return -1;
        }
        int isolution = 1;
        while (isolution <= this.numOptVariables + 1) {
            iparam = 1;
            while (iparam <= this.numOptVariables) {
                fvary_param[iparam] = 0.0;
                fsolutions[isolution][iparam] = 0.0;
                ++iparam;
            }
            if (isolution > 1) {
                fvary_param[isolution - 1] = 1.0;
                fsolutions[isolution][isolution - 1] = 1.0;
            }
            this.vSetupTrial(fvary_param);
            fchi_square[isolution] = this.fChiSquare();
            if (fchi_square[isolution] < 0.0) {
                fvary_param = null;
                fchi_square = null;
                fsolutions = null;
                return -1;
            }
            ++isolution;
        }
        int istatus = this.iAmoeba(fsolutions, fchi_square, this.numOptVariables, ftol, infunc);
        if (istatus == -1) {
            this.chitChat("Exceeded maximum number of iterations " + infunc[0]);
        }
        if (istatus == -2) {
            this.chitChat("Exceeded Time limit of " + this.simLimit);
            this.chitChat("Number of iterations " + infunc[0]);
        }
        if (istatus == -3) {
            this.chitChat("Reached Chi Square of " + this.simLimit);
            this.chitChat("Number of iterations " + infunc[0]);
        }
        if (istatus == 0) {
            this.chitChat("Function minimized after " + infunc[0] + " iterations.");
        }
        if (istatus == -100) {
            this.chitChat("Minimization interrupted");
        }
        this.vSetupTrial(fsolutions[1]);
        fchiba = this.fChiSquare();
        fvary_param = null;
        fchi_square = null;
        fsolutions = null;
        if (fchiba > 0.0) {
            this.chitChat("Ending Chi Square = " + fchiba);
            return 0;
        }
        this.chitChat("Minimization interrupted");
        return -1;
    }

    void vSetupTrial(double[] x) {
        int ii = 0;
        while (ii < this.numOptVariables) {
            this.variable[this.lookupVector[ii]].value = x[ii + 1] * this.variable[this.lookupVector[ii]].step + this.variable[this.lookupVector[ii]].initValue;
            if (this.variable[this.lookupVector[ii]].value > this.variable[this.lookupVector[ii]].max) {
                this.variable[this.lookupVector[ii]].value = this.variable[this.lookupVector[ii]].max;
            }
            if (this.variable[this.lookupVector[ii]].value < this.variable[this.lookupVector[ii]].min) {
                this.variable[this.lookupVector[ii]].value = this.variable[this.lookupVector[ii]].min;
            }
            ++ii;
        }
    }

    public void chitChat(String cmessage) {
        if (this.chatterStream == null) {
            return;
        }
        this.chatterStream.println(cmessage);
    }

    public int getNumTotalVariables() {
        return this.numTotalVariables;
    }

    public void setNumTotalVariables(int numTotalVariables) {
        this.numTotalVariables = numTotalVariables;
    }

    public int getNumOptVariables() {
        return this.numOptVariables;
    }

    public void setNumOptVariables(int numOptVariables) {
        this.numOptVariables = numOptVariables;
    }

    public double getSimLimit() {
        return this.simLimit;
    }

    public void setSimLimit(double simLimit) {
        this.simLimit = simLimit;
    }

    public int getOptLimitType() {
        return this.optLimitType;
    }

    public void setOptLimitType(int optLimitType) {
        this.optLimitType = optLimitType;
    }

    public OptimizeVariable[] getVariable() {
        return this.variable;
    }

    public void setVariable(OptimizeVariable[] variable) {
        this.variable = variable;
    }

    public int[] getLookupVector() {
        return this.lookupVector;
    }

    public void setLookupVector(int[] lookupVector) {
        this.lookupVector = lookupVector;
    }

    public void setPrintStream(PrintStream printStream) {
        this.chatterStream = printStream;
    }

    public class OptimizeVariable {
        String name;
        double value;
        double min;
        double max;
        double step;
        double initValue;
        double mask;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }

        public double getMax() {
            return this.max;
        }

        public void setMax(double max) {
            this.max = max;
        }

        public double getStep() {
            return this.step;
        }

        public void setStep(double step) {
            this.step = step;
        }

        public double getInitValue() {
            return this.initValue;
        }

        public void setInitValue(double initValue) {
            this.initValue = initValue;
        }

        public double getMask() {
            return this.mask;
        }

        public void setMask(double mask) {
            this.mask = mask;
        }
    }
}

