/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.numericalrecipes;

import com.astrofizzbizz.numericalrecipes.SimplexOptimize;
import java.io.FileNotFoundException;

public class TestSimplexOptimizer
extends SimplexOptimize {
    private int numVariables = 3;
    double[] coeff = new double[]{0.0, 0.0, 0.0};
    double[] x = new double[]{-1.0, 0.0, 1.0};
    double[] ymeas = new double[]{1.0, 0.3, 6.3333333333};

    @Override
    public double fChiSquare() {
        int ii = 0;
        while (ii < 3) {
            this.coeff[ii] = this.getVariable()[ii].getValue();
            ++ii;
        }
        double chi = 0.0;
        int ii2 = 0;
        while (ii2 < 3) {
            double y = this.polyfit(this.x[ii2]);
            chi += (y - this.ymeas[ii2]) * (y - this.ymeas[ii2]);
            ++ii2;
        }
        return chi;
    }

    public double polyfit(double x) {
        double y = 0.0;
        double xpow = 1.0;
        int ii = 0;
        while (ii < this.numVariables) {
            y += this.coeff[ii] * xpow;
            xpow *= x;
            ++ii;
        }
        return y;
    }

    @Override
    public void setupOptimization() {
        this.setNumTotalVariables(this.numVariables);
        this.setNumOptVariables(this.numVariables);
        this.setVariable(new SimplexOptimize.OptimizeVariable[this.getNumTotalVariables()]);
        this.setLookupVector(new int[this.getNumTotalVariables()]);
        int ii = 0;
        while (ii < this.numVariables) {
            this.getVariable()[ii] = new SimplexOptimize.OptimizeVariable(this);
            this.getVariable()[ii].setInitValue(0.0);
            this.getVariable()[ii].setMin(-100.0);
            this.getVariable()[ii].setMax(100.0);
            this.getVariable()[ii].setStep(0.01);
            this.getVariable()[ii].setValue(0.0);
            this.getLookupVector()[ii] = ii;
            ++ii;
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        TestSimplexOptimizer test = new TestSimplexOptimizer();
        test.setPrintStream(System.out);
        test.setupOptimization();
        test.setOptLimitType(1);
        test.setSimLimit(100000.0);
        test.Optimize(1.0E-24);
        int ii = 0;
        while (ii < 3) {
            System.out.println(String.valueOf(ii) + " " + test.coeff[ii]);
            ++ii;
        }
    }
}

