/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.PixieCoord;

public class Pixie {
    private double compVal = 0.0;
    private static final int NUMBER_OF_COLORS = 3;
    private double[] colorVal = new double[3];
    private PixieCoord coord = null;
    public static final int COMP = -1;
    public static final int GBAND = 0;
    public static final int RBAND = 1;
    public static final int IBAND = 2;

    public Pixie() {
        this.coord = new PixieCoord();
        this.compVal = 0.0;
        int icolor = 0;
        while (icolor < 3) {
            this.colorVal[icolor] = 0.0;
            ++icolor;
        }
    }

    public Pixie(Pixie p) {
        this.coord = new PixieCoord(p.coord);
        this.compVal = p.compVal;
        int icolor = 0;
        while (icolor < 3) {
            this.colorVal[icolor] = p.colorVal[icolor];
            ++icolor;
        }
    }

    public Pixie(PixieCoord c, double val) {
        this.coord = new PixieCoord(c);
        this.compVal = val;
        int icolor = 0;
        while (icolor < 3) {
            this.colorVal[icolor] = 0.0;
            ++icolor;
        }
    }

    public int getRow() {
        return this.coord.getRow();
    }

    public int getCol() {
        return this.coord.getCol();
    }

    public PixieCoord getCoord() {
        return this.coord;
    }

    public double getCompVal() {
        return this.compVal;
    }

    public double getColorVal(int icolor) {
        if (icolor < 0 || icolor >= 3) {
            return 0.0;
        }
        return this.colorVal[icolor];
    }

    public void setRow(int row) {
        this.coord.setRow(row);
    }

    public void setCol(int col) {
        this.coord.setCol(col);
    }

    public void setCompVal(double val) {
        this.compVal = val;
    }

    public void setColorVal(int icolor, double val) {
        if (icolor == -1) {
            this.compVal = val;
        }
        if (icolor == 0) {
            this.colorVal[0] = val;
        }
        if (icolor == 1) {
            this.colorVal[1] = val;
        }
        if (icolor == 2) {
            this.colorVal[2] = val;
        }
    }

    public String getKey() {
        return this.coord.getKey();
    }

    public boolean checkKey(String skey) {
        return this.coord.checkKey(skey);
    }
}

