/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.pixie;

import com.astrofizzbizz.pixie.Pixie;
import com.astrofizzbizz.pixie.PixieImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class PixieImageRGBPlotterNoSwing {
    private PixieImage redImage = null;
    private PixieImage greenImage = null;
    private PixieImage blueImage = null;
    private double minPixelValue = 0.0;
    private double maxPixelValue = 255.0;
    private boolean invertImage = false;
    private boolean colorSpectrum = false;
    private boolean autoScale = false;
    public int[] scaleTable = new int[256];
    private String scaleType = "linear";

    public PixieImageRGBPlotterNoSwing() {
        int ii = 0;
        while (ii < 256) {
            this.scaleTable[ii] = ii;
            ++ii;
        }
    }

    public PixieImageRGBPlotterNoSwing(ImageIcon imageIcon) {
        this();
        this.setImages(imageIcon);
    }

    public BufferedImage makeBufferedImage() {
        int nrows = this.redImage.getRowCount();
        int ncols = this.redImage.getColCount();
        double[][] redPixelArray = this.redImage.getPix();
        double[][] greenPixelArray = this.greenImage.getPix();
        double[][] bluePixelArray = this.blueImage.getPix();
        BufferedImage bi = new BufferedImage(ncols, nrows, 2);
        int ii = 0;
        while (ii < nrows) {
            int ij = 0;
            while (ij < ncols) {
                bi.setRGB(ij, nrows - 1 - ii, this.getRGBValue(redPixelArray[ii][ij], greenPixelArray[ii][ij], bluePixelArray[ii][ij]));
                ++ij;
            }
            ++ii;
        }
        return bi;
    }

    public void toPNGFile(File outputFile) {
        BufferedImage bi = this.makeBufferedImage();
        try {
            ImageIO.write((RenderedImage)bi, "png", outputFile);
        }
        catch (IOException e) {
            System.out.println("Problems writing PNG file");
        }
    }

    public void toPNGFile(String outputFileName) {
        File outputFile = new File(outputFileName);
        this.toPNGFile(outputFile);
    }

    public void setScaleTable(PixieImage pi) {
        int iindex;
        double dindex;
        int ii;
        if (this.scaleType.equals("linear")) {
            ii = 0;
            while (ii < 256) {
                this.scaleTable[ii] = ii;
                ++ii;
            }
        }
        if (this.scaleType.equals("log")) {
            ii = 0;
            while (ii < 256) {
                dindex = ii;
                dindex = 1.0 + 47.0 * dindex / 255.0;
                iindex = (int)(dindex = 255.0 * Math.log(dindex) / Math.log(48.0));
                if (iindex < 0) {
                    iindex = 0;
                }
                if (iindex > 255) {
                    iindex = 255;
                }
                this.scaleTable[ii] = iindex;
                ++ii;
            }
        }
        if (this.scaleType.equals("asinh")) {
            ii = 0;
            while (ii < 256) {
                dindex = ii;
                iindex = (int)(dindex = 255.0 * this.asinh(47.0 * dindex / 255.0) / this.asinh(47.0));
                if (iindex < 0) {
                    iindex = 0;
                }
                if (iindex > 255) {
                    iindex = 255;
                }
                this.scaleTable[ii] = iindex;
                ++ii;
            }
        }
        if (this.scaleType.equals("sqrt")) {
            ii = 0;
            while (ii < 256) {
                dindex = ii;
                iindex = (int)(dindex = 255.0 * Math.sqrt(dindex / 255.0));
                if (iindex < 0) {
                    iindex = 0;
                }
                if (iindex > 255) {
                    iindex = 255;
                }
                this.scaleTable[ii] = iindex;
                ++ii;
            }
        }
        if (this.scaleType.equals("hist") && pi != null) {
            this.makeHistEqScaleTable(pi);
        }
    }

    double asinh(double x) {
        return Math.log(x + Math.sqrt(x * x + 1.0));
    }

    public void quantizeScaleTable(int steps) {
        if (steps < 2) {
            return;
        }
        int[] xbreak = new int[steps];
        int[] ybreak = new int[steps];
        int icount = 0;
        int ii = 0;
        while (ii < steps) {
            double yb = 255.0 * (double)(ii + 1) / (double)steps;
            ybreak[ii] = (int)yb;
            boolean ibreakFound = false;
            while (!ibreakFound && icount < 256) {
                if (this.scaleTable[icount] > ybreak[ii]) {
                    ibreakFound = true;
                    xbreak[ii] = icount++;
                    continue;
                }
                ++icount;
            }
            ++ii;
        }
        xbreak[steps - 1] = 255;
        int ystep = 255 / (2 * steps);
        int istep = 255 / steps;
        icount = 0;
        int ii2 = 0;
        while (ii2 < steps) {
            int ij = icount;
            while (ij <= xbreak[ii2]) {
                this.scaleTable[ij] = ystep;
                ++ij;
            }
            icount = xbreak[ii2] + 1;
            ystep += istep;
            ++ii2;
        }
    }

    private int getRGBValue(double redPixValue, double greenPixValue, double bluePixValue) {
        Color clr = null;
        if (this.colorSpectrum) {
            double hue = this.convertTo256(redPixValue);
            hue = 0.75 - 0.75 * (hue / 255.0);
            clr = Color.getHSBColor((float)hue, 1.0f, 1.0f);
        } else {
            clr = new Color(this.convertTo256(redPixValue), this.convertTo256(greenPixValue), this.convertTo256(bluePixValue));
        }
        return clr.getRGB();
    }

    private int convertTo256(double pixValue) {
        double dindex = 255.0 * (pixValue - this.minPixelValue) / (this.maxPixelValue - this.minPixelValue);
        int i256 = (int)(dindex = Math.floor(dindex));
        if (i256 < 0) {
            i256 = 0;
        }
        if (i256 > 255) {
            i256 = 255;
        }
        i256 = this.scaleTable[i256];
        if (this.invertImage) {
            i256 = 255 - i256;
        }
        return i256;
    }

    private int[] binPixels(PixieImage pi, int numBins) {
        int[] bins = new int[numBins];
        int nrows = pi.getRowCount();
        int ncols = pi.getColCount();
        double[][] pix = pi.getPix();
        double binSize = (this.maxPixelValue - this.minPixelValue) / (double)numBins;
        int ii = 0;
        while (ii < numBins) {
            bins[ii] = 0;
            ++ii;
        }
        ii = 0;
        while (ii < nrows) {
            int ij = 0;
            while (ij < ncols) {
                double bin = pix[ii][ij] - this.minPixelValue;
                if ((bin /= binSize) - Math.floor(bin) > 0.5) {
                    bin = Math.floor(bin) + 1.0;
                } else {
                    Math.floor(bin);
                }
                if (bin < 0.0) {
                    bin = 0.0;
                }
                if (bin > (double)(numBins - 1)) {
                    bin = numBins - 1;
                }
                bins[(int)bin] = bins[(int)bin] + 1;
                ++ij;
            }
            ++ii;
        }
        return bins;
    }

    private void makeHistEqScaleTable(PixieImage pi) {
        double[] transfer = new double[256];
        int[] bins = this.binPixels(pi, 256);
        transfer[0] = bins[0];
        int ii = 1;
        while (ii < 256) {
            transfer[ii] = transfer[ii - 1] + (double)bins[ii];
            ++ii;
        }
        ii = 0;
        while (ii < 256) {
            transfer[ii] = 255.0 * transfer[ii] / transfer[255];
            ++ii;
        }
        ii = 0;
        while (ii < 256) {
            this.scaleTable[ii] = (int)transfer[ii];
            if (this.scaleTable[ii] < 0) {
                this.scaleTable[ii] = 0;
            }
            if (this.scaleTable[ii] > 255) {
                this.scaleTable[ii] = 255;
            }
            ++ii;
        }
    }

    public void copyScaling(PixieImageRGBPlotterNoSwing pixelImageRGBPlotter) {
        this.minPixelValue = pixelImageRGBPlotter.minPixelValue;
        this.maxPixelValue = pixelImageRGBPlotter.maxPixelValue;
        this.invertImage = pixelImageRGBPlotter.invertImage;
        this.colorSpectrum = pixelImageRGBPlotter.colorSpectrum;
        this.autoScale = pixelImageRGBPlotter.autoScale;
        int ii = 0;
        while (ii < 256) {
            this.scaleTable[ii] = pixelImageRGBPlotter.scaleTable[ii];
            ++ii;
        }
        this.scaleType = new String(pixelImageRGBPlotter.scaleType);
    }

    public void setImages(PixieImage redImage, PixieImage greenImage, PixieImage blueImage) {
        this.redImage = redImage;
        this.greenImage = greenImage;
        this.blueImage = blueImage;
    }

    public void setImages(PixieImage redImage) {
        this.redImage = redImage;
        this.greenImage = redImage;
        this.blueImage = redImage;
    }

    public void setImages(ImageIcon imageIcon) {
        Image image = imageIcon.getImage();
        BufferedImage bi = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
        Graphics2D graphics2D = bi.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        this.setImages(bi);
        this.setPixelValueLimits(0.0, 255.0);
    }

    public void setImages(BufferedImage bi) {
        int height = bi.getHeight();
        int width = bi.getWidth();
        int minX = bi.getMinX();
        int minY = bi.getMinY();
        this.redImage = new PixieImage(height, width);
        this.greenImage = new PixieImage(height, width);
        this.blueImage = new PixieImage(height, width);
        int ii = 0;
        while (ii < height) {
            int ij = 0;
            while (ij < width) {
                int irgb = bi.getRGB(minX + ij, minY + ii);
                Color clr = new Color(irgb);
                Pixie pix = new Pixie();
                pix.setRow(height - 1 - ii);
                pix.setCol(ij);
                pix.setCompVal(clr.getBlue());
                this.blueImage.setPixieValue(pix);
                pix.setCompVal(clr.getGreen());
                this.greenImage.setPixieValue(pix);
                pix.setCompVal(clr.getRed());
                this.redImage.setPixieValue(pix);
                ++ij;
            }
            ++ii;
        }
    }

    public void colorToBw() {
        int nrows = this.redImage.getRowCount();
        int ncols = this.redImage.getColCount();
        double[][] redPixelArray = this.redImage.getPix();
        double[][] greenPixelArray = this.greenImage.getPix();
        double[][] bluePixelArray = this.blueImage.getPix();
        int ii = 0;
        while (ii < nrows) {
            int ij = 0;
            while (ij < ncols) {
                double dval = redPixelArray[ii][ij] + greenPixelArray[ii][ij] + bluePixelArray[ii][ij];
                redPixelArray[ii][ij] = dval /= 3.0;
                greenPixelArray[ii][ij] = dval;
                bluePixelArray[ii][ij] = dval;
                ++ij;
            }
            ++ii;
        }
        redPixelArray = null;
        greenPixelArray = null;
        bluePixelArray = null;
    }

    public void setPixelValueLimits(double minPixelValue, double maxPixelValue) {
        this.minPixelValue = minPixelValue;
        this.maxPixelValue = maxPixelValue;
    }

    public void setPixelValueLimits(PixieImage pi) {
        if (!this.autoScale) {
            return;
        }
        double[] minMaxSumMean = pi.findMinMaxSumMean();
        this.minPixelValue = minMaxSumMean[0];
        this.maxPixelValue = minMaxSumMean[1];
        int[] pixelBin = this.binPixels(pi, 256);
        int i2p5 = pi.getRowCount() * pi.getColCount() * 1;
        i2p5 /= 1000;
        int imax = 255;
        int isum = pixelBin[imax];
        while (isum < i2p5) {
            isum += pixelBin[--imax];
        }
        int imin = 0;
        isum = pixelBin[imin];
        while (isum < i2p5) {
            isum += pixelBin[++imin];
        }
        double dmin = this.minPixelValue + (this.maxPixelValue - this.minPixelValue) * (double)imin / 255.0;
        double dmax = this.minPixelValue + (this.maxPixelValue - this.minPixelValue) * (double)imax / 255.0;
        this.minPixelValue = dmin;
        this.maxPixelValue = dmax;
    }

    public void setInvertImage(boolean invertImage) {
        this.invertImage = invertImage;
    }

    public boolean getInvertImage() {
        return this.invertImage;
    }

    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    public boolean getColorSpectrum() {
        return this.colorSpectrum;
    }

    public void setColorSpectrum(boolean colorSpectrum) {
        this.colorSpectrum = colorSpectrum;
    }

    public boolean getAutoScale() {
        return this.autoScale;
    }

    public void setScaleType(String scaleType) {
        this.scaleType = new String(scaleType);
    }

    public double getMinPixelValue() {
        return this.minPixelValue;
    }

    public double getMaxPixelValue() {
        return this.maxPixelValue;
    }

    public PixieImage getRedImage() {
        PixieImage pi = new PixieImage(this.redImage);
        return pi;
    }

    public PixieImage getBlueImage() {
        PixieImage pi = new PixieImage(this.blueImage);
        return pi;
    }

    public PixieImage getGreenImage() {
        PixieImage pi = new PixieImage(this.greenImage);
        return pi;
    }
}

