/*
 * Decompiled with CFR 0.152.
 */
package com.astrofizzbizz.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class FileReaderUtilities {
    public static final DecimalFormat twoPlaces = new DecimalFormat("###.##");
    public static final DecimalFormat fourPlaces = new DecimalFormat("###.####");
    public static final DecimalFormat zeroPlaces = new DecimalFormat("###");
    public static final String delim = System.getProperty("file.separator");
    public static final String newline = System.getProperty("line.separator");

    public static String[] readFile(String aFileName) throws IOException {
        File aFile = new File(aFileName);
        BufferedReader input = new BufferedReader(new FileReader(aFile));
        ArrayList<String> outputBuffer = new ArrayList<String>();
        try {
            String line = null;
            while ((line = input.readLine()) != null) {
                outputBuffer.add(line);
            }
        }
        finally {
            input.close();
        }
        int nlines = outputBuffer.size();
        String[] status = null;
        if (nlines < 1) {
            status = new String[]{""};
        } else {
            status = new String[nlines];
            int il = 0;
            while (il < nlines) {
                status[il] = (String)outputBuffer.get(il);
                ++il;
            }
        }
        return status;
    }

    public static ArrayList<String[]> readCsvFile(String csvFileName) throws IOException {
        String[] fileData = FileReaderUtilities.readFile(csvFileName);
        ArrayList<String[]> outputBuffer = new ArrayList<String[]>();
        int il = 0;
        while (il < fileData.length) {
            outputBuffer.add(fileData[il].split(","));
            ++il;
        }
        return outputBuffer;
    }

    public static String stripWhiteSpaces(String whitey) {
        int numChar = 0;
        int ii = 0;
        while (ii < whitey.length()) {
            if (whitey.charAt(ii) != ' ') {
                ++numChar;
            }
            ++ii;
        }
        if (numChar == 0) {
            return "";
        }
        char[] slimJimArray = new char[numChar];
        int iChar = 0;
        int ii2 = 0;
        while (ii2 < whitey.length()) {
            if (whitey.charAt(ii2) != ' ') {
                slimJimArray[iChar] = whitey.charAt(ii2);
                ++iChar;
            }
            ++ii2;
        }
        return new String(slimJimArray);
    }

    public static void main(String[] args) throws IOException {
        String directory = "C:\\Dropbox\\McGinnisFiles\\ESS\\TraceWin\\ScOnly";
        String fileName = "paramVary.csv";
        ArrayList<String[]> csvData = FileReaderUtilities.readCsvFile(String.valueOf(directory) + delim + fileName);
        int il = 0;
        while (il < csvData.size()) {
            int ic = 0;
            while (ic < csvData.get(il).length) {
                System.out.print(String.valueOf(csvData.get(il)[ic]) + "\t");
                ++ic;
            }
            System.out.print("\n");
            ++il;
        }
    }
}

