/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.IOException;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.RandomAccess;

public abstract class Data
implements FitsElement {
    protected long fileOffset = -1L;
    protected long dataSize;
    protected RandomAccess input;

    @Override
    public long getFileOffset() {
        return this.fileOffset;
    }

    protected void setFileOffset(Object o) {
        if (o instanceof RandomAccess) {
            this.fileOffset = FitsUtil.findOffset(o);
            this.dataSize = this.getTrueSize();
            this.input = (RandomAccess)o;
        }
    }

    @Override
    public abstract void write(ArrayDataOutput var1) throws FitsException;

    @Override
    public abstract void read(ArrayDataInput var1) throws FitsException;

    @Override
    public void rewrite() throws FitsException {
        if (!this.rewriteable()) {
            throw new FitsException("Illegal attempt to rewrite data");
        }
        FitsUtil.reposition(this.input, this.fileOffset);
        this.write((ArrayDataOutput)((Object)this.input));
        try {
            ((ArrayDataOutput)((Object)this.input)).flush();
        }
        catch (IOException e) {
            throw new FitsException("Error in rewrite flush: " + e);
        }
    }

    @Override
    public boolean reset() {
        try {
            FitsUtil.reposition(this.input, this.fileOffset);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean rewriteable() {
        return this.input != null && this.fileOffset >= 0L && (this.getTrueSize() + 2879L) / 2880L == (this.dataSize + 2879L) / 2880L;
    }

    abstract long getTrueSize();

    @Override
    public long getSize() {
        return FitsUtil.addPadding(this.getTrueSize());
    }

    public abstract Object getData() throws FitsException;

    public Object getKernel() throws FitsException {
        return this.getData();
    }

    abstract void fillHeader(Header var1) throws FitsException;
}

